/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.config.ArchivingSettingsManager;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PreDestroy;
import org.joda.time.LocalDateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005eg\u0001B\f\u0019\u0001\u0005B\u0001\u0002\r\u0001\u0003\u0006\u0004%\t!\r\u0005\tm\u0001\u0011\t\u0011)A\u0005e!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003:\u0011!\u0001\u0005A!b\u0001\n\u0003\t\u0005\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u000b\u0019\u0003A\u0011A$\t\u000fm\u0003!\u0019!C\u00059\"1\u0011\u000e\u0001Q\u0001\nuCqA\u001b\u0001C\u0002\u0013%1\u000e\u0003\u0004s\u0001\u0001\u0006I\u0001\u001c\u0005\u0006g\u0002!\t\u0001\u001e\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0011\u001d\t\t\u0001\u0001C\u0001\u0003SAq!!\f\u0001\t\u0013\ty\u0003C\u0004\u0002v\u0001!I!a\u001e\t\u000f\u0005e\u0005\u0001\"\u0003\u0002\u001c\"9\u00111\u0016\u0001\u0005\n\u00055\u0006bBAX\u0001\u0011%\u0011\u0011\u0006\u0005\b\u0003c\u0003A\u0011BAZ\u0011\u001d\t9\f\u0001C\u0005\u0003SAq!!/\u0001\t\u0013\tIC\u0001\rBe\u000eD\u0017N^5oON\u001b\u0007.\u001a3vY\u0016\u001cVM\u001d<jG\u0016T!!\u0007\u000e\u0002\u000fM,'O^5dK*\u00111\u0004H\u0001\nq2\u0014X\r\\3bg\u0016T!!\b\u0010\u0002\u0013a,'-[1mC\n\u001c(\"A\u0010\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\u0011\u0003\u0006\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VM\u001a\t\u0003S9j\u0011A\u000b\u0006\u0003W1\nQa\u001d7gi)T\u0011!L\u0001\tOJL'P\u001f7fI&\u0011qF\u000b\u0002\b\u0019><w-\u001b8h\u0003A\t'o\u00195jm&twmU3sm&\u001cW-F\u00013!\t\u0019D'D\u0001\u0019\u0013\t)\u0004D\u0001\tBe\u000eD\u0017N^5oON+'O^5dK\u0006\t\u0012M]2iSZLgnZ*feZL7-\u001a\u0011\u0002\u001f\u0005\u00148\r[5wS:<7i\u001c8gS\u001e,\u0012!\u000f\t\u0003uuj\u0011a\u000f\u0006\u0003yi\taaY8oM&<\u0017B\u0001 <\u0005a\t%o\u00195jm&twmU3ui&twm]'b]\u0006<WM]\u0001\u0011CJ\u001c\u0007.\u001b<j]\u001e\u001cuN\u001c4jO\u0002\nAC]3mK\u0006\u001cXmU3be\u000eD7+\u001a:wS\u000e,W#\u0001\"\u0011\u0005M\u001a\u0015B\u0001#\u0019\u0005Q\u0011V\r\\3bg\u0016\u001cV-\u0019:dQN+'O^5dK\u0006)\"/\u001a7fCN,7+Z1sG\"\u001cVM\u001d<jG\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003I\u0013*[\u0005CA\u001a\u0001\u0011\u0015\u0001t\u00011\u00013\u0011\u00159t\u00011\u0001:\u0011\u0015\u0001u\u00011\u0001CQ\t9Q\n\u0005\u0002O36\tqJ\u0003\u0002Q#\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005I\u001b\u0016a\u00024bGR|'/\u001f\u0006\u0003)V\u000bQAY3b]NT!AV,\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001W\u0001\u0004_J<\u0017B\u0001.P\u0005%\tU\u000f^8xSJ,G-A\tjg\u000e\u000bgnY3m%\u0016\fX/Z:uK\u0012,\u0012!\u0018\t\u0003=\u001el\u0011a\u0018\u0006\u0003A\u0006\fa!\u0019;p[&\u001c'B\u00012d\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003I\u0016\fA!\u001e;jY*\ta-\u0001\u0003kCZ\f\u0017B\u00015`\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006\u0011\u0012n]\"b]\u000e,GNU3rk\u0016\u001cH/\u001a3!\u0003U\t'o\u00195jm\u0016Le\u000e\u0015:pOJ,7o\u001d'pG.,\u0012\u0001\u001c\t\u0003[Bl\u0011A\u001c\u0006\u0003_\u0016\fA\u0001\\1oO&\u0011\u0011O\u001c\u0002\u0007\u001f\nTWm\u0019;\u0002-\u0005\u00148\r[5wK&s\u0007K]8he\u0016\u001c8\u000fT8dW\u0002\n1dZ3u\u0003J\u001c\u0007.\u001b<j]\u001eTuNY\"s_:\u001c6\r[3ek2,W#A;\u0011\u0005YlhBA<|!\tAH%D\u0001z\u0015\tQ\b%\u0001\u0004=e>|GOP\u0005\u0003y\u0012\na\u0001\u0015:fI\u00164\u0017B\u0001@\u0000\u0005\u0019\u0019FO]5oO*\u0011A\u0010J\u0001\u0017aJ|7-Z:t\u000bb\u0004\u0018N]3e%\u0016dW-Y:fgR!\u0011QAA\u0006!\r\u0019\u0013qA\u0005\u0004\u0003\u0013!#\u0001B+oSRDq!!\u0004\u000e\u0001\u0004\ty!A\nsK2,\u0017m]3BO\u0016$v.\u0011:dQ&4X\rE\u0002n\u0003#I1!a\u0005o\u0005\u001dIe\u000e^3hKJD3!DA\f!\u0011\tI\"!\n\u000e\u0005\u0005m!b\u0001)\u0002\u001e)!\u0011qDA\u0011\u0003\u001diW\r\u001e:jGNT1!a\t\u001f\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BA\u0014\u00037\u0011Q\u0001V5nK\u0012$\"!!\u0002)\u00079\t9\"\u0001\u0011gS:$\u0017I\u001c3Qe>\u001cWm]:Be\u000eD\u0017N^1cY\u0016\u0014V\r\\3bg\u0016\u001cH\u0003CA\u0019\u0003\u0007\ny%!\u0017\u0015\t\u0005M\u0012\u0011\b\t\u0004G\u0005U\u0012bAA\u001cI\t\u0019\u0011J\u001c;\t\u000f\u0005mr\u00021\u0001\u0002>\u00051\u0011m\u0019;j_:\u0004baIA k\u0006\u0015\u0011bAA!I\tIa)\u001e8di&|g.\r\u0005\b\u0003\u000bz\u0001\u0019AA$\u0003\u0011!\u0017\r^3\u0011\t\u0005%\u00131J\u0007\u0002G&\u0019\u0011QJ2\u0003\t\u0011\u000bG/\u001a\u0005\b\u0003#z\u0001\u0019AA*\u0003I\u0011XO\\*uCJ$H+[7f\u001b&dG.[:\u0011\u0007\r\n)&C\u0002\u0002X\u0011\u0012A\u0001T8oO\"9\u00111L\bA\u0002\u0005u\u0013aC4fiJ+G.Z1tKN\u0004\u0012bIA0\u0003\u000f\ny!a\u0019\n\u0007\u0005\u0005DEA\u0005Gk:\u001cG/[8oeA)\u0011QMA8k:!\u0011qMA6\u001d\rA\u0018\u0011N\u0005\u0002K%\u0019\u0011Q\u000e\u0013\u0002\u000fA\f7m[1hK&!\u0011\u0011OA:\u0005\r\u0019V-\u001d\u0006\u0004\u0003[\"\u0013a\u00049s_\u000e,7o\u001d*fY\u0016\f7/Z:\u0015\u0011\u0005e\u00141QAG\u0003/#B!a\u001f\u0002\u0002B\u00191%! \n\u0007\u0005}DEA\u0004C_>dW-\u00198\t\u000f\u0005m\u0002\u00031\u0001\u0002>!9\u0011Q\u0011\tA\u0002\u0005\u001d\u0015A\u0003:fY\u0016\f7/Z%egB)\u0011QMAEk&!\u00111RA:\u0005!IE/\u001a:bE2,\u0007bBAH!\u0001\u0007\u0011\u0011S\u0001\u0006G>,h\u000e\u001e\t\u0004=\u0006M\u0015bAAK?\ni\u0011\t^8nS\u000eLe\u000e^3hKJDq!!\u0015\u0011\u0001\u0004\t\u0019&A\fbe\u000eD\u0017N^3D_6\u0004H.\u001a;fIJ+G.Z1tKR!\u0011QTAT!\u0019\ty*a)\u0002\u00065\u0011\u0011\u0011\u0015\u0006\u0003I\u0012JA!!*\u0002\"\n\u0019AK]=\t\r\u0005%\u0016\u00031\u0001v\u0003%\u0011X\r\\3bg\u0016LE-A\thKR\u001cV-\u0019:dQB\u000bw-Z*ju\u0016,\"!a\r\u0002\u001bMdW-\u001a9JM:+W\rZ3e\u0003)\u0011\u0018M\u001c+p_2{gn\u001a\u000b\u0005\u0003w\n)\fC\u0004\u0002RQ\u0001\r!a\u0015\u0002\u0007=4g-\u0001\u0006qe\u0016$Um\u001d;s_fD3AFA_!\u0011\ty,a2\u000e\u0005\u0005\u0005'b\u0001)\u0002D*\u0011\u0011QY\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0003\u0013\f\tM\u0001\u0006Qe\u0016$Um\u001d;s_fD3\u0001AAg!\u0011\ty-!6\u000e\u0005\u0005E'bAAj+\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005]\u0017\u0011\u001b\u0002\b'\u0016\u0014h/[2f\u0001")
public class ArchivingScheduleService
implements Logging {
    private final ArchivingService archivingService;
    private final ArchivingSettingsManager archivingConfig;
    private final ReleaseSearchService releaseSearchService;
    private final AtomicBoolean isCancelRequested;
    private final Object archiveInProgressLock;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ArchivingScheduleService archivingScheduleService = this;
        synchronized (archivingScheduleService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public ArchivingSettingsManager archivingConfig() {
        return this.archivingConfig;
    }

    public ReleaseSearchService releaseSearchService() {
        return this.releaseSearchService;
    }

    private AtomicBoolean isCancelRequested() {
        return this.isCancelRequested;
    }

    private Object archiveInProgressLock() {
        return this.archiveInProgressLock;
    }

    public String getArchivingJobCronSchedule() {
        return this.archivingConfig().getArchivingJobCronSchedule();
    }

    @Timed
    public void processExpiredReleases(Integer releaseAgeToArchive) {
        if (this.archivingConfig().getEnabled()) {
            Date expirationDate = LocalDateTime.now().minusHours(Predef$.MODULE$.Integer2int(releaseAgeToArchive)).toDate();
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(70).append("Processing completed releases older than ").append(releaseAgeToArchive).append(" hours (completed before ").append(expirationDate).append(")...").toString());
            Object object = this.archiveInProgressLock();
            synchronized (object) {
                long runStartTimeMillis = System.currentTimeMillis();
                int archivedReleasesCount = this.findAndProcessArchivableReleases(expirationDate, runStartTimeMillis, (Function2<Date, Integer, Seq<String>>)(Function2 & Serializable)(date, pageSize) -> this.archivingService().findArchivableReleaseIds((Date)date, (Integer)pageSize), (Function1<String, BoxedUnit>)(Function1 & Serializable)releaseId -> {
                    ArchivingScheduleService.$anonfun$processExpiredReleases$3(this, releaseId);
                    return BoxedUnit.UNIT;
                });
                IntRef deletedReleaseCount = IntRef.create((int)0);
                if (!this.ranTooLong(runStartTimeMillis)) {
                    deletedReleaseCount.elem = this.findAndProcessArchivableReleases(expirationDate, runStartTimeMillis, (Function2<Date, Integer, Seq<String>>)(Function2 & Serializable)(date, pageSize) -> this.releaseSearchService().findNonArchivedExpiredReleaseIds((Date)date, (Integer)pageSize), (Function1<String, BoxedUnit>)(Function1 & Serializable)releaseId -> {
                        ArchivingScheduleService.$anonfun$processExpiredReleases$6(this, releaseId);
                        return BoxedUnit.UNIT;
                    });
                }
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(38).append("Archived ").append(archivedReleasesCount).append(" and deleted ").append(deletedReleaseCount$1.elem).append(" releases in ").append(System.currentTimeMillis() - runStartTimeMillis).append(" ms").toString());
            }
            return;
        }
        this.logger().warn((Function0 & Serializable)() -> "Archiving is not enabled.");
    }

    @Timed
    public void processExpiredReleases() {
        this.processExpiredReleases(this.archivingConfig().getReleaseAgeToDeleteFromJcr());
    }

    private int findAndProcessArchivableReleases(Date date, long runStartTimeMillis, Function2<Date, Integer, Seq<String>> getReleases, Function1<String, BoxedUnit> action) {
        AtomicInteger count;
        block3: {
            count = new AtomicInteger(0);
            boolean done = false;
            while (!done && !this.isCancelRequested().get()) {
                int archivingPageSize = this.getSearchPageSize();
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(55).append("Fetching ").append(archivingPageSize).append(" completed or aborted releases from repository").toString());
                Seq releaseIds = (Seq)getReleases.apply((Object)date, (Object)Predef$.MODULE$.int2Integer(archivingPageSize));
                if (releaseIds.nonEmpty() && count.get() == 0) {
                    this.logger().info((Function0 & Serializable)() -> new StringBuilder(41).append("Archiving releases that completed before ").append(date).toString());
                }
                if (done = this.processReleases((Iterable<String>)releaseIds, count, runStartTimeMillis, action)) continue;
                if (releaseIds.isEmpty() || releaseIds.size() < archivingPageSize) {
                    this.logger().debug((Function0 & Serializable)() -> new StringBuilder(58).append("Archived only ").append(releaseIds.size()).append(" finished releases on this page: we're done.").toString());
                    done = true;
                    continue;
                }
                this.logger().debug((Function0 & Serializable)() -> new StringBuilder(61).append("Archived ").append(count.get()).append(" releases that completed before ").append(date).append(", fetching the next ").append(archivingPageSize).toString());
            }
            if (count.get() <= 0) break block3;
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(41).append("Archived ").append(count.get()).append(" releases that completed before ").append(date).toString());
        }
        return count.get();
    }

    private boolean processReleases(Iterable<String> releaseIds, AtomicInteger count, long runStartTimeMillis, Function1<String, BoxedUnit> action) {
        boolean bl;
        Object object = new Object();
        try {
            releaseIds.foreach((Function1 & Serializable)releaseId -> {
                ArchivingScheduleService.$anonfun$processReleases$1(this, object, count, action, runStartTimeMillis, releaseId);
                return BoxedUnit.UNIT;
            });
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    private Try<BoxedUnit> archiveCompletedRelease(String releaseId) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            long s = System.currentTimeMillis();
            this.archivingService().archiveRelease(releaseId);
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(26).append("Archived release [").append(releaseId).append("] in ").append(System.currentTimeMillis() - s).append(" ms").toString());
        }).recoverWith((PartialFunction)new Serializable(this, releaseId){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ArchivingScheduleService $outer;
            private final String releaseId$3;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Exception) {
                    Exception exception = (Exception)A1;
                    this.$outer.logger().error((Function0 & Serializable)() -> new StringBuilder(30).append("Could not archive release [").append($this.releaseId$3).append("]: ").append(exception.getMessage()).toString(), (Function0 & Serializable)() -> exception);
                    return (B1)new Failure((Throwable)exception);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof Exception;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.releaseId$3 = releaseId$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.xlrelease.service.ArchivingScheduleService$$anonfun$archiveCompletedRelease$3 java.lang.Exception ), $anonfun$applyOrElse$2(java.lang.Exception )}, serializedLambda);
            }
        });
    }

    private int getSearchPageSize() {
        if (Predef$.MODULE$.Integer2int(this.archivingConfig().getSearchPageSize()) > 0) {
            return Predef$.MODULE$.Integer2int(this.archivingConfig().getSearchPageSize());
        }
        return 20;
    }

    private void sleepIfNeeded() {
        if (Predef$.MODULE$.Integer2int(this.archivingConfig().getSleepSecondsBetweenReleases()) > 0) {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(55).append("Sleeping for ").append(this.archivingConfig().getSleepSecondsBetweenReleases()).append(" seconds before archiving the next release").toString());
            try {
                Thread.sleep(Predef$.MODULE$.Integer2int(this.archivingConfig().getSleepSecondsBetweenReleases()) * 1000);
            }
            catch (InterruptedException interruptedException) {
                this.logger().warn((Function0 & Serializable)() -> new StringBuilder(37).append("Sleeping for ").append(this.archivingConfig().getSleepSecondsBetweenReleases()).append(" seconds was interrupted").toString());
            }
            return;
        }
    }

    private boolean ranTooLong(long runStartTimeMillis) {
        if (Predef$.MODULE$.Integer2int(this.archivingConfig().getMaxSecondsPerRun()) > 0) {
            return System.currentTimeMillis() - runStartTimeMillis > (long)(Predef$.MODULE$.Integer2int(this.archivingConfig().getMaxSecondsPerRun()) * 1000);
        }
        return false;
    }

    private void off() {
        this.isCancelRequested().set(true);
        this.logger().debug((Function0 & Serializable)() -> "Waiting until no archiving is in progress");
        Object object = this.archiveInProgressLock();
        synchronized (object) {
            this.logger().debug((Function0 & Serializable)() -> "Archiving done, destroying ArchivingScheduleService");
        }
    }

    @PreDestroy
    private void preDestroy() {
        this.off();
    }

    public static final /* synthetic */ void $anonfun$processExpiredReleases$3(ArchivingScheduleService $this, String releaseId) {
        $this.logger().info((Function0 & Serializable)() -> new StringBuilder(20).append("Archiving release [").append(releaseId).append("]").toString());
        $this.archiveCompletedRelease(releaseId);
    }

    public static final /* synthetic */ void $anonfun$processExpiredReleases$6(ArchivingScheduleService $this, String releaseId) {
        $this.logger().info((Function0 & Serializable)() -> new StringBuilder(41).append("Deleting release [").append(releaseId).append("] marked do not archive").toString());
        $this.archiveCompletedRelease(releaseId);
    }

    public static final /* synthetic */ void $anonfun$processReleases$1(ArchivingScheduleService $this, Object nonLocalReturnKey1$1, AtomicInteger count$2, Function1 action$1, long runStartTimeMillis$2, String releaseId) {
        if ($this.isCancelRequested().get()) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
        }
        if (count$2.get() > 0) {
            $this.sleepIfNeeded();
        }
        action$1.apply((Object)releaseId);
        count$2.incrementAndGet();
        if ($this.ranTooLong(runStartTimeMillis$2)) {
            $this.logger().warn((Function0 & Serializable)() -> new StringBuilder(95).append("Archiving paused because it ran for more than ").append($this.archivingConfig().getMaxSecondsPerRun()).append(" seconds. ").append("Archiving will continue in the next run").toString());
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
        }
    }

    @Autowired
    public ArchivingScheduleService(ArchivingService archivingService, ArchivingSettingsManager archivingConfig, ReleaseSearchService releaseSearchService) {
        this.archivingService = archivingService;
        this.archivingConfig = archivingConfig;
        this.releaseSearchService = releaseSearchService;
        Logging.$init$((Logging)this);
        this.isCancelRequested = new AtomicBoolean(false);
        this.archiveInProgressLock = new Object();
    }
}

