/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.developermode;

import com.synopsys.integration.blackduck.api.manual.view.DeveloperScanComponentResultView;
import com.synopsys.integration.blackduck.developermode.DeveloperModeBdioContent;
import com.synopsys.integration.blackduck.developermode.RapidScanBdio2Reader;
import com.synopsys.integration.blackduck.developermode.RapidScanBdio2Uploader;
import com.synopsys.integration.blackduck.developermode.RapidScanWaiter;
import com.synopsys.integration.blackduck.exception.BlackDuckIntegrationException;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.rest.HttpUrl;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;

public class RapidScanService {
    public static final int DEFAULT_WAIT_INTERVAL_IN_SECONDS = 30;
    private static final String FILE_NAME_BDIO_HEADER_JSONLD = "bdio-header.jsonld";
    private RapidScanBdio2Reader bdio2Reader;
    private RapidScanWaiter rapidScanWaiter;
    private RapidScanBdio2Uploader bdio2Uploader;

    public RapidScanService(RapidScanBdio2Reader bdio2Reader, RapidScanBdio2Uploader bdio2Uploader, RapidScanWaiter rapidScanWaiter) {
        this.bdio2Reader = bdio2Reader;
        this.rapidScanWaiter = rapidScanWaiter;
        this.bdio2Uploader = bdio2Uploader;
    }

    public List<DeveloperScanComponentResultView> performDeveloperScan(File bdio2File, long timeoutInSeconds) throws IntegrationException, InterruptedException {
        return this.performDeveloperScan(bdio2File, timeoutInSeconds, 30);
    }

    public List<DeveloperScanComponentResultView> performDeveloperScan(File bdio2File, long timeoutInSeconds, int waitIntervalInSeconds) throws IntegrationException, InterruptedException {
        List<DeveloperModeBdioContent> developerModeBdioContentList = this.bdio2Reader.readBdio2File(bdio2File);
        return this.uploadFilesAndWait(developerModeBdioContentList, timeoutInSeconds, waitIntervalInSeconds);
    }

    private List<DeveloperScanComponentResultView> uploadFilesAndWait(List<DeveloperModeBdioContent> bdioFiles, long timeoutInSeconds, int waitIntervalInSeconds) throws IntegrationException, InterruptedException {
        if (bdioFiles.isEmpty()) {
            throw new IllegalArgumentException("BDIO files cannot be empty.");
        }
        DeveloperModeBdioContent header = bdioFiles.stream().filter(content -> content.getFileName().equals(FILE_NAME_BDIO_HEADER_JSONLD)).findFirst().orElseThrow(() -> new BlackDuckIntegrationException("Cannot find BDIO header filebdio-header.jsonld."));
        List remainingFiles = bdioFiles.stream().filter(content -> !content.getFileName().equals(FILE_NAME_BDIO_HEADER_JSONLD)).collect(Collectors.toList());
        int count = remainingFiles.size();
        HttpUrl url = this.bdio2Uploader.start(header);
        for (DeveloperModeBdioContent content2 : remainingFiles) {
            this.bdio2Uploader.append(url, count, content2);
        }
        this.bdio2Uploader.finish(url, count);
        return this.rapidScanWaiter.checkScanResult(url, timeoutInSeconds, waitIntervalInSeconds);
    }
}

