/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.DependencyBuilder;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.DependencyCreatedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyDeletedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.IdMatchers;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseRepository;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.DependencyCandidateCollector;
import com.xebialabs.xlrelease.service.DependencyService$IdAndStatus$;
import com.xebialabs.xlrelease.service.LockedTaskOperationChecks$;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseTreeBuilder;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import com.xebialabs.xlrelease.views.ReleaseTree;
import com.xebialabs.xlrelease.views.ReleaseTreeItem;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Service
@ScalaSignature(bytes="\u0006\u0005\r\u001df\u0001B\"E\u00015C\u0001b\u0019\u0001\u0003\u0006\u0004%\t\u0001\u001a\u0005\tW\u0002\u0011\t\u0011)A\u0005K\"AA\u000e\u0001BC\u0002\u0013\u0005Q\u000e\u0003\u0005r\u0001\t\u0005\t\u0015!\u0003o\u0011!\u0011\bA!b\u0001\n\u0003\u0019\b\u0002C<\u0001\u0005\u0003\u0005\u000b\u0011\u0002;\t\u0011a\u0004!Q1A\u0005\u0002eD\u0001\" \u0001\u0003\u0002\u0003\u0006IA\u001f\u0005\t}\u0002\u0011)\u0019!C\u0001\u007f\"Q\u0011Q\u0002\u0001\u0003\u0002\u0003\u0006I!!\u0001\t\u0015\u0005=\u0001A!b\u0001\n\u0003\t\t\u0002\u0003\u0006\u0002\u001a\u0001\u0011\t\u0011)A\u0005\u0003'A!\"a\u0007\u0001\u0005\u000b\u0007I\u0011AA\u000f\u0011)\t)\u0003\u0001B\u0001B\u0003%\u0011q\u0004\u0005\u000b\u0003O\u0001!Q1A\u0005\u0002\u0005%\u0002BCA\u0019\u0001\t\u0005\t\u0015!\u0003\u0002,!Q\u00111\u0007\u0001\u0003\u0006\u0004%\t!!\u000e\t\u0015\u0005u\u0002A!A!\u0002\u0013\t9\u0004C\u0004\u0002@\u0001!\t!!\u0011\t\u0013\u0005U\u0004A1A\u0005\u0002\u0005]\u0004\u0002CAQ\u0001\u0001\u0006I!!\u001f\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002&\"9\u0011Q\u001b\u0001\u0005\u0002\u0005]\u0007bBAq\u0001\u0011\u0005\u00111\u001d\u0005\b\u0003w\u0004A\u0011AA\u007f\u0011\u001d\u0011\t\u0002\u0001C\u0001\u0005'AqAa\u000b\u0001\t\u0003\u0011i\u0003C\u0004\u00036\u0001!IAa\u000e\t\u000f\tm\u0002\u0001\"\u0001\u0003>!9!1\b\u0001\u0005\u0002\t\r\u0003b\u0002B&\u0001\u0011%!Q\n\u0005\n\u0005C\u0002\u0011\u0013!C\u0005\u0005GB\u0011Ba\u001e\u0001#\u0003%IA!\u001f\t\u000f\tu\u0004\u0001\"\u0001\u0003\u0000!9!Q\u0011\u0001\u0005\n\t\u001d\u0005b\u0002BG\u0001\u0011\u0005!q\u0012\u0005\b\u0005C\u0003A\u0011\u0001BR\u0011\u001d\u0011)\f\u0001C\u0001\u0005o3aA!1\u0001\u0001\n\r\u0007BCA|O\tU\r\u0011\"\u0001\u0003R\"Q!1[\u0014\u0003\u0012\u0003\u0006I!!%\t\u0015\tUwE!f\u0001\n\u0003\u0011\t\u000e\u0003\u0006\u0003X\u001e\u0012\t\u0012)A\u0005\u0003#Cq!a\u0010(\t\u0003\u0011I\u000eC\u0005\u0003d\u001e\n\t\u0011\"\u0001\u0003f\"I!1^\u0014\u0012\u0002\u0013\u0005!Q\u001e\u0005\n\u0005c<\u0013\u0013!C\u0001\u0005[D\u0011Ba=(\u0003\u0003%\tE!>\t\u0013\r\u0005q%!A\u0005\u0002\r\r\u0001\"CB\u0006O\u0005\u0005I\u0011AB\u0007\u0011%\u0019IbJA\u0001\n\u0003\u001aY\u0002C\u0005\u0004*\u001d\n\t\u0011\"\u0001\u0004,!I1qF\u0014\u0002\u0002\u0013\u00053\u0011\u0007\u0005\n\u0007k9\u0013\u0011!C!\u0007oA\u0011b!\u000f(\u0003\u0003%\tea\u000f\t\u0013\rur%!A\u0005B\r}r!CB\"\u0001\u0005\u0005\t\u0012AB#\r%\u0011\t\rAA\u0001\u0012\u0003\u00199\u0005C\u0004\u0002@i\"\taa\u0018\t\u0013\re\"(!A\u0005F\rm\u0002\"CB1u\u0005\u0005I\u0011QB2\u0011%\u0019IGOA\u0001\n\u0003\u001bY\u0007C\u0004\u0004~\u0001!\taa \t\u000f\r\u001d\u0005\u0001\"\u0003\u0004\n\"91Q\u0012\u0001\u0005\u0012\r=\u0005bBBJ\u0001\u0011E1Q\u0013\u0002\u0012\t\u0016\u0004XM\u001c3f]\u000eL8+\u001a:wS\u000e,'BA#G\u0003\u001d\u0019XM\u001d<jG\u0016T!a\u0012%\u0002\u0013ad'/\u001a7fCN,'BA%K\u0003%AXMY5bY\u0006\u00147OC\u0001L\u0003\r\u0019w.\\\u0002\u0001'\u0015\u0001a\n\u0016-\\!\ty%+D\u0001Q\u0015\u0005\t\u0016!B:dC2\f\u0017BA*Q\u0005\u0019\te.\u001f*fMB\u0011QKV\u0007\u0002\t&\u0011q\u000b\u0012\u0002\u0013%\u0016dW-Y:f)J,WMQ;jY\u0012,'\u000f\u0005\u0002V3&\u0011!\f\u0012\u0002\u001d\t\u0016\u0004XM\u001c3f]\u000eL8)\u00198eS\u0012\fG/Z\"pY2,7\r^8s!\ta\u0016-D\u0001^\u0015\tqv,A\u0003tY\u001a$$NC\u0001a\u0003!9'/\u001b>{Y\u0016$\u0017B\u00012^\u0005\u001daunZ4j]\u001e\f\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z+\u0005)\u0007C\u00014j\u001b\u00059'B\u00015G\u0003)\u0011X\r]8tSR|'/_\u0005\u0003U\u001e\u0014\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0003I\u0011X\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\u0011\u0002)I,G.Z1tKN+\u0017M]2i'\u0016\u0014h/[2f+\u0005q\u0007CA+p\u0013\t\u0001HI\u0001\u000bSK2,\u0017m]3TK\u0006\u00148\r[*feZL7-Z\u0001\u0016e\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3!\u0003I\u0001H.\u00198Ji\u0016l'+\u001a9pg&$xN]=\u0016\u0003Q\u0004\"AZ;\n\u0005Y<'A\u0005)mC:LE/Z7SKB|7/\u001b;pef\f1\u0003\u001d7b]&#X-\u001c*fa>\u001c\u0018\u000e^8ss\u0002\nA\u0003Z3qK:$WM\\2z%\u0016\u0004xn]5u_JLX#\u0001>\u0011\u0005\u0019\\\u0018B\u0001?h\u0005Q!U\r]3oI\u0016t7-\u001f*fa>\u001c\u0018\u000e^8ss\u0006)B-\u001a9f]\u0012,gnY=SKB|7/\u001b;pef\u0004\u0013\u0001C3wK:$()^:\u0016\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001da)\u0001\u0004fm\u0016tGo]\u0005\u0005\u0003\u0017\t)A\u0001\u0005Fm\u0016tGOQ;t\u0003%)g/\u001a8u\u0005V\u001c\b%\u0001\buCN\\'+\u001a9pg&$xN]=\u0016\u0005\u0005M\u0001c\u00014\u0002\u0016%\u0019\u0011qC4\u0003\u001dQ\u000b7o\u001b*fa>\u001c\u0018\u000e^8ss\u0006yA/Y:l%\u0016\u0004xn]5u_JL\b%A\bqQ\u0006\u001cXMU3q_NLGo\u001c:z+\t\ty\u0002E\u0002g\u0003CI1!a\th\u0005=\u0001\u0006.Y:f%\u0016\u0004xn]5u_JL\u0018\u0001\u00059iCN,'+\u001a9pg&$xN]=!\u0003-\u0019\u0017.\u00133TKJ4\u0018nY3\u0016\u0005\u0005-\u0002cA+\u0002.%\u0019\u0011q\u0006#\u0003\u0017\rK\u0017\nZ*feZL7-Z\u0001\rG&LEmU3sm&\u001cW\rI\u0001\u0011CJ\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016,\"!a\u000e\u0011\u0007U\u000bI$C\u0002\u0002<\u0011\u0013\u0001#\u0011:dQ&4\u0018N\\4TKJ4\u0018nY3\u0002#\u0005\u00148\r[5wS:<7+\u001a:wS\u000e,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0015\u0003\u0007\n)%a\u0012\u0002J\u0005-\u0013QJA(\u0003#\n\u0019&!\u0016\u0011\u0005U\u0003\u0001\"B2\u0014\u0001\u0004)\u0007\"\u00027\u0014\u0001\u0004q\u0007\"\u0002:\u0014\u0001\u0004!\b\"\u0002=\u0014\u0001\u0004Q\bB\u0002@\u0014\u0001\u0004\t\t\u0001C\u0004\u0002\u0010M\u0001\r!a\u0005\t\u000f\u0005m1\u00031\u0001\u0002 !9\u0011qE\nA\u0002\u0005-\u0002bBA\u001a'\u0001\u0007\u0011q\u0007\u0015\u0004'\u0005e\u0003\u0003BA.\u0003cj!!!\u0018\u000b\t\u0005}\u0013\u0011M\u0001\u000bC:tw\u000e^1uS>t'\u0002BA2\u0003K\nqAZ1di>\u0014\u0018P\u0003\u0003\u0002h\u0005%\u0014!\u00022fC:\u001c(\u0002BA6\u0003[\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003_\n1a\u001c:h\u0013\u0011\t\u0019(!\u0018\u0003\u0013\u0005+Ho\\<je\u0016$\u0017\u0001G1di&4X\rR3qK:$WM\\2z'R\fG/^:fgV\u0011\u0011\u0011\u0010\t\u0007\u0003w\nY)!%\u000f\t\u0005u\u0014q\u0011\b\u0005\u0003\u007f\n))\u0004\u0002\u0002\u0002*\u0019\u00111\u0011'\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0016bAAE!\u00069\u0001/Y2lC\u001e,\u0017\u0002BAG\u0003\u001f\u00131aU3r\u0015\r\tI\t\u0015\t\u0005\u0003'\u000bYJ\u0004\u0003\u0002\u0016\u0006]\u0005cAA@!&\u0019\u0011\u0011\u0014)\u0002\rA\u0013X\rZ3g\u0013\u0011\ti*a(\u0003\rM#(/\u001b8h\u0015\r\tI\nU\u0001\u001aC\u000e$\u0018N^3EKB,g\u000eZ3oGf\u001cF/\u0019;vg\u0016\u001c\b%\u0001\u0004de\u0016\fG/\u001a\u000b\u0007\u0003O\u000b\u0019,!0\u0011\t\u0005%\u0016qV\u0007\u0003\u0003WS1!!,G\u0003\u0019!w.\\1j]&!\u0011\u0011WAV\u0005)!U\r]3oI\u0016t7-\u001f\u0005\b\u0003k3\u0002\u0019AA\\\u0003\u00119\u0017\r^3\u0011\t\u0005%\u0016\u0011X\u0005\u0005\u0003w\u000bYK\u0001\u0005HCR,G+Y:l\u0011\u001d\tyL\u0006a\u0001\u0003#\u000b!\u0003^1sO\u0016$\u0018\nZ(s-\u0006\u0014\u0018.\u00192mK\"\u001aa#a1\u0011\t\u0005\u0015\u0017\u0011[\u0007\u0003\u0003\u000fTA!a\u0018\u0002J*!\u00111ZAg\u0003\u001diW\r\u001e:jGNT1!a4K\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BAj\u0003\u000f\u0014Q\u0001V5nK\u0012\fA\"\u001e9eCR,G+\u0019:hKR$b!a*\u0002Z\u0006u\u0007bBAn/\u0001\u0007\u0011\u0011S\u0001\rI\u0016\u0004XM\u001c3f]\u000eL\u0018\n\u001a\u0005\b\u0003\u007f;\u0002\u0019AAIQ\r9\u00121Y\u0001\u0007I\u0016dW\r^3\u0015\r\u0005\u0015\u00181^A{!\ry\u0015q]\u0005\u0004\u0003S\u0004&\u0001B+oSRDq!!<\u0019\u0001\u0004\ty/A\u0004sK2,\u0017m]3\u0011\t\u0005%\u0016\u0011_\u0005\u0005\u0003g\fYKA\u0004SK2,\u0017m]3\t\u000f\u0005]\b\u00041\u0001\u0002\u0012\u0006\u0011\u0011\u000e\u001a\u0015\u00041\u0005\r\u0017!F4fi\u000e{W\u000e\u001d7fi\u0006\u0014G.Z$bi\u0016LEm\u001d\u000b\u0005\u0003s\ny\u0010C\u0004\u0003\u0002e\u0001\rAa\u0001\u0002\u000fQ\f'oZ3ugB1\u00111\u0013B\u0003\u0005\u0013IAAa\u0002\u0002 \n\u00191+\u001a;\u0011\t\u0005%&1B\u0005\u0005\u0005\u001b\tYK\u0001\u0005QY\u0006t\u0017\n^3nQ\rI\u00121Y\u0001\u001aM&tG-Q2uSZ,\u0017J\\2p[&twmR1uK&#7\u000f\u0006\u0003\u0003\u0016\t\u0015\u0002C\u0002B\f\u0005C\t\t*\u0004\u0002\u0003\u001a)!!1\u0004B\u000f\u0003\u0011)H/\u001b7\u000b\u0005\t}\u0011\u0001\u00026bm\u0006LAAa\t\u0003\u001a\t!A*[:u\u0011\u001d\u00119C\u0007a\u0001\u0003#\u000b\u0011B]3mK\u0006\u001cX-\u00133)\u0007i\t\u0019-A\u0016gS:$\u0017i\u0019;jm\u0016LenY8nS:<w)\u0019;f\u0013\u0012\u001cx+\u001b;i_V$X\t_5tiN\u001c\u0005.Z2l)\u0011\tIHa\f\t\u000f\tE2\u00041\u0001\u0002\u0012\u0006A\u0001/\u0019:f]RLE\rK\u0002\u001c\u0003\u0007\f1\u0004Z8GS:$\u0017i\u0019;jm\u0016LenY8nS:<w)\u0019;f\u0013\u0012\u001cH\u0003BA=\u0005sAqA!\r\u001d\u0001\u0004\t\t*\u0001\nhKR4\u0015-\u001b7bE2,w)\u0019;f\u0013\u0012\u001cH\u0003BA=\u0005\u007fAqAa\n\u001e\u0001\u0004\t\t\nK\u0002\u001e\u0003\u0007$B!!\u001f\u0003F!9!q\t\u0010A\u0002\t\r\u0011AD1c_J$X\r\u001a+be\u001e,Go\u001d\u0015\u0004=\u0005\r\u0017\u0001\b4j]\u0012\fE\u000e\\%oG>l\u0017N\\4EKB,g\u000eZ3oGfLEm\u001d\u000b\t\u0003s\u0012yEa\u0015\u0003X!9!\u0011K\u0010A\u0002\u0005e\u0014!\u0003;be\u001e,G/\u00133t\u0011%\u0011)f\bI\u0001\u0002\u0004\tI(\u0001\u0005ti\u0006$Xo]3t\u0011%\u0011If\bI\u0001\u0002\u0004\u0011Y&A\nsK\u001a,'/\u001a8dS:<7\t[5mIJ,g\u000eE\u0002P\u0005;J1Aa\u0018Q\u0005\u001d\u0011un\u001c7fC:\faEZ5oI\u0006cG.\u00138d_6Lgn\u001a#fa\u0016tG-\u001a8ds&#7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011)G\u000b\u0003\u0002z\t\u001d4F\u0001B5!\u0011\u0011YGa\u001d\u000e\u0005\t5$\u0002\u0002B8\u0005c\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}\u0003+\u0003\u0003\u0003v\t5$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00061c-\u001b8e\u00032d\u0017J\\2p[&tw\rR3qK:$WM\\2z\u0013\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tm$\u0006\u0002B.\u0005O\n1DZ5oI\u0006\u001bG/\u001b<f\u001fV$xm\\5oOR\u000b'oZ3u\u0013\u0012\u001cH\u0003\u0002B\u000b\u0005\u0003CqAa\n#\u0001\u0004\t\t\nK\u0002#\u0003\u0007\f\u0011DZ5oI\u0006\u001bG/\u001b<f\u001fV$xm\\5oOR\u000b'oZ3ugR!!\u0011\u0012BF!\u0019\tY(a#\u0003\n!9!qE\u0012A\u0002\u0005E\u0015AD4fiJ+G.Z1tKR\u0013X-\u001a\u000b\u0005\u0005#\u0013i\n\u0005\u0003\u0003\u0014\neUB\u0001BK\u0015\r\u00119JR\u0001\u0006m&,wo]\u0005\u0005\u00057\u0013)JA\u0006SK2,\u0017m]3Ue\u0016,\u0007b\u0002B\u0014I\u0001\u0007\u0011\u0011\u0013\u0015\u0004I\u0005\r\u0017aG;qI\u0006$XmR1uKJ+g-\u001a:f]\u000eLgn\u001a)iCN,7\u000f\u0006\u0004\u0002f\n\u0015&\u0011\u0016\u0005\b\u0005O+\u0003\u0019AAI\u0003\u00199\u0017\r^3JI\"9!1V\u0013A\u0002\t5\u0016\u0001E8sS\u001eLg\u000eV8SKN$xN]3e!!\u00119Ba,\u0003\n\t%\u0011\u0002\u0002BY\u00053\u00111!T1qQ\r)\u00131Y\u0001\u0014CJ\u001c\u0007.\u001b<f\t\u0016\u0004XM\u001c3f]\u000eLWm\u001d\u000b\u0007\u0003K\u0014ILa/\t\u000f\t\u001db\u00051\u0001\u0002\u0012\"9!Q\u0018\u0014A\u0002\u0005e\u0014!\u00043fa\u0016tG-\u001a8ds&#7\u000fK\u0002'\u0003\u0007\u00141\"\u00133B]\u0012\u001cF/\u0019;vgN1qE\u0014Bc\u0005\u0017\u00042a\u0014Bd\u0013\r\u0011I\r\u0015\u0002\b!J|G-^2u!\u0011\tYH!4\n\t\t=\u0017q\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u000b\u0003\u0003#\u000b1!\u001b3!\u0003\u0019\u0019H/\u0019;vg\u000691\u000f^1ukN\u0004CC\u0002Bn\u0005?\u0014\t\u000fE\u0002\u0003^\u001ej\u0011\u0001\u0001\u0005\b\u0003od\u0003\u0019AAI\u0011\u001d\u0011)\u000e\fa\u0001\u0003#\u000bAaY8qsR1!1\u001cBt\u0005SD\u0011\"a>.!\u0003\u0005\r!!%\t\u0013\tUW\u0006%AA\u0002\u0005E\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005_TC!!%\u0003h\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003xB!!\u0011 B\u0000\u001b\t\u0011YP\u0003\u0003\u0003~\nu\u0011\u0001\u00027b]\u001eLA!!(\u0003|\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u00111Q\u0001\t\u0004\u001f\u000e\u001d\u0011bAB\u0005!\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!1qBB\u000b!\ry5\u0011C\u0005\u0004\u0007'\u0001&aA!os\"I1q\u0003\u001a\u0002\u0002\u0003\u00071QA\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\ru\u0001CBB\u0010\u0007K\u0019y!\u0004\u0002\u0004\")\u001911\u0005)\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0004(\r\u0005\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa\u0017\u0004.!I1q\u0003\u001b\u0002\u0002\u0003\u00071qB\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003x\u000eM\u0002\"CB\fk\u0005\u0005\t\u0019AB\u0003\u0003!A\u0017m\u001d5D_\u0012,GCAB\u0003\u0003!!xn\u0015;sS:<GC\u0001B|\u0003\u0019)\u0017/^1mgR!!1LB!\u0011%\u00199\u0002OA\u0001\u0002\u0004\u0019y!A\u0006JI\u0006sGm\u0015;biV\u001c\bc\u0001BouM)!h!\u0013\u0004VAQ11JB)\u0003#\u000b\tJa7\u000e\u0005\r5#bAB(!\u00069!/\u001e8uS6,\u0017\u0002BB*\u0007\u001b\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\u00199f!\u0018\u000e\u0005\re#\u0002BB.\u0005;\t!![8\n\t\t=7\u0011\f\u000b\u0003\u0007\u000b\nQ!\u00199qYf$bAa7\u0004f\r\u001d\u0004bBA|{\u0001\u0007\u0011\u0011\u0013\u0005\b\u0005+l\u0004\u0019AAI\u0003\u001d)h.\u00199qYf$Ba!\u001c\u0004zA)qja\u001c\u0004t%\u00191\u0011\u000f)\u0003\r=\u0003H/[8o!\u001dy5QOAI\u0003#K1aa\u001eQ\u0005\u0019!V\u000f\u001d7fe!I11\u0010 \u0002\u0002\u0003\u0007!1\\\u0001\u0004q\u0012\u0002\u0014A\b4j]\u0012$U\r]3oI\u0016t7-\u001f+be\u001e,GOQ=UCJ<W\r^%e)\u0011\u0011Yn!!\t\u000f\r\ru\b1\u0001\u0002\u0012\u0006AA/\u0019:hKRLE\rK\u0002@\u0003\u0007\f\u0011bZ3u'R\fG/^:\u0015\t\u0005E51\u0012\u0005\b\u0007\u0007\u0003\u0005\u0019AAI\u0003u1\u0017N\u001c3J]B\u0013xn\u001a:fgNLenY8nS:<w)\u0019;f\u0013\u0012\u001cH\u0003BA=\u0007#CqA!\u0015B\u0001\u0004\tI(\u0001\u0006jgR+W\u000e\u001d7bi\u0016$BAa\u0017\u0004\u0018\"9\u00111\u001c\"A\u0002\u0005E\u0005f\u0001\u0001\u0004\u001cB!1QTBR\u001b\t\u0019yJ\u0003\u0003\u0004\"\u0006%\u0014AC:uKJ,w\u000e^=qK&!1QUBP\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class DependencyService
implements ReleaseTreeBuilder,
DependencyCandidateCollector,
Logging {
    private volatile DependencyService$IdAndStatus$ IdAndStatus$module;
    private final ReleaseRepository releaseRepository;
    private final ReleaseSearchService releaseSearchService;
    private final PlanItemRepository planItemRepository;
    private final DependencyRepository dependencyRepository;
    private final EventBus eventBus;
    private final TaskRepository taskRepository;
    private final PhaseRepository phaseRepository;
    private final CiIdService ciIdService;
    private final ArchivingService archivingService;
    private final scala.collection.immutable.Seq<String> activeDependencyStatuses;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public List<Dependency> findByReleaseId(String releaseId) {
        return DependencyCandidateCollector.findByReleaseId$(this, releaseId);
    }

    @Override
    @Timed
    public List<Release> findAllDependencyCandidates(String gateId) {
        return DependencyCandidateCollector.findAllDependencyCandidates$(this, gateId);
    }

    @Override
    @Timed
    public Release getDependencyCandidate(String gateId, String targetReleaseId) {
        return DependencyCandidateCollector.getDependencyCandidate$(this, gateId, targetReleaseId);
    }

    @Override
    public scala.collection.immutable.Seq<String> getReferencedCis(String gateReleaseId) {
        return DependencyCandidateCollector.getReferencedCis$(this, gateReleaseId);
    }

    @Override
    public boolean isReferencable(PlanItem planItem, scala.collection.immutable.Seq<String> referencedIds) {
        return DependencyCandidateCollector.isReferencable$(this, planItem, referencedIds);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, PlanItem item) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, item);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, TaskGroup taskGroup) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, taskGroup);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, GateTask gateTask) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, gateTask);
    }

    @Override
    public Object loadDependentRelease(Dependency dependency, String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.loadDependentRelease$(this, dependency, releaseId, dependentReleases);
    }

    @Override
    public PartialFunction<Task, ReleaseTreeItem> taskMatcher(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.taskMatcher$(this, releaseId, dependentReleases);
    }

    public DependencyService$IdAndStatus$ IdAndStatus() {
        if (this.IdAndStatus$module == null) {
            this.IdAndStatus$lzycompute$1();
        }
        return this.IdAndStatus$module;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DependencyService dependencyService = this;
        synchronized (dependencyService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseSearchService releaseSearchService() {
        return this.releaseSearchService;
    }

    public PlanItemRepository planItemRepository() {
        return this.planItemRepository;
    }

    @Override
    public DependencyRepository dependencyRepository() {
        return this.dependencyRepository;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public PhaseRepository phaseRepository() {
        return this.phaseRepository;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public scala.collection.immutable.Seq<String> activeDependencyStatuses() {
        return this.activeDependencyStatuses;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dependency create(GateTask gate, String targetIdOrVariable) {
        void var3_3;
        Checks.checkArgument((boolean)gate.isUpdatable(), (String)"You can't add a dependency to a finished gate", (Object[])new Object[0]);
        LockedTaskOperationChecks$.MODULE$.checkCreateDependency((Task)gate);
        Dependency dependency = DependencyBuilder.newDependency().withId(this.ciIdService().getUniqueId(Type.valueOf(Dependency.class), gate.getId())).build();
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
        } else {
            Object target = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTarget(target);
        }
        gate.addDependency(dependency);
        dependency.setGateTask(gate);
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().create(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyCreatedEvent(dependency));
        return var3_3;
    }

    @Timed
    public Dependency updateTarget(String dependencyId, String targetIdOrVariable) {
        String gateId = Ids.getParentId((String)dependencyId);
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        Checks.checkArgument((boolean)gate.isUpdatable(), (String)"You can't edit a dependency on a finished gate", (Object[])new Object[0]);
        LockedTaskOperationChecks$.MODULE$.checkUpdateDependency((Task)gate);
        Dependency dependency = gate.getDependencies().stream().filter(d -> {
            String string = dependencyId;
            String string2 = d.getId();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).findFirst().orElseThrow(() -> new NotFoundException(String.format("Dependency with Id '%s' not found.", dependencyId), new Object[0]));
        Dependency original = CiCloneHelper.cloneCi(dependency);
        Checks.checkArgument((!dependency.isDone() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be updated", (Object[])new Object[0]);
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(null);
        } else {
            Object newTarget = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(newTarget);
        }
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().update(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, dependency));
        return dependency;
    }

    @Timed
    public void delete(Release release, String id) {
        Option maybeDependency = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllGates()).asScala().flatMap((Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.ListHasAsScala(x$2.getDependencies()).asScala())).find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DependencyService.$anonfun$delete$2(id, x$3)));
        Dependency dependency = (Dependency)maybeDependency.getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(30).append("Repository entity [").append(id).append("] not found").toString(), new Object[0]);
        });
        GateTask gate = dependency.getGateTask();
        LockedTaskOperationChecks$.MODULE$.checkDeleteDependency((Task)gate);
        Checks.checkArgument((!dependency.isDone() || gate.isPlanned() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be deleted", (Object[])new Object[0]);
        this.dependencyRepository().delete(dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyDeletedEvent(dependency));
    }

    @Timed
    public scala.collection.immutable.Seq<String> getCompletableGateIds(Set<PlanItem> targets) {
        scala.collection.immutable.Seq doneTargetIds = ((IterableOnceOps)((IterableOps)targets.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDone()))).map((Function1 & Serializable)x$5 -> x$5.getId())).toSeq();
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(37).append("getCompletableGateIds doneTargetIds: ").append(doneTargetIds.mkString(", ")).toString());
        return (scala.collection.immutable.Seq)((IterableOps)((IterableOps)this.findInProgressIncomingGateIds((scala.collection.immutable.Seq<String>)doneTargetIds).map((Function1 & Serializable)id -> {
            void var2_2;
            GateTask item = (GateTask)this.taskRepository().findById((String)id);
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(87).append("getCompletableGateIds item ").append(item.getId()).append(": hasConditions = ").append(item.hasConditions()).append(", hasDependencies = ").append(item.hasDependencies()).append(", isOpen = ").append(item.isOpen()).append(", status = ").append(item.getStatus()).toString());
            return var2_2;
        })).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isCompletable()))).map((Function1 & Serializable)x$7 -> x$7.getId());
    }

    @Timed
    public List<String> findActiveIncomingGateIds(String releaseId) {
        Seq seq;
        if (this.releaseRepository().exists(releaseId)) {
            seq = this.doFindActiveIncomingGateIds(releaseId);
        } else {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(87).append("Release ").append(releaseId).append(" not found. It is either archived, or does not exist. Returning no dependencies").toString());
            seq = (Seq)package$.MODULE$.Seq().empty();
        }
        return CollectionConverters$.MODULE$.SeqHasAsJava(seq).asJava();
    }

    @Timed
    public scala.collection.immutable.Seq<String> findActiveIncomingGateIdsWithoutExistsCheck(String parentId) {
        return this.doFindActiveIncomingGateIds(parentId);
    }

    private scala.collection.immutable.Seq<String> doFindActiveIncomingGateIds(String parentId) {
        return (scala.collection.immutable.Seq)((SeqOps)((IterableOps)this.findAllIncomingDependencyIds((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{parentId}))), this.activeDependencyStatuses(), true).filterNot((Function1 & Serializable)dependencyId -> BoxesRunTime.boxToBoolean((boolean)this.isTemplate(dependencyId)))).map((Function1 & Serializable)x$1 -> Ids.getParentId((String)x$1))).distinct();
    }

    @Timed
    public scala.collection.immutable.Seq<String> getFailableGateIds(String releaseId) {
        scala.collection.immutable.Seq statuses = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{TaskStatus.IN_PROGRESS.name()}));
        return (scala.collection.immutable.Seq)this.dependencyRepository().findAllIncomingDependencies((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{releaseId}))), (scala.collection.immutable.Seq<String>)statuses, true).map((Function1 & Serializable)dependency -> Ids.getParentId((String)dependency.getId()));
    }

    @Timed
    public scala.collection.immutable.Seq<String> getFailableGateIds(Set<PlanItem> abortedTargets) {
        return this.findInProgressIncomingGateIds((scala.collection.immutable.Seq<String>)((IterableOnceOps)abortedTargets.map((Function1 & Serializable)x$8 -> x$8.getId())).toSeq());
    }

    private scala.collection.immutable.Seq<String> findAllIncomingDependencyIds(scala.collection.immutable.Seq<String> targetIds, scala.collection.immutable.Seq<String> statuses, boolean referencingChildren) {
        return (scala.collection.immutable.Seq)this.dependencyRepository().findAllIncomingDependencies(targetIds, statuses, referencingChildren).map((Function1 & Serializable)x$9 -> x$9.getId());
    }

    private scala.collection.immutable.Seq<String> findAllIncomingDependencyIds$default$2() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    private boolean findAllIncomingDependencyIds$default$3() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public List<String> findActiveOutgoingTargetIds(String releaseId) {
        void var2_2;
        List targetIds = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.findActiveOutgoingTargets(releaseId).map((Function1 & Serializable)x$10 -> x$10.getId())).asJava();
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Seq<PlanItem> findActiveOutgoingTargets(String releaseId) {
        void var3_3;
        List<Dependency> dependencies = this.findByReleaseId(releaseId);
        scala.collection.immutable.Seq targets = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(dependencies).asScala().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Dependency, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x1;
                Object object = A12 != null && (A1 = A12).hasResolvedTarget() && !A1.isDone() ? A1.getTarget() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Dependency x1) {
                Dependency dependency;
                Dependency dependency2 = x1;
                boolean bl = dependency2 != null && (dependency = dependency2).hasResolvedTarget() && !dependency.isDone();
                return bl;
            }
        })).toSeq();
        return var3_3;
    }

    @Timed
    public ReleaseTree getReleaseTree(String releaseId) {
        ReleaseTree releaseTree;
        if (this.archivingService().exists(releaseId)) {
            releaseTree = new ReleaseTree();
        } else {
            scala.collection.mutable.Map dependentReleases = (scala.collection.mutable.Map)Map$.MODULE$.empty();
            Release release = this.releaseRepository().findById(releaseId);
            this.toTreeItem(releaseId, (scala.collection.mutable.Map<String, ReleaseTreeItem>)dependentReleases, (PlanItem)release);
            ReleaseTree tree = new ReleaseTree();
            tree.releaseId_$eq(releaseId);
            tree.dependentReleases_$eq(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)dependentReleases.values().toList()).asJava());
            releaseTree = tree;
        }
        return releaseTree;
    }

    @Timed
    public void updateGateReferencingPhases(String gateId, Map<PlanItem, PlanItem> originToRestored) {
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        Release release = gate.getRelease();
        gate.getDependencies().forEach(dependency -> {
            block0: {
                PlanItem target = dependency.getTarget();
                if (!originToRestored.containsKey(target)) break block0;
                Dependency original = CiCloneHelper.cloneCi(dependency);
                dependency.setTarget((PlanItem)originToRestored.get(target));
                Dependency updatedDependency = this.dependencyRepository().update(release, (Dependency)dependency);
                this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, updatedDependency));
            }
        });
    }

    @Timed
    public void archiveDependencies(String releaseId, scala.collection.immutable.Seq<String> dependencyIds) {
        Release referencingRelease = this.releaseRepository().findById(releaseId);
        Buffer dependenciesToArchive = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(referencingRelease.getAllGates()).asScala().flatMap((Function1 & Serializable)x$11 -> CollectionConverters$.MODULE$.ListHasAsScala(x$11.getDependencies()).asScala())).filter((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)dependencyIds.contains((Object)d.getId())));
        dependenciesToArchive.foreach((Function1 & Serializable)x$12 -> {
            x$12.archive();
            return BoxedUnit.UNIT;
        });
        this.dependencyRepository().archive(referencingRelease, (scala.collection.immutable.Seq<Dependency>)dependenciesToArchive.toSeq());
    }

    @Timed
    public IdAndStatus findDependencyTargetByTargetId(String targetId) {
        return new IdAndStatus(this, targetId, this.getStatus(targetId));
    }

    private String getStatus(String targetId) {
        Option option;
        Option option2;
        String string;
        Option option3;
        String string2 = targetId;
        if (string2 != null && !(option3 = IdMatchers.ReleaseId$.MODULE$.unapply(string2)).isEmpty()) {
            string = this.releaseRepository().getStatus(targetId).toString();
        } else if (string2 != null && !(option2 = IdMatchers.PhaseId$.MODULE$.unapply(string2)).isEmpty()) {
            string = this.phaseRepository().getStatus(targetId).toString();
        } else if (string2 != null && !(option = IdMatchers.TaskId$.MODULE$.unapply(string2)).isEmpty()) {
            string = this.taskRepository().getStatus(targetId).toString();
        } else {
            throw new NotFoundException(new StringBuilder(35).append("Target is not plan item, targetId= ").append(targetId).toString(), new Object[0]);
        }
        return string;
    }

    public scala.collection.immutable.Seq<String> findInProgressIncomingGateIds(scala.collection.immutable.Seq<String> targetIds) {
        return (scala.collection.immutable.Seq)((SeqOps)this.findAllIncomingDependencyIds(targetIds, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{TaskStatus.IN_PROGRESS.name()}))), this.findAllIncomingDependencyIds$default$3()).map((Function1 & Serializable)x$1 -> Ids.getParentId((String)x$1))).distinct();
    }

    public boolean isTemplate(String dependencyId) {
        return this.releaseRepository().isTemplate(Ids.releaseIdFrom((String)dependencyId));
    }

    private final void IdAndStatus$lzycompute$1() {
        DependencyService dependencyService = this;
        synchronized (dependencyService) {
            if (this.IdAndStatus$module == null) {
                this.IdAndStatus$module = new DependencyService$IdAndStatus$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$delete$2(String id$1, Dependency x$3) {
        String string = x$3.getId();
        String string2 = Ids.normalizeId((String)id$1);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public DependencyService(ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, PlanItemRepository planItemRepository, DependencyRepository dependencyRepository, EventBus eventBus, TaskRepository taskRepository, PhaseRepository phaseRepository, CiIdService ciIdService, ArchivingService archivingService) {
        this.releaseRepository = releaseRepository;
        this.releaseSearchService = releaseSearchService;
        this.planItemRepository = planItemRepository;
        this.dependencyRepository = dependencyRepository;
        this.eventBus = eventBus;
        this.taskRepository = taskRepository;
        this.phaseRepository = phaseRepository;
        this.ciIdService = ciIdService;
        this.archivingService = archivingService;
        ReleaseTreeBuilder.$init$(this);
        DependencyCandidateCollector.$init$(this);
        Logging.$init$((Logging)this);
        this.activeDependencyStatuses = (scala.collection.immutable.Seq)((IterableOps)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])TaskStatus.ACTIVE_STATUSES)).$colon$plus((Object)TaskStatus.PLANNED)).map((Function1 & Serializable)x$1 -> x$1.name());
    }

    public class IdAndStatus
    implements Product,
    Serializable {
        private final String id;
        private final String status;
        public final /* synthetic */ DependencyService $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String id() {
            return this.id;
        }

        public String status() {
            return this.status;
        }

        public IdAndStatus copy(String id, String status) {
            return new IdAndStatus(this.com$xebialabs$xlrelease$service$DependencyService$IdAndStatus$$$outer(), id, status);
        }

        public String copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.status();
        }

        public String productPrefix() {
            return "IdAndStatus";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.id();
                    break;
                }
                case 1: {
                    object = this.status();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof IdAndStatus;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "id";
                    break;
                }
                case 1: {
                    string = "status";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof IdAndStatus)) return false;
            if (((IdAndStatus)object).com$xebialabs$xlrelease$service$DependencyService$IdAndStatus$$$outer() != this.com$xebialabs$xlrelease$service$DependencyService$IdAndStatus$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            IdAndStatus idAndStatus = (IdAndStatus)x$1;
            String string = this.id();
            String string2 = idAndStatus.id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.status();
            String string4 = idAndStatus.status();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!idAndStatus.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ DependencyService com$xebialabs$xlrelease$service$DependencyService$IdAndStatus$$$outer() {
            return this.$outer;
        }

        public IdAndStatus(DependencyService $outer, String id, String status) {
            this.id = id;
            this.status = status;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

