/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.commandline;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import liquibase.command.CommandResults;
import liquibase.command.CommandScope;
import liquibase.integration.commandline.LiquibaseCommandLine;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.util.StringUtil;
import picocli.CommandLine;

class CommandRunner
implements Callable<CommandResults> {
    private CommandLine.Model.CommandSpec spec;

    CommandRunner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandResults call() throws Exception {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.spec.commandLine().getCommandName());
        CommandLine parentCommand = this.spec.commandLine().getParent();
        while (!parentCommand.getCommandName().equals("liquibase")) {
            command.add(0, parentCommand.getCommandName());
            parentCommand = parentCommand.getParent();
        }
        String[] commandName = LiquibaseCommandLine.getCommandNames(this.spec.commandLine());
        for (int i2 = 0; i2 < commandName.length; ++i2) {
            commandName[i2] = StringUtil.toCamelCase(commandName[i2]);
        }
        CommandScope commandScope = new CommandScope(commandName);
        File outputFile = LiquibaseCommandLineConfiguration.OUTPUT_FILE.getCurrentValue();
        OutputStream outputStream = null;
        try {
            if (outputFile != null) {
                outputStream = new FileOutputStream(outputFile);
                commandScope.setOutput(outputStream);
            }
            CommandResults commandResults = commandScope.execute();
            return commandResults;
        }
        finally {
            if (outputStream != null) {
                outputStream.flush();
                outputStream.close();
            }
        }
    }

    public void setSpec(CommandLine.Model.CommandSpec spec) {
        this.spec = spec;
    }
}

