/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.sharding.internal;

import akka.annotation.InternalApi;
import akka.cluster.sharding.ClusterShardingSettings;
import akka.cluster.sharding.internal.DisabledEntityPassivationStrategy$;
import akka.cluster.sharding.internal.EntityPassivationStrategy;
import akka.cluster.sharding.internal.IdleCheck;
import akka.cluster.sharding.internal.IdleEntityPassivationStrategy;
import akka.cluster.sharding.internal.LeastFrequentlyUsedEntityPassivationStrategy;
import akka.cluster.sharding.internal.LeastRecentlyUsedEntityPassivationStrategy;
import akka.cluster.sharding.internal.MostRecentlyUsedEntityPassivationStrategy;
import akka.cluster.sharding.internal.SegmentedLeastRecentlyUsedEntityPassivationStrategy;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;

@InternalApi
public final class EntityPassivationStrategy$ {
    public static final EntityPassivationStrategy$ MODULE$ = new EntityPassivationStrategy$();

    public EntityPassivationStrategy apply(ClusterShardingSettings settings) {
        EntityPassivationStrategy entityPassivationStrategy;
        ClusterShardingSettings.PassivationStrategy passivationStrategy = settings.passivationStrategy();
        if (passivationStrategy instanceof ClusterShardingSettings.IdlePassivationStrategy) {
            ClusterShardingSettings.IdlePassivationStrategy idlePassivationStrategy = (ClusterShardingSettings.IdlePassivationStrategy)passivationStrategy;
            FiniteDuration timeout = idlePassivationStrategy.timeout();
            FiniteDuration interval = idlePassivationStrategy.interval();
            entityPassivationStrategy = new IdleEntityPassivationStrategy(new IdleCheck(timeout, interval));
        } else if (passivationStrategy instanceof ClusterShardingSettings.LeastRecentlyUsedPassivationStrategy) {
            ClusterShardingSettings.LeastRecentlyUsedPassivationStrategy leastRecentlyUsedPassivationStrategy = (ClusterShardingSettings.LeastRecentlyUsedPassivationStrategy)passivationStrategy;
            int limit = leastRecentlyUsedPassivationStrategy.limit();
            Seq<Object> segmented = leastRecentlyUsedPassivationStrategy.segmented();
            Option<ClusterShardingSettings.IdlePassivationStrategy> idle3 = leastRecentlyUsedPassivationStrategy.idle();
            Option idleCheck = idle3.map((Function1 & Serializable)idle2 -> new IdleCheck(idle2.timeout(), idle2.interval()));
            entityPassivationStrategy = segmented.isEmpty() ? new LeastRecentlyUsedEntityPassivationStrategy(limit, (Option<IdleCheck>)idleCheck) : new SegmentedLeastRecentlyUsedEntityPassivationStrategy(limit, segmented, (Option<IdleCheck>)idleCheck);
        } else if (passivationStrategy instanceof ClusterShardingSettings.MostRecentlyUsedPassivationStrategy) {
            ClusterShardingSettings.MostRecentlyUsedPassivationStrategy mostRecentlyUsedPassivationStrategy = (ClusterShardingSettings.MostRecentlyUsedPassivationStrategy)passivationStrategy;
            int limit = mostRecentlyUsedPassivationStrategy.limit();
            Option<ClusterShardingSettings.IdlePassivationStrategy> idle4 = mostRecentlyUsedPassivationStrategy.idle();
            Option idleCheck = idle4.map((Function1 & Serializable)idle2 -> new IdleCheck(idle2.timeout(), idle2.interval()));
            entityPassivationStrategy = new MostRecentlyUsedEntityPassivationStrategy(limit, (Option<IdleCheck>)idleCheck);
        } else if (passivationStrategy instanceof ClusterShardingSettings.LeastFrequentlyUsedPassivationStrategy) {
            ClusterShardingSettings.LeastFrequentlyUsedPassivationStrategy leastFrequentlyUsedPassivationStrategy = (ClusterShardingSettings.LeastFrequentlyUsedPassivationStrategy)passivationStrategy;
            int limit = leastFrequentlyUsedPassivationStrategy.limit();
            boolean dynamicAging = leastFrequentlyUsedPassivationStrategy.dynamicAging();
            Option<ClusterShardingSettings.IdlePassivationStrategy> idle5 = leastFrequentlyUsedPassivationStrategy.idle();
            Option idleCheck = idle5.map((Function1 & Serializable)idle2 -> new IdleCheck(idle2.timeout(), idle2.interval()));
            entityPassivationStrategy = new LeastFrequentlyUsedEntityPassivationStrategy(limit, dynamicAging, (Option<IdleCheck>)idleCheck);
        } else {
            entityPassivationStrategy = DisabledEntityPassivationStrategy$.MODULE$;
        }
        return entityPassivationStrategy;
    }

    private EntityPassivationStrategy$() {
    }
}

