/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.doc;

import java.io.PrintStream;

public class MarkdownWriter {
    final PrintStream out;

    public MarkdownWriter(PrintStream out) {
        this.out = out;
    }

    public PrintStream getPrintStream() {
        return this.out;
    }

    public void write(String s) {
        this.out.println(s);
    }

    public void writeEmptyLine() {
        this.out.println();
    }

    public void writeHeader1(String title) {
        this.out.println(String.format("# %s\n", title));
    }

    public void writeHeader2(String title) {
        this.out.println(String.format("## %s\n", title));
    }

    public void writeHeader3(String title) {
        this.out.println(String.format("### %s\n", title));
    }

    public void writeTableHeader(String ... items) {
        this.writeTableRow(items);
        for (String item : items) {
            this.out.print("| --- ");
        }
        this.out.println("|");
    }

    public void writeTableRow(String ... items) {
        for (String item : items) {
            this.out.print("| ");
            this.out.print(item);
            this.out.print(" ");
        }
        this.out.println("|");
    }

    public void writeItem(String item, Object description) {
        this.out.println(String.format("%s: %s  ", MarkdownWriter.bold(item), String.valueOf(description)));
    }

    public void writeBulletPoint(String item, Object description) {
        this.out.println(String.format("* %s: %s", item, String.valueOf(description)));
    }

    public static String bold(String text) {
        return String.format("**%s**", text);
    }

    public static String link(String text, String link) {
        return String.format("[%s](%s)", text, link);
    }

    public static String code(String text) {
        return String.format("`%s`", text);
    }

    public static String anchor(String id) {
        return String.format("#%s", id.toLowerCase());
    }
}

