/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.Arrays;
import java.util.function.IntUnaryOperator;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.IntIntConsumer;

public class Int2IntCounterMap {
    private static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private final int initialValue;
    private int resizeThreshold;
    private int size = 0;
    private int[] entries;

    public Int2IntCounterMap(int initialValue) {
        this(8, 0.65f, initialValue);
    }

    public Int2IntCounterMap(int initialCapacity, float loadFactor, int initialValue) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.initialValue = initialValue;
        this.capacity(BitUtil.findNextPositivePowerOfTwo(Math.max(8, initialCapacity)));
    }

    public int initialValue() {
        return this.initialValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    public int capacity() {
        return this.entries.length >> 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int get(int key) {
        int mask = this.entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        int value = this.initialValue;
        while (this.entries[index + 1] != this.initialValue) {
            if (this.entries[index] == key) {
                value = this.entries[index + 1];
                break;
            }
            index = Int2IntCounterMap.next(index, mask);
        }
        return value;
    }

    public int put(int key, int value) {
        if (value == this.initialValue) {
            throw new IllegalArgumentException("cannot accept initialValue");
        }
        int mask = this.entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        int oldValue = this.initialValue;
        while (this.entries[index + 1] != this.initialValue) {
            if (this.entries[index] == key) {
                oldValue = this.entries[index + 1];
                break;
            }
            index = Int2IntCounterMap.next(index, mask);
        }
        if (oldValue == this.initialValue) {
            ++this.size;
            this.entries[index] = key;
        }
        this.entries[index + 1] = value;
        this.increaseCapacity();
        return oldValue;
    }

    public int incrementAndGet(int key) {
        return this.addAndGet(key, 1);
    }

    public int decrementAndGet(int key) {
        return this.addAndGet(key, -1);
    }

    public int addAndGet(int key, int amount) {
        return this.getAndAdd(key, amount) + amount;
    }

    public int getAndIncrement(int key) {
        return this.getAndAdd(key, 1);
    }

    public int getAndDecrement(int key) {
        return this.getAndAdd(key, -1);
    }

    public int getAndAdd(int key, int amount) {
        int mask = this.entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        int oldValue = this.initialValue;
        while (this.entries[index + 1] != this.initialValue) {
            if (this.entries[index] == key) {
                oldValue = this.entries[index + 1];
                break;
            }
            index = Int2IntCounterMap.next(index, mask);
        }
        if (amount != 0) {
            int newValue;
            this.entries[index + 1] = newValue = oldValue + amount;
            if (oldValue == this.initialValue) {
                ++this.size;
                this.entries[index] = key;
                this.increaseCapacity();
            } else if (newValue == this.initialValue) {
                --this.size;
                this.compactChain(index);
            }
        }
        return oldValue;
    }

    public void forEach(IntIntConsumer consumer) {
        int length = this.entries.length;
        int remaining = this.size;
        for (int i = 1; remaining > 0 && i < length; i += 2) {
            if (this.entries[i] == this.initialValue) continue;
            consumer.accept(this.entries[i - 1], this.entries[i]);
            --remaining;
        }
    }

    public boolean containsKey(int key) {
        return this.get(key) != this.initialValue;
    }

    public boolean containsValue(int value) {
        boolean found = false;
        if (value != this.initialValue) {
            int length = this.entries.length;
            for (int i = 1; i < length; i += 2) {
                if (value != this.entries[i]) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.entries, this.initialValue);
            this.size = 0;
        }
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    public int computeIfAbsent(int key, IntUnaryOperator mappingFunction) {
        int value = this.get(key);
        if (value == this.initialValue && (value = mappingFunction.applyAsInt(key)) != this.initialValue) {
            this.put(key, value);
        }
        return value;
    }

    public int remove(int key) {
        int mask = this.entries.length - 1;
        int keyIndex = Hashing.evenHash(key, mask);
        int oldValue = this.initialValue;
        while (this.entries[keyIndex + 1] != this.initialValue) {
            if (this.entries[keyIndex] == key) {
                oldValue = this.entries[keyIndex + 1];
                this.entries[keyIndex + 1] = this.initialValue;
                --this.size;
                this.compactChain(keyIndex);
                break;
            }
            keyIndex = Int2IntCounterMap.next(keyIndex, mask);
        }
        return oldValue;
    }

    public int minValue() {
        int min = this.size == 0 ? this.initialValue : Integer.MAX_VALUE;
        int length = this.entries.length;
        for (int i = 1; i < length; i += 2) {
            int value = this.entries[i];
            if (value == this.initialValue) continue;
            min = Math.min(min, value);
        }
        return min;
    }

    public int maxValue() {
        int max = this.size == 0 ? this.initialValue : Integer.MIN_VALUE;
        int length = this.entries.length;
        for (int i = 1; i < length; i += 2) {
            int value = this.entries[i];
            if (value == this.initialValue) continue;
            max = Math.max(max, value);
        }
        return max;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int length = this.entries.length;
        for (int i = 1; i < length; i += 2) {
            int value = this.entries[i];
            if (value == this.initialValue) continue;
            sb.append(this.entries[i - 1]).append('=').append(value).append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    private static int next(int index, int mask) {
        return index + 2 & mask;
    }

    private void compactChain(int deleteKeyIndex) {
        int mask = this.entries.length - 1;
        int index = deleteKeyIndex;
        while (this.entries[(index = Int2IntCounterMap.next(index, mask)) + 1] != this.initialValue) {
            int hash = Hashing.evenHash(this.entries[index], mask);
            if ((index >= hash || hash > deleteKeyIndex && deleteKeyIndex > index) && (hash > deleteKeyIndex || deleteKeyIndex > index)) continue;
            this.entries[deleteKeyIndex] = this.entries[index];
            this.entries[deleteKeyIndex + 1] = this.entries[index + 1];
            this.entries[index + 1] = this.initialValue;
            deleteKeyIndex = index;
        }
    }

    private void capacity(int newCapacity) {
        int entriesLength = newCapacity * 2;
        if (entriesLength < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        this.entries = new int[entriesLength];
        Arrays.fill(this.entries, this.initialValue);
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int newCapacity = this.entries.length;
            this.rehash(newCapacity);
        }
    }

    private void rehash(int newCapacity) {
        int[] oldEntries = this.entries;
        int initialValue = this.initialValue;
        int length = this.entries.length;
        this.capacity(newCapacity);
        int[] newEntries = this.entries;
        int mask = this.entries.length - 1;
        for (int i = 0; i < length; i += 2) {
            int value = oldEntries[i + 1];
            if (value == initialValue) continue;
            int key = oldEntries[i];
            int index = Hashing.evenHash(key, mask);
            while (this.entries[index + 1] != initialValue) {
                index = Int2IntCounterMap.next(index, mask);
            }
            newEntries[index] = key;
            newEntries[index + 1] = value;
        }
    }
}

