/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security.authentication;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plumbing.authentication.InternalUser;
import com.xebialabs.deployit.security.User;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import com.xebialabs.xlrelease.domain.UserToken;
import com.xebialabs.xlrelease.security.authentication.PersonalAuthenticationToken;
import com.xebialabs.xlrelease.service.UserLastActiveActorService;
import com.xebialabs.xlrelease.service.UserTokenService;
import com.xebialabs.xlrelease.utils.TokenGenerator$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Marker;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component(value="xlAuthenticationProvider")
@ScalaSignature(bytes="\u0006\u0005\u00055f\u0001B\b\u0011\u0001mA\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!AQ\t\u0001B\u0001B\u0003%a\tC\u0003J\u0001\u0011\u0005!\nC\u0004Q\u0001\u0001\u0007I\u0011B)\t\u000fq\u0003\u0001\u0019!C\u0005;\"1a\r\u0001Q!\nICQa\u001a\u0001\u0005B!Dq!!\u000f\u0001\t\u0013\tY\u0004C\u0004\u0002@\u0001!I!!\u0011\t\u000f\u0005-\u0003\u0001\"\u0003\u0002N!9\u0011q\u000e\u0001\u0005B\u0005E\u0004BBAI\u0001\u0011\u0005\u0011\u000bC\u0004\u0002\u0014\u0002!\t!!&\u0003;I+G.Z1tK\u0006+H\u000f[3oi&\u001c\u0017\r^5p]B\u0013xN^5eKJT!!\u0005\n\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^5p]*\u00111\u0003F\u0001\tg\u0016\u001cWO]5us*\u0011QCF\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0006\r\u0002\u0013a,'-[1mC\n\u001c(\"A\r\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001aBE\f\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\nA\u0001\\1oO*\t\u0011%\u0001\u0003kCZ\f\u0017BA\u0012\u001f\u0005\u0019y%M[3diB\u0011Q\u0005L\u0007\u0002M)\u0011\u0011c\n\u0006\u0003'!R!!\u000b\u0016\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011aK\u0001\u0004_J<\u0017BA\u0017'\u0005Y\tU\u000f\u001e5f]RL7-\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\bCA\u00185\u001b\u0005\u0001$BA\u00193\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\u0019\u0014\u0001C4sSjTH.\u001a3\n\u0005U\u0002$a\u0002'pO\u001eLgnZ\u0001\fkN,'oU3sm&\u001cW\r\u0005\u00029y5\t\u0011H\u0003\u0002\u0014u)\u00111HF\u0001\tI\u0016\u0004Hn\\=ji&\u0011Q(\u000f\u0002\f+N,'oU3sm&\u001cW-\u0001\tvg\u0016\u0014Hk\\6f]N+'O^5dKB\u0011\u0001iQ\u0007\u0002\u0003*\u0011!\tF\u0001\bg\u0016\u0014h/[2f\u0013\t!\u0015I\u0001\tVg\u0016\u0014Hk\\6f]N+'O^5dK\u0006QRo]3s\u0019\u0006\u001cH/Q2uSZ,\u0017i\u0019;peN+'O^5dKB\u0011\u0001iR\u0005\u0003\u0011\u0006\u0013!$V:fe2\u000b7\u000f^!di&4X-Q2u_J\u001cVM\u001d<jG\u0016\fa\u0001P5oSRtD\u0003B&N\u001d>\u0003\"\u0001\u0014\u0001\u000e\u0003AAQA\u000e\u0003A\u0002]BQA\u0010\u0003A\u0002}BQ!\u0012\u0003A\u0002\u0019\u000b\u0011#Y;uQ>\u0014\u0018\u000e^5fg6\u000b\u0007\u000f]3s+\u0005\u0011\u0006CA*[\u001b\u0005!&BA+W\u0003\u001di\u0017\r\u001d9j]\u001eT!a\u0016-\u0002\u0013\u0005,H\u000f[8sSRL(BA-(\u0003\u0011\u0019wN]3\n\u0005m#&\u0001G$sC:$X\rZ!vi\"|'/\u001b;jKNl\u0015\r\u001d9fe\u0006)\u0012-\u001e;i_JLG/[3t\u001b\u0006\u0004\b/\u001a:`I\u0015\fHC\u00010e!\ty&-D\u0001a\u0015\u0005\t\u0017!B:dC2\f\u0017BA2a\u0005\u0011)f.\u001b;\t\u000f\u00154\u0011\u0011!a\u0001%\u0006\u0019\u0001\u0010J\u0019\u0002%\u0005,H\u000f[8sSRLWm]'baB,'\u000fI\u0001\rCV$\b.\u001a8uS\u000e\fG/\u001a\u000b\u0003S6\u0004\"A[6\u000e\u0003aK!\u0001\u001c-\u0003\u001d\u0005+H\u000f[3oi&\u001c\u0017\r^5p]\")a\u000e\u0003a\u0001S\u0006)Ao\\6f]\"\u001a\u0001\u0002\u001d<\u0011\u0007}\u000b8/\u0003\u0002sA\n1A\u000f\u001b:poN\u0004\"A\u001b;\n\u0005UD&aF!vi\",g\u000e^5dCRLwN\\#yG\u0016\u0004H/[8oc\u0019qr/!\u0002\u00028A\u0011\u0001p \b\u0003sv\u0004\"A\u001f1\u000e\u0003mT!\u0001 \u000e\u0002\rq\u0012xn\u001c;?\u0013\tq\b-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0003\t\u0019A\u0001\u0004TiJLgn\u001a\u0006\u0003}\u0002\f\u0014bIA\u0004\u0003\u001f\ti#!\u0005\u0016\t\u0005%\u00111B\u000b\u0002o\u00129\u0011Q\u0002\u000eC\u0002\u0005]!!\u0001+\n\t\u0005E\u00111C\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u000b\u0007\u0005U\u0001-\u0001\u0004uQJ|wo]\t\u0005\u00033\ty\u0002E\u0002`\u00037I1!!\ba\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!!\t\u0002(9\u0019q,a\t\n\u0007\u0005\u0015\u0002-A\u0004qC\u000e\\\u0017mZ3\n\t\u0005%\u00121\u0006\u0002\n)\"\u0014xn^1cY\u0016T1!!\nac%\u0019\u0013qFA\u0019\u0003g\t)BD\u0002`\u0003cI1!!\u0006ac\u0015\u0011s\fYA\u001b\u0005\u0015\u00198-\u00197bc\t13/A\rbkRDWM\u001c;jG\u0006$XM\u0012:p[V\u001bXM\u001d+pW\u0016tGcA5\u0002>!)a.\u0003a\u0001o\u0006Y\u0012-\u001e;iK:$\u0018nY1uK\u001a\u0013x.\\\"sK\u0012,g\u000e^5bYN$R![A\"\u0003\u000fBa!!\u0012\u000b\u0001\u00049\u0018\u0001C;tKJt\u0017-\\3\t\r\u0005%#\u00021\u0001x\u0003!\u0001\u0018m]:x_J$\u0017aE3wC2,\u0018\r^3BkRDwN]5uS\u0016\u001cH\u0003BA(\u0003[\u0002D!!\u0015\u0002bA1\u00111KA-\u0003;j!!!\u0016\u000b\u0007\u0005]\u0003%\u0001\u0003vi&d\u0017\u0002BA.\u0003+\u0012!bQ8mY\u0016\u001cG/[8o!\u0011\ty&!\u0019\r\u0001\u0011Y\u00111M\u0006\u0002\u0002\u0003\u0005)\u0011AA3\u0005\ryFeM\t\u0005\u00033\t9\u0007E\u0002k\u0003SJ1!a\u001bY\u0005A9%/\u00198uK\u0012\fU\u000f\u001e5pe&$\u0018\u0010\u0003\u0004\u0002F-\u0001\ra^\u0001\tgV\u0004\bo\u001c:ugR!\u00111OA=!\ry\u0016QO\u0005\u0004\u0003o\u0002'a\u0002\"p_2,\u0017M\u001c\u0005\u0007#1\u0001\r!a\u001f1\t\u0005u\u0014Q\u0011\t\u0006q\u0006}\u00141Q\u0005\u0005\u0003\u0003\u000b\u0019AA\u0003DY\u0006\u001c8\u000f\u0005\u0003\u0002`\u0005\u0015E\u0001DAD\u0003s\n\t\u0011!A\u0003\u0002\u0005%%aA0%iE!\u0011\u0011DAF!\ry\u0016QR\u0005\u0004\u0003\u001f\u0003'aA!os\u0006!r-\u001a;BkRDwN]5uS\u0016\u001cX*\u00199qKJ\fAc]3u\u0003V$\bn\u001c:ji&,7/T1qa\u0016\u0014Hc\u00010\u0002\u0018\")\u0001K\u0004a\u0001%\":\u0001!a'\u0002(\u0006%\u0006\u0003BAO\u0003Gk!!a(\u000b\u0007\u0005\u0005\u0006&\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!!*\u0002 \nI1i\\7q_:,g\u000e^\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003W\u000b\u0001\u0004\u001f7BkRDWM\u001c;jG\u0006$\u0018n\u001c8Qe>4\u0018\u000eZ3s\u0001")
public class ReleaseAuthenticationProvider
implements AuthenticationProvider,
Logging {
    private final UserService userService;
    private final UserTokenService userTokenService;
    private final UserLastActiveActorService userLastActiveActorService;
    private GrantedAuthoritiesMapper authoritiesMapper;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReleaseAuthenticationProvider releaseAuthenticationProvider = this;
        synchronized (releaseAuthenticationProvider) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private GrantedAuthoritiesMapper authoritiesMapper() {
        return this.authoritiesMapper;
    }

    private void authoritiesMapper_$eq(GrantedAuthoritiesMapper x$1) {
        this.authoritiesMapper = x$1;
    }

    public Authentication authenticate(Authentication token) throws AuthenticationException {
        Authentication authentication;
        this.logger().debug((Function0 & Serializable)() -> "Authenticating for Digital.ai Release");
        try {
            authentication = token instanceof PersonalAuthenticationToken ? this.authenticateFromUserToken(token.getCredentials().toString()) : this.authenticateFromCredentials(token.getPrincipal().toString(), token.getCredentials().toString());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof AuthenticationFailureException ? true : throwable2 instanceof NotFoundException;
            if (bl) {
                throw new BadCredentialsException(throwable2.getMessage(), throwable2);
            }
            throw throwable;
        }
        return authentication;
    }

    private Authentication authenticateFromUserToken(String token) {
        this.logger().trace((Function0 & Serializable)() -> "Authenticating using personal access token");
        String tokenHash = TokenGenerator$.MODULE$.hash(token);
        UserToken userToken = (UserToken)this.userTokenService.findByUserToken(tokenHash).getOrElse((Function0 & Serializable)() -> {
            throw new AuthenticationFailureException("Cannot authenticate with supplied personal access token");
        });
        this.userLastActiveActorService.updateTokenLastUsed(userToken.ciUid());
        Collection<? extends GrantedAuthority> mappedAuthorities = this.evaluateAuthorities(userToken.username());
        return new PersonalAuthenticationToken(new InternalUser(userToken.username()), token, mappedAuthorities);
    }

    private Authentication authenticateFromCredentials(String username, String password) {
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(17).append("Authenticating [").append(username).append("]").toString());
        if (Strings.isBlank((String)username)) {
            throw new BadCredentialsException("Cannot authenticate with empty username");
        }
        this.userService.authenticate(username, password);
        Collection<? extends GrantedAuthority> mappedAuthorities = this.evaluateAuthorities(username);
        return new UsernamePasswordAuthenticationToken((Object)new InternalUser(username), (Object)password, mappedAuthorities);
    }

    private Collection<? extends GrantedAuthority> evaluateAuthorities(String username) {
        User user = this.userService.read(username);
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        Object object = user.isAdmin() || "admin".equals(user.getUsername()) ? BoxesRunTime.boxToBoolean((boolean)authorities.add(new SimpleGrantedAuthority("ROLE_ADMIN"))) : BoxedUnit.UNIT;
        return this.authoritiesMapper().mapAuthorities(authorities);
    }

    public boolean supports(Class<?> authentication) {
        return authentication.isAssignableFrom(UsernamePasswordAuthenticationToken.class) || authentication.isAssignableFrom(PersonalAuthenticationToken.class);
    }

    public GrantedAuthoritiesMapper getAuthoritiesMapper() {
        return this.authoritiesMapper();
    }

    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        this.authoritiesMapper_$eq(authoritiesMapper);
    }

    public ReleaseAuthenticationProvider(UserService userService, UserTokenService userTokenService, UserLastActiveActorService userLastActiveActorService) {
        this.userService = userService;
        this.userTokenService = userTokenService;
        this.userLastActiveActorService = userLastActiveActorService;
        Logging.$init$((Logging)this);
        this.authoritiesMapper = new NullAuthoritiesMapper();
    }
}

