/*
 * Decompiled with CFR 0.152.
 */
package io.altoo.akka.serialization.kryo;

import io.altoo.akka.serialization.kryo.Transformer;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import scala.Array$;
import scala.Function0;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00054Aa\u0003\u0007\u0001/!A!\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0011!)\u0004A!A!\u0002\u00131\u0004\"B\u001d\u0001\t\u0003Q\u0004bB \u0001\u0005\u0004%i\u0001\u0011\u0005\u0007\u0007\u0002\u0001\u000bQB!\t\r\u0011\u0003\u0001\u0015!\u0003F\u0011!y\u0005\u0001#b\u0001\n\u0013\u0001\u0006\"B-\u0001\t\u0003R\u0006\"B/\u0001\t\u0003r&!E&ss>\u001c%/\u001f9u_\u001e\u0014\u0018\r\u001d5fe*\u0011QBD\u0001\u0005WJLxN\u0003\u0002\u0010!\u0005i1/\u001a:jC2L'0\u0019;j_:T!!\u0005\n\u0002\t\u0005\\7.\u0019\u0006\u0003'Q\tQ!\u00197u_>T\u0011!F\u0001\u0003S>\u001c\u0001aE\u0002\u00011y\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0007CA\u0010!\u001b\u0005a\u0011BA\u0011\r\u0005-!&/\u00198tM>\u0014X.\u001a:\u0002\u0007-,\u0017\u0010E\u0002\u001aI\u0019J!!\n\u000e\u0003\u000b\u0005\u0013(/Y=\u0011\u0005e9\u0013B\u0001\u0015\u001b\u0005\u0011\u0011\u0015\u0010^3\u0002\t5|G-\u001a\t\u0003WIr!\u0001\f\u0019\u0011\u00055RR\"\u0001\u0018\u000b\u0005=2\u0012A\u0002\u001fs_>$h(\u0003\u000225\u00051\u0001K]3eK\u001aL!a\r\u001b\u0003\rM#(/\u001b8h\u0015\t\t$$\u0001\u0005jm2+gn\u001a;i!\tIr'\u0003\u000295\t\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)\u0011YD(\u0010 \u0011\u0005}\u0001\u0001\"\u0002\u0012\u0005\u0001\u0004\u0019\u0003\"B\u0015\u0005\u0001\u0004Q\u0003\"B\u001b\u0005\u0001\u00041\u0014!D!vi\"$\u0016m\u001a'f]\u001e$\b.F\u0001B\u001f\u0005\u0011UD\u0001\u0001\u0001\u00049\tU\u000f\u001e5UC\u001edUM\\4uQ\u0002\nqa[3z'B,7\r\u0005\u0002G\u001b6\tqI\u0003\u0002I\u0013\u0006!1\u000f]3d\u0015\tQ5*\u0001\u0004def\u0004Ho\u001c\u0006\u0002\u0019\u0006)!.\u0019<bq&\u0011aj\u0012\u0002\u000e'\u0016\u001c'/\u001a;LKf\u001c\u0006/Z2\u0002\rI\fg\u000eZ8n+\u0005\t\u0006C\u0001*X\u001b\u0005\u0019&B\u0001+V\u0003!\u0019XmY;sSRL(\"\u0001,\u0002\t)\fg/Y\u0005\u00031N\u0013AbU3dkJ,'+\u00198e_6\f\u0001\u0002^8CS:\f'/\u001f\u000b\u0003GmCQ\u0001X\u0005A\u0002\r\n\u0011\u0002\u001d7bS:$X\r\u001f;\u0002\u0015\u0019\u0014x.\u001c\"j]\u0006\u0014\u0018\u0010\u0006\u0002$?\")\u0001M\u0003a\u0001G\u0005)\u0011N\u001c9vi\u0002")
public class KryoCryptographer
implements Transformer {
    private SecureRandom random;
    private final String mode;
    private final int ivLength;
    private final SecretKeySpec keySpec;
    private volatile boolean bitmap$0;

    private final int AuthTagLength() {
        return 128;
    }

    private SecureRandom random$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.random = new SecureRandom();
                this.bitmap$0 = true;
            }
        }
        return this.random;
    }

    private SecureRandom random() {
        if (!this.bitmap$0) {
            return this.random$lzycompute();
        }
        return this.random;
    }

    @Override
    public byte[] toBinary(byte[] plaintext) {
        Cipher cipher = Cipher.getInstance(this.mode);
        byte[] iv = (byte[])Array$.MODULE$.fill(this.ivLength, (Function0)(JFunction0.mcB.sp & Serializable)() -> 0, (ClassTag)ClassTag$.MODULE$.Byte());
        this.random().nextBytes(iv);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)this.keySpec, parameterSpec);
        byte[] ciphertext = cipher.doFinal(plaintext);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + iv.length + ciphertext.length);
        byteBuffer.putInt(iv.length);
        byteBuffer.put(iv);
        byteBuffer.put(ciphertext);
        return byteBuffer.array();
    }

    @Override
    public byte[] fromBinary(byte[] input) {
        Cipher cipher = Cipher.getInstance(this.mode);
        ByteBuffer byteBuffer = ByteBuffer.wrap(input);
        int ivLength = byteBuffer.getInt();
        if (ivLength < 12 || ivLength >= 16) {
            throw new IllegalStateException("invalid iv length");
        }
        byte[] iv = new byte[ivLength];
        byteBuffer.get(iv);
        byte[] ciphertext = new byte[byteBuffer.remaining()];
        byteBuffer.get(ciphertext);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
        cipher.init(2, (Key)this.keySpec, parameterSpec);
        return cipher.doFinal(ciphertext);
    }

    public KryoCryptographer(byte[] key, String mode, int ivLength) {
        this.mode = mode;
        this.ivLength = ivLength;
        if (ivLength < 12 || ivLength >= 16) {
            throw new IllegalStateException("invalid iv length");
        }
        this.keySpec = new SecretKeySpec(key, "AES");
    }
}

