/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.api.core;

import com.synopsys.integration.blackduck.api.core.BlackDuckResponse;
import com.synopsys.integration.blackduck.api.core.ResourceLink;
import com.synopsys.integration.blackduck.api.core.ResourceMetadata;
import com.synopsys.integration.rest.HttpUrl;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;

public class BlackDuckView
extends BlackDuckResponse {
    private ResourceMetadata _meta;

    public ResourceMetadata getMeta() {
        return this._meta;
    }

    public void setMeta(ResourceMetadata meta) {
        this._meta = meta;
    }

    public boolean hasLink(String linkKey) {
        if (null == this._meta || null == this._meta.getLinks()) {
            return false;
        }
        return this._meta.getLinks().stream().map(ResourceLink::getRel).anyMatch(linkKey::equals);
    }

    public HttpUrl getFirstLink(String linkKey) {
        return this.getFirstLinkSafely(linkKey).orElseThrow(() -> new NoSuchElementException(String.format("The link key %s was not found.", linkKey)));
    }

    public Optional<HttpUrl> getFirstLinkSafely(String linkKey) {
        return this._meta.getLinks().stream().filter(resourceLink -> resourceLink.getRel().equals(linkKey)).findFirst().map(ResourceLink::getHref);
    }

    public List<HttpUrl> getLinks(String linkKey) {
        return this.getResourceLinks().stream().filter(resourceLink -> resourceLink.getRel().equals(linkKey)).map(ResourceLink::getHref).collect(Collectors.toList());
    }

    public ResourceMetadata getResourceMetadata() {
        return this._meta;
    }

    public List<ResourceLink> getResourceLinks() {
        if (null == this._meta || null == this._meta.getLinks()) {
            return Collections.emptyList();
        }
        return this._meta.getLinks();
    }

    public List<String> getAvailableLinks() {
        return this.getResourceLinks().stream().map(ResourceLink::getRel).collect(Collectors.toList());
    }

    public List<String> getAllowedMethods() {
        if (null == this._meta || null == this._meta.getAllow()) {
            return Collections.emptyList();
        }
        return this._meta.getAllow();
    }

    public HttpUrl getHref() {
        return this._meta.getHref();
    }

    public String getMediaType() {
        return "application/json";
    }
}

