/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring.config;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.ryantenney.metrics.spring.MetricsBeanPostProcessorFactory;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class AnnotationDrivenBeanDefinitionParser
implements BeanDefinitionParser {
    AnnotationDrivenBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String healthCheckBeanName;
        Object source = parserContext.extractSource((Object)element);
        CompositeComponentDefinition compDefinition = new CompositeComponentDefinition(element.getTagName(), source);
        parserContext.pushContainingComponent(compDefinition);
        String metricsBeanName = element.getAttribute("metric-registry");
        if (!StringUtils.hasText((String)metricsBeanName)) {
            metricsBeanName = this.registerComponent(parserContext, this.build(MetricRegistry.class, source, 0));
        }
        if (!StringUtils.hasText((String)(healthCheckBeanName = element.getAttribute("health-check-registry")))) {
            healthCheckBeanName = this.registerComponent(parserContext, this.build(HealthCheckRegistry.class, source, 0));
        }
        ProxyConfig proxyConfig = new ProxyConfig();
        if (StringUtils.hasText((String)element.getAttribute("expose-proxy"))) {
            proxyConfig.setExposeProxy(Boolean.valueOf(element.getAttribute("expose-proxy")).booleanValue());
        }
        if (StringUtils.hasText((String)element.getAttribute("proxy-target-class"))) {
            proxyConfig.setProxyTargetClass(Boolean.valueOf(element.getAttribute("proxy-target-class")).booleanValue());
        }
        this.registerComponent(parserContext, this.build(MetricsBeanPostProcessorFactory.class, source, 2).setFactoryMethod("exceptionMetered").addConstructorArgReference(metricsBeanName).addConstructorArgValue((Object)proxyConfig));
        this.registerComponent(parserContext, this.build(MetricsBeanPostProcessorFactory.class, source, 2).setFactoryMethod("metered").addConstructorArgReference(metricsBeanName).addConstructorArgValue((Object)proxyConfig));
        this.registerComponent(parserContext, this.build(MetricsBeanPostProcessorFactory.class, source, 2).setFactoryMethod("timed").addConstructorArgReference(metricsBeanName).addConstructorArgValue((Object)proxyConfig));
        this.registerComponent(parserContext, this.build(MetricsBeanPostProcessorFactory.class, source, 2).setFactoryMethod("counted").addConstructorArgReference(metricsBeanName).addConstructorArgValue((Object)proxyConfig));
        this.registerComponent(parserContext, this.build(MetricsBeanPostProcessorFactory.class, source, 2).setFactoryMethod("gaugeField").addConstructorArgReference(metricsBeanName));
        this.registerComponent(parserContext, this.build(MetricsBeanPostProcessorFactory.class, source, 2).setFactoryMethod("gaugeMethod").addConstructorArgReference(metricsBeanName));
        this.registerComponent(parserContext, this.build(MetricsBeanPostProcessorFactory.class, source, 2).setFactoryMethod("cachedGauge").addConstructorArgReference(metricsBeanName));
        this.registerComponent(parserContext, this.build(MetricsBeanPostProcessorFactory.class, source, 2).setFactoryMethod("metric").addConstructorArgReference(metricsBeanName));
        this.registerComponent(parserContext, this.build(MetricsBeanPostProcessorFactory.class, source, 2).setFactoryMethod("healthCheck").addConstructorArgReference(healthCheckBeanName));
        this.registerComponent(parserContext, this.build(MetricsBeanPostProcessorFactory.class, source, 2).setFactoryMethod("legacyCounted").addConstructorArgReference(metricsBeanName).addConstructorArgValue((Object)proxyConfig));
        this.registerComponent(parserContext, this.build(MetricsBeanPostProcessorFactory.class, source, 2).setFactoryMethod("legacyCachedGauge").addConstructorArgReference(metricsBeanName));
        this.registerComponent(parserContext, this.build(MetricsBeanPostProcessorFactory.class, source, 2).setFactoryMethod("legacyMetric").addConstructorArgReference(metricsBeanName));
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    private BeanDefinitionBuilder build(Class<?> klazz, Object source, int role) {
        BeanDefinitionBuilder beanDefBuilder = BeanDefinitionBuilder.rootBeanDefinition(klazz);
        beanDefBuilder.setRole(role);
        beanDefBuilder.getRawBeanDefinition().setSource(source);
        return beanDefBuilder;
    }

    private String registerComponent(ParserContext parserContext, BeanDefinitionBuilder beanDefBuilder) {
        AbstractBeanDefinition beanDef = beanDefBuilder.getBeanDefinition();
        String beanName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)beanDef);
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)beanDef, beanName));
        return beanName;
    }
}

