/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import com.xebialabs.xlrelease.scheduler.FailJob;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.JobQueueStopped;
import com.xebialabs.xlrelease.scheduler.StopWorkerThread;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.workers.CompositeWorker;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Marker;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000553A\u0001C\u0005\u0001%!Aa\u0005\u0001B\u0001B\u0003%q\u0005\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0011\u0015\u0011\u0004\u0001\"\u00014\u0011\u001d9\u0004A1A\u0005\naBaa\u0011\u0001!\u0002\u0013I\u0004\"\u0002#\u0001\t\u0003)\u0005\"\u0002'\u0001\t\u0003*%A\u0002*v]:,'O\u0003\u0002\u000b\u0017\u0005I1o\u00195fIVdWM\u001d\u0006\u0003\u00195\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u00059y\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005\u0001\u0012aA2p[\u000e\u00011\u0003\u0002\u0001\u00147y\u0001\"\u0001F\r\u000e\u0003UQ!AF\f\u0002\t1\fgn\u001a\u0006\u00021\u0005!!.\u0019<b\u0013\tQRC\u0001\u0004PE*,7\r\u001e\t\u0003)qI!!H\u000b\u0003\u0011I+hN\\1cY\u0016\u0004\"a\b\u0013\u000e\u0003\u0001R!!\t\u0012\u0002\u000bMdg\r\u000e6\u000b\u0003\r\n\u0001b\u001a:jujdW\rZ\u0005\u0003K\u0001\u0012q\u0001T8hO&tw-\u0001\u0005k_\n\fV/Z;f!\tA\u0013&D\u0001\n\u0013\tQ\u0013B\u0001\u0005K_\n\fV/Z;f\u0003=\u0019w.\u001c9pg&$XmV8sW\u0016\u0014\bCA\u00171\u001b\u0005q#BA\u0018\n\u0003\u001d9xN]6feNL!!\r\u0018\u0003\u001f\r{W\u000e]8tSR,wk\u001c:lKJ\fa\u0001P5oSRtDc\u0001\u001b6mA\u0011\u0001\u0006\u0001\u0005\u0006M\r\u0001\ra\n\u0005\u0006W\r\u0001\r\u0001L\u0001\nSN\u0014VO\u001c8j]\u001e,\u0012!\u000f\t\u0003u\u0005k\u0011a\u000f\u0006\u0003yu\na!\u0019;p[&\u001c'B\u0001 @\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u0001^\tA!\u001e;jY&\u0011!i\u000f\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u0015%\u001c(+\u001e8oS:<\u0007%\u0001\u0003ti>\u0004H#\u0001$\u0011\u0005\u001dSU\"\u0001%\u000b\u0003%\u000bQa]2bY\u0006L!a\u0013%\u0003\tUs\u0017\u000e^\u0001\u0004eVt\u0007")
public class Runner
implements Runnable,
Logging {
    private final JobQueue jobQueue;
    private final CompositeWorker compositeWorker;
    private final AtomicBoolean isRunning;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        Runner runner = this;
        synchronized (runner) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private AtomicBoolean isRunning() {
        return this.isRunning;
    }

    public void stop() {
        this.isRunning().set(false);
        this.jobQueue.submit(new StopWorkerThread());
    }

    @Override
    public void run() {
        while (this.isRunning().get()) {
            try {
                BoxedUnit boxedUnit;
                Job job;
                Job job2 = job = this.jobQueue.get();
                if (job2 instanceof StopWorkerThread) {
                    this.logger().debug((Function0 & Serializable)() -> "Thread is stopped because stop job was received");
                    this.isRunning().set(false);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (job2 instanceof FailJob) {
                    BoxedUnit boxedUnit2;
                    FailJob failJob = (FailJob)job2;
                    Job failedJob = failJob.job();
                    try {
                        boxedUnit2 = (BoxedUnit)this.compositeWorker.execute().apply((Object)job);
                    }
                    finally {
                        this.jobQueue.finish(failedJob);
                    }
                    boxedUnit = boxedUnit2;
                    continue;
                }
                if (job2 instanceof TaskJob) {
                    BoxedUnit boxedUnit3;
                    TaskJob taskJob = (TaskJob)job2;
                    try {
                        try {
                            boxedUnit3 = (BoxedUnit)this.compositeWorker.execute().apply((Object)taskJob);
                        }
                        catch (Exception e) {
                            this.logger().error((Function0 & Serializable)() -> new StringBuilder(71).append("Unhandled exception while executing ").append((Object)taskJob.jobType()).append(" ").append(taskJob.id()).append(" of task ").append(taskJob.taskId()).append(". Please report a defect.").toString(), (Function0 & Serializable)() -> e);
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                    }
                    finally {
                        this.jobQueue.finish(taskJob);
                    }
                    boxedUnit = boxedUnit3;
                    continue;
                }
                throw new MatchError((Object)job2);
            }
            catch (JobQueueStopped jobQueueStopped) {
                this.logger().info((Function0 & Serializable)() -> "Thread is being stopped because job queue is stopped");
                this.isRunning().set(false);
            }
            catch (InterruptedException interruptedException) {
                this.logger().info((Function0 & Serializable)() -> "Thread is being terminated by a shutdown");
                this.isRunning().set(false);
            }
            catch (Exception e) {
                this.logger().error((Function0 & Serializable)() -> "Unhandled exception", (Function0 & Serializable)() -> e);
            }
        }
    }

    public Runner(JobQueue jobQueue, CompositeWorker compositeWorker) {
        this.jobQueue = jobQueue;
        this.compositeWorker = compositeWorker;
        Logging.$init$((Logging)this);
        this.isRunning = new AtomicBoolean(true);
    }
}

