/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.state.NodeReferencesId;

public class NodeReferences
implements Serializable {
    static final long serialVersionUID = 7007727035982680717L;
    protected NodeReferencesId id;
    protected ArrayList references = new ArrayList();

    public NodeReferences(NodeReferencesId id) {
        this.id = id;
    }

    public NodeReferencesId getId() {
        return this.id;
    }

    public NodeId getTargetId() {
        return this.id.getTargetId();
    }

    public boolean hasReferences() {
        return !this.references.isEmpty();
    }

    public List getReferences() {
        return Collections.unmodifiableList(this.references);
    }

    public void addReference(PropertyId refId) {
        this.references.add(refId);
    }

    public void addAllReferences(List references) {
        this.references.addAll(references);
    }

    public boolean removeReference(PropertyId refId) {
        return this.references.remove(refId);
    }

    public void clearAllReferences() {
        this.references.clear();
    }
}

