import React from 'react';
import { DotThemeProvider } from '@digital-ai/dot-components';
import { mount } from 'enzyme';
import { Chip } from './chip.component';

describe('Chip', () => {
    let wrapper = undefined;

    beforeEach(() => {
        wrapper = mount(
            <DotThemeProvider>
                <Chip iconId="template" text="TEMPLATE" />
            </DotThemeProvider>,
        );
    });

    it('should render with icon and text', () => {
        expect(wrapper.find('.dot-icon .icon-template')).toExist();
        expect(wrapper.text()).toBe('TEMPLATE');
    });
});
