/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.validation;

import java.util.function.Consumer;
import liquibase.repackaged.net.sf.jsqlparser.JSQLParserException;
import liquibase.repackaged.net.sf.jsqlparser.parser.CCJSqlParserUtil;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statements;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ParseException;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationCapability;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationContext;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationException;

final class ParseCapability
implements ValidationCapability {
    public static final String NAME = "parsing";
    private String statements;
    private Statements parsedStatement;

    public ParseCapability(String string) {
        this.statements = string;
    }

    public final String getStatements() {
        return this.statements;
    }

    public final Statements getParsedStatements() {
        return this.parsedStatement;
    }

    @Override
    public final void validate(ValidationContext validationContext, Consumer<ValidationException> consumer) {
        try {
            this.parsedStatement = CCJSqlParserUtil.parseStatements(CCJSqlParserUtil.newParser(this.statements).withConfiguration(validationContext.getConfiguration()));
            return;
        }
        catch (JSQLParserException jSQLParserException) {
            consumer.accept(new ParseException("Cannot parse statement: " + jSQLParserException.getMessage(), jSQLParserException));
            return;
        }
    }

    @Override
    public final String getName() {
        return NAME;
    }
}

