/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.dto.RolePermissions;
import com.xebialabs.deployit.core.rest.api.SecurityResource;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.security.Role;
import com.xebialabs.deployit.engine.api.security.RolePrincipals;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.v1.RolesApi;
import com.xebialabs.xlrelease.api.v1.views.PrincipalView;
import com.xebialabs.xlrelease.api.v1.views.RoleView;
import com.xebialabs.xlrelease.domain.events.GlobalRolesOrPermissionsUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.UserInfoResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Controller;

@Controller
public class RolesApiImpl
implements RolesApi {
    private PermissionChecker permissions;
    private RoleService roleService;
    private SecurityResource securityResource;
    private UserInfoResolver userInfoResolver;
    private TeamService teamService;
    private XLReleaseEventBus xlReleaseEventBus;

    public RolesApiImpl(PermissionChecker permissions, RoleService roleService, SecurityResource securityResource, UserInfoResolver userInfoResolver, TeamService teamService, XLReleaseEventBus xlReleaseEventBus) {
        this.permissions = permissions;
        this.roleService = roleService;
        this.securityResource = securityResource;
        this.userInfoResolver = userInfoResolver;
        this.teamService = teamService;
        this.xlReleaseEventBus = xlReleaseEventBus;
    }

    @Timed
    public List<RoleView> getRoles(Integer page, Integer resultsPerPage) {
        Paging paging = new Paging(page + 1, resultsPerPage.intValue());
        List roles = this.roleService.getRoles(null, paging, null);
        roles.sort(Comparator.comparing(com.xebialabs.deployit.security.Role::getName));
        Map<String, RolePermissions> rolePermissions = this.permissionsByRole(this.securityResource.readRolePermissions(PermissionChecker.GLOBAL_SECURITY_ALIAS(), null, null, null));
        Map<String, RolePrincipals> rolePrincipals = this.principalsByRole(this.securityResource.readRolePrincipals(null, null, null));
        return roles.stream().map(r -> this.assembleRoleView((com.xebialabs.deployit.security.Role)r, rolePermissions, rolePrincipals)).collect(Collectors.toList());
    }

    @Timed
    public RoleView getRole(String roleName) {
        List globalRoles = this.roleService.getRoles(roleName, null, null);
        Optional<com.xebialabs.deployit.security.Role> matchingRole = globalRoles.stream().filter(role -> role.getName().equals(roleName)).findFirst();
        if (!matchingRole.isPresent()) {
            throw new NotFoundException("Could not find the role [%s]", new Object[]{roleName});
        }
        Map<String, RolePermissions> rolePermissions = this.permissionsByRole(this.securityResource.readRolePermissions(PermissionChecker.GLOBAL_SECURITY_ALIAS(), roleName, null, null));
        Map<String, RolePrincipals> rolePrincipals = this.principalsByRole(this.securityResource.readRolePrincipals(roleName, null, null));
        return this.assembleRoleView(matchingRole.get(), rolePermissions, rolePrincipals);
    }

    @Timed
    public void create(String roleName, RoleView roleView) {
        Checks.checkTrue((boolean)roleName.equals(roleView.getName()), (String)"Role name '%s' given in the path is not equal to the role '%s' defined in the provided object", (Object[])new Object[]{roleName, roleView.getName()});
        this.create(Collections.singletonList(roleView));
    }

    @Timed
    public void create(List<RoleView> roleViews) {
        this.permissions.check(PlatformPermissions.EDIT_SECURITY);
        List roleNames = roleViews.stream().map(RoleView::getName).collect(Collectors.toList());
        Optional<com.xebialabs.deployit.security.Role> role = this.roleService.getRoles().stream().filter(r -> roleNames.contains(r.getName())).findFirst();
        if (role.isPresent()) {
            throw new ItemAlreadyExistsException("Role '%s' already exist. Maybe you wanted to update it?", new Object[]{role.get().getName()});
        }
        this.checkPermissions(roleViews);
        List rolePrincipals = this.securityResource.readRolePrincipals(null, null, null);
        roleViews.forEach(roleView -> {
            String roleName = roleView.getName();
            List<String> principals = roleView.getPrincipals().stream().map(PrincipalView::getUsername).collect(Collectors.toList());
            RolePrincipals newRolePrincipal = this.newRolePrincipal(roleName, principals);
            rolePrincipals.add(newRolePrincipal);
        });
        rolePrincipals.forEach(rp -> this.teamService.generateIdIfNecessary(rp.getRole()));
        this.securityResource.writeRolePrincipals(rolePrincipals);
        Map<String, RolePrincipals> principalsByRole = this.principalsByRole(this.securityResource.readRolePrincipals(null, null, null));
        List rolePermissions = this.securityResource.readRolePermissions(PermissionChecker.GLOBAL_SECURITY_ALIAS(), null, null, null);
        roleViews.forEach(roleView -> {
            String roleName = roleView.getName();
            String roleId = ((RolePrincipals)principalsByRole.get(roleName)).getRole().getId();
            rolePermissions.add(this.newRolePermission(roleId, roleName, roleView.getPermissions()));
        });
        this.securityResource.writeRolePermissions(PermissionChecker.GLOBAL_SECURITY_ALIAS(), rolePermissions);
        this.xlReleaseEventBus.publish((XLReleaseEvent)GlobalRolesOrPermissionsUpdatedEvent.apply());
    }

    @Timed
    public void update(String roleName, RoleView roleView) {
        roleView.setName(roleName);
        this.update(Collections.singletonList(roleView));
    }

    @Timed
    public void update(List<RoleView> roleViews) {
        this.permissions.check(PlatformPermissions.EDIT_SECURITY);
        this.checkPermissions(roleViews);
        List roleNamesToUpdate = roleViews.stream().map(RoleView::getName).collect(Collectors.toList());
        List roles = this.roleService.getRoles();
        Map<String, com.xebialabs.deployit.security.Role> rolesByName = this.rolesByName(roles);
        Optional<String> firstNonExistent = roleNamesToUpdate.stream().filter(r -> !rolesByName.containsKey(r)).findFirst();
        if (firstNonExistent.isPresent()) {
            throw new LogFriendlyNotFoundException("Role '%s' does not exist. Maybe you wanted to create it?", new Object[]{firstNonExistent.get()});
        }
        List rolePrincipals = this.securityResource.readRolePrincipals(null, null, null);
        Map<String, RolePrincipals> principalsByRole = this.principalsByRole(rolePrincipals);
        roleViews.forEach(roleView -> {
            String roleName = roleView.getName();
            RolePrincipals rolePrincipal = (RolePrincipals)principalsByRole.get(roleName);
            rolePrincipal.setPrincipals(roleView.getPrincipals().stream().map(PrincipalView::getUsername).collect(Collectors.toList()));
        });
        rolePrincipals.forEach(rp -> this.teamService.generateIdIfNecessary(rp.getRole()));
        this.securityResource.writeRolePrincipals(rolePrincipals);
        List rolePermissions = this.securityResource.readRolePermissions(PermissionChecker.GLOBAL_SECURITY_ALIAS(), null, null, null);
        Map<String, RolePermissions> permissionsByRole = this.permissionsByRole(rolePermissions);
        roleViews.forEach(roleView -> {
            String roleName = roleView.getName();
            RolePermissions rolePermission = (RolePermissions)permissionsByRole.get(roleName);
            if (null == rolePermission) {
                rolePermission = this.emptyRolePermissions((com.xebialabs.deployit.security.Role)rolesByName.get(roleName));
                rolePermissions.add(rolePermission);
            }
            rolePermission.setPermissions(new ArrayList(roleView.getPermissions()));
        });
        this.securityResource.writeRolePermissions(PermissionChecker.GLOBAL_SECURITY_ALIAS(), rolePermissions);
        this.xlReleaseEventBus.publish((XLReleaseEvent)GlobalRolesOrPermissionsUpdatedEvent.apply());
    }

    @Timed
    public void delete(String roleName) {
        this.permissions.check(PlatformPermissions.EDIT_SECURITY);
        this.getRole(roleName);
        List rolePrincipals = this.securityResource.readRolePrincipals(roleName, null, null);
        rolePrincipals.removeIf(rolePrincipal -> roleName.equals(rolePrincipal.getRole().getName()));
        this.securityResource.writeRolePrincipals(rolePrincipals);
        this.xlReleaseEventBus.publish((XLReleaseEvent)GlobalRolesOrPermissionsUpdatedEvent.apply());
    }

    @Timed
    public void rename(String roleName, String newName) {
        this.permissions.check(PlatformPermissions.EDIT_SECURITY);
        Optional<com.xebialabs.deployit.security.Role> role = this.roleService.getRoles().stream().filter(r -> r.getName().equals(roleName)).findFirst();
        if (!role.isPresent()) {
            throw new LogFriendlyNotFoundException("Role '%s' does not exist. Maybe you wanted to create it first?", new Object[]{roleName});
        }
        Optional<com.xebialabs.deployit.security.Role> targetRole = this.roleService.getRoles().stream().filter(r -> r.getName().equals(newName)).findFirst();
        if (targetRole.isPresent()) {
            throw new ItemAlreadyExistsException("Role '%s' already exist.", new Object[]{newName});
        }
        List rolePrincipals = this.securityResource.readRolePrincipals(roleName, null, null);
        RolePrincipals rolePrincipal = this.principalsByRole(rolePrincipals).get(roleName);
        rolePrincipal.getRole().setName(newName);
        this.securityResource.writeRolePrincipals(rolePrincipals);
        this.xlReleaseEventBus.publish((XLReleaseEvent)GlobalRolesOrPermissionsUpdatedEvent.apply());
    }

    private RoleView assembleRoleView(com.xebialabs.deployit.security.Role role, Map<String, RolePermissions> rolePermissions, Map<String, RolePrincipals> rolePrincipals) {
        RoleView roleView = new RoleView();
        roleView.setId(role.getId());
        roleView.setName(role.getName());
        roleView.setPrincipals((Collection)rolePrincipals.get(role.getName()).getPrincipals().stream().map(this::assemblePrincipal).collect(Collectors.toList()));
        List permissions = rolePermissions.getOrDefault(role.getName(), this.emptyRolePermissions(role)).getPermissions();
        roleView.setPermissions(new HashSet(permissions));
        return roleView;
    }

    private RolePermissions emptyRolePermissions(com.xebialabs.deployit.security.Role role) {
        return this.newRolePermission(role.getId(), role.getName(), Collections.emptyList());
    }

    private RolePrincipals newRolePrincipal(String roleName, List<String> principals) {
        Role role = new Role();
        role.setName(roleName);
        return new RolePrincipals(role, principals);
    }

    private RolePermissions newRolePermission(String id, String roleName, Collection<String> permissions) {
        Role role = new Role(id, roleName);
        return new RolePermissions(role, new ArrayList<String>(permissions));
    }

    private PrincipalView assemblePrincipal(String principal) {
        PrincipalView principalView = new PrincipalView();
        principalView.setFullname(this.userInfoResolver.getFullNameOf(principal));
        principalView.setUsername(principal);
        return principalView;
    }

    private Map<String, RolePrincipals> principalsByRole(List<RolePrincipals> rolePrincipals) {
        return (Map)rolePrincipals.stream().collect(com.xebialabs.xlrelease.utils.Collectors.toMap(rp -> rp.getRole().getName(), Function.identity()));
    }

    private Map<String, RolePermissions> permissionsByRole(List<RolePermissions> rolePermissions) {
        return (Map)rolePermissions.stream().collect(com.xebialabs.xlrelease.utils.Collectors.toMap(rp -> rp.getRole().getName(), Function.identity()));
    }

    private Map<String, com.xebialabs.deployit.security.Role> rolesByName(List<com.xebialabs.deployit.security.Role> roles) {
        return (Map)roles.stream().collect(com.xebialabs.xlrelease.utils.Collectors.toMap(com.xebialabs.deployit.security.Role::getName, Function.identity()));
    }

    private void checkPermissions(List<RoleView> roleViewList) {
        TreeSet unknownPermissions = new TreeSet();
        roleViewList.forEach(roleView -> unknownPermissions.addAll(roleView.getPermissions().stream().filter(p -> Permission.find((String)p) == null).collect(Collectors.toList())));
        Checks.checkArgument((boolean)unknownPermissions.isEmpty(), (String)"Unknown permissions found: '%s'", (Object[])new Object[]{unknownPermissions.stream().collect(Collectors.joining(", "))});
    }
}

