/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec;

import java.util.Collection;
import java.util.List;
import org.jparsec.ListFactory;
import org.jparsec.ParseContext;
import org.jparsec.Parser;

final class RepeatAtLeastParser<T>
extends Parser<List<T>> {
    private final Parser<? extends T> parser;
    private final int min;
    private final ListFactory<T> listFactory;

    RepeatAtLeastParser(Parser<? extends T> parser, int min) {
        this(parser, min, ListFactory.arrayListFactory());
    }

    RepeatAtLeastParser(Parser<? extends T> parser, int min, ListFactory<T> listFactory) {
        this.parser = parser;
        this.min = min;
        this.listFactory = listFactory;
    }

    @Override
    boolean apply(ParseContext ctxt) {
        List<T> result = this.listFactory.newList();
        if (!ctxt.repeat(this.parser, this.min, result)) {
            return false;
        }
        if (this.applyMany(ctxt, result)) {
            ctxt.result = result;
            return true;
        }
        return false;
    }

    public String toString() {
        return "atLeast";
    }

    private boolean applyMany(ParseContext ctxt, Collection<T> collection) {
        int physical = ctxt.at;
        int logical = ctxt.step;
        while (true) {
            if (!this.parser.apply(ctxt)) {
                ctxt.setAt(logical, physical);
                return true;
            }
            int at2 = ctxt.at;
            if (physical == at2) {
                return true;
            }
            physical = at2;
            collection.add(this.parser.getReturn(ctxt));
            logical = ctxt.step;
        }
    }
}

