/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.auth.oidc.config;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.RSAKey;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.plumbing.authentication.RedirectToUrlSuccessHandler;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.platform.sso.oidc.authentication.CustomOidcIdTokenDecoderFactory;
import com.xebialabs.platform.sso.oidc.exceptions.UnsupportedOidcConfigurationException;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.DefaultClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.impl.GrantedAuthoritiesExtractor;
import com.xebialabs.platform.sso.oidc.web.CustomAuthorizationRequestResolver;
import com.xebialabs.platform.sso.oidc.web.OidcLogoutSuccessHandler;
import com.xebialabs.xlrelease.auth.oidc.policy.UserProfileCreationPolicy;
import com.xebialabs.xlrelease.auth.oidc.policy.impl.DefaultOidcUserProfileCreationPolicy;
import com.xebialabs.xlrelease.auth.oidc.service.XlrOidcUserService;
import com.xebialabs.xlrelease.auth.oidc.web.BeforeLicenseCheckFilter;
import com.xebialabs.xlrelease.auth.oidc.web.OpenIdConnectRetainAnchorFilter;
import com.xebialabs.xlrelease.auth.oidc.web.XlReleaseLoginFormFilter;
import com.xebialabs.xlrelease.auth.oidc.web.authentication.Http401LoginUrlAuthenticationEntryPoint;
import com.xebialabs.xlrelease.auth.oidc.web.handlers.OidcLoginFailureHandler;
import com.xebialabs.xlrelease.auth.oidc.web.handlers.XlReleaseLoginFailureHandler;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.security.IdentityProvider;
import com.xebialabs.xlrelease.server.jetty.SSLConstants;
import com.xebialabs.xlrelease.service.UserProfileService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.endpoint.DefaultAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.NimbusJwtClientAuthenticationParametersConverter;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequestEntityConverter;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.ClientRegistrations;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthenticatedPrincipalOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.http.converter.OAuth2AccessTokenResponseHttpMessageConverter;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.jwt.JwtIssuerValidator;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.savedrequest.NullRequestCache;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
@Profile(value={"oidcAuth"})
public class OpenIdConnectConfig {
    public static final String OIDC_LOGIN_PATH_NAME = "oauth2/authorization/xl-release";
    public static final String OIDC_LOGIN = "/".concat("oauth2/authorization/xl-release");
    public static final String OIDC_PROCESSING_URL = "/oidc-login";
    public static final String INTERNAL_USER_LOGIN_SUCCESS_URL = "#/login?reloadUserDetails";
    private static final Logger logger = LoggerFactory.getLogger(OpenIdConnectConfig.class);
    private static final String REGISTRATION_ID = "xl-release";
    private static final Map<MacAlgorithm, String> MAC_ALGORITHM_MAPPING = Map.of(MacAlgorithm.HS256, "HmacSHA256", MacAlgorithm.HS384, "HmacSHA384", MacAlgorithm.HS512, "HmacSHA512");
    private static final Map<JwsAlgorithm, Curve> ESA_ALGORITHM_CURVE_MAPPING = Map.of(SignatureAlgorithm.ES256, Curve.P_256, SignatureAlgorithm.ES384, Curve.P_384, SignatureAlgorithm.ES512, Curve.P_521);
    private static final Map<JwsAlgorithm, JWSAlgorithm> ESA_ALGORITHM_MAP = Map.of(SignatureAlgorithm.ES256, JWSAlgorithm.ES256, SignatureAlgorithm.ES384, JWSAlgorithm.ES384, SignatureAlgorithm.ES512, JWSAlgorithm.ES512);
    private static final Map<JwsAlgorithm, JWSAlgorithm> RSA_ALGORITHM_MAP = Map.of(SignatureAlgorithm.RS256, JWSAlgorithm.RS256, SignatureAlgorithm.RS384, JWSAlgorithm.RS384, SignatureAlgorithm.RS512, JWSAlgorithm.RS512, SignatureAlgorithm.PS256, JWSAlgorithm.PS256, SignatureAlgorithm.PS384, JWSAlgorithm.PS384, SignatureAlgorithm.PS512, JWSAlgorithm.PS512);
    public static final String CHECK_JWS_ALG_MESSAGE = "Failed to find a Signature Verifier. Ensure you have configured a valid JWS Algorithm.";
    private JWK jwk;
    @Value(value="${xl.security.auth.providers.oidc.clientId}")
    private String clientId;
    @Value(value="${xl.security.auth.providers.oidc.clientSecret:}")
    private String clientSecret;
    @Value(value="${xl.security.auth.providers.oidc.clientAuthMethod:}")
    private String clientAuthMethod;
    @Value(value="${xl.security.auth.providers.oidc.clientAuthJwt.jwsAlg:}")
    private String clientAuthJWSAlg;
    @Value(value="${xl.security.auth.providers.oidc.clientAuthJwt.tokenKeyId:}")
    private String tokenKeyId;
    @Value(value="${xl.security.auth.providers.oidc.clientAuthJwt.keyStore.path:}")
    private String keyStorePath;
    @Value(value="${xl.security.auth.providers.oidc.clientAuthJwt.keyStore.password:}")
    private String keyStorePassword;
    @Value(value="${xl.security.auth.providers.oidc.clientAuthJwt.keyStore.type:}")
    private String keyStoreType;
    @Value(value="${xl.security.auth.providers.oidc.clientAuthJwt.key.alias:}")
    private String keyAlias;
    @Value(value="${xl.security.auth.providers.oidc.clientAuthJwt.key.password:}")
    private String keyPassword;
    @Value(value="${xl.security.auth.providers.oidc.issuer}")
    private String issuer;
    @Value(value="${xl.security.auth.providers.oidc.keyRetrievalUri:}")
    private String keyRetrievalUri;
    @Value(value="${xl.security.auth.providers.oidc.accessTokenUri:}")
    private String accessTokenUri;
    @Value(value="${xl.security.auth.providers.oidc.userAuthorizationUri:}")
    private String userAuthorizationUri;
    @Value(value="${xl.security.auth.providers.oidc.logoutUri:}")
    private String logoutUri;
    @Value(value="${xl.security.auth.providers.oidc.redirectUri:}")
    private String redirectUri;
    @Value(value="${xl.security.auth.providers.oidc.postLogoutRedirectUri:}")
    private String postLogoutRedirectUri;
    @Value(value="${xl.security.auth.providers.oidc.rolesClaim}")
    private String rolesClaim;
    @Value(value="${xl.security.auth.providers.oidc.fullNameClaim}")
    private String fullNameClaim;
    @Value(value="${xl.security.auth.providers.oidc.userNameClaim}")
    private String userNameClaim;
    @Value(value="${xl.security.auth.providers.oidc.emailClaim}")
    private String emailClaim;
    @Value(value="${xl.security.auth.providers.oidc.externalIdClaim:}")
    private String externalIdClaim;
    @Value(value="${xl.security.auth.providers.oidc.scopes}")
    private String scopes;
    @Value(value="${xl.security.auth.providers.oidc.idTokenJWSAlg:}")
    private String idTokenJWSAlg;
    @Value(value="${xl.security.auth.providers.oidc.access-token.issuer:}")
    private String accessTokenIssuer;
    @Value(value="${xl.security.auth.providers.oidc.access-token.audience:}")
    private String accessTokenAudience;
    @Value(value="${xl.security.auth.providers.oidc.access-token.keyRetrievalUri:}")
    private String accessTokenKeyUri;
    @Value(value="${xl.security.auth.providers.oidc.access-token.jwsAlg:}")
    private String accessTokenJWSAlg;
    @Value(value="${xl.security.auth.providers.oidc.access-token.secretKey:}")
    private String accessTokenSecretKey;
    @Value(value="${xl.security.auth.providers.oidc.proxyHost:}")
    private String proxyHost;
    @Value(value="${xl.security.auth.providers.oidc.proxyPort:}")
    private Integer proxyPort;
    Function<ClientRegistration, JWK> jwkResolver = clientRegistration -> {
        if (clientRegistration.getClientAuthenticationMethod().equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_JWT) || clientRegistration.getClientAuthenticationMethod().equals((Object)ClientAuthenticationMethod.PRIVATE_KEY_JWT)) {
            return this.jwk;
        }
        return null;
    };

    @Bean
    public IdentityProvider identityProvider() {
        return new IdentityProvider("oidc", String.format(".%s", OIDC_LOGIN), "./logout");
    }

    @Bean
    @Autowired
    public InMemoryClientRegistrationRepository clientRegistrationRepository(ServerConfiguration serverConfiguration) {
        return new InMemoryClientRegistrationRepository(new ClientRegistration[]{this.clientRegistration(serverConfiguration.getServerUrl())});
    }

    @Bean
    @Autowired
    public UserProfileCreationPolicy userProfileCreationPolicy(UserProfileService userProfileService, UserService userService) {
        return new DefaultOidcUserProfileCreationPolicy(userProfileService, userService, this.emailClaim, this.fullNameClaim, this.externalIdClaim);
    }

    @Bean
    public ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy() {
        return new DefaultClaimsToGrantedAuthoritiesPolicy(this.rolesClaim);
    }

    @Bean
    @Autowired
    public OAuth2AuthorizationRequestResolver customAuthorizationRequestResolver(ClientRegistrationRepository clientRegistrationRepository) {
        return new CustomAuthorizationRequestResolver(clientRegistrationRepository, "/oauth2/authorization");
    }

    @Bean
    @Autowired
    public OAuth2AuthorizedClientService authorizedClientService(ClientRegistrationRepository clientRegistrationRepository) {
        return new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository);
    }

    @Bean
    @Autowired
    public XlrOidcUserService xlrOidcUserService(UserProfileCreationPolicy userProfileCreationPolicy, ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy) {
        return new XlrOidcUserService(userProfileCreationPolicy, claimsToGrantedAuthoritiesPolicy);
    }

    @Bean
    @Autowired
    public OAuth2AuthorizedClientRepository authorizedClientRepository(OAuth2AuthorizedClientService authorizedClientService) {
        return new AuthenticatedPrincipalOAuth2AuthorizedClientRepository(authorizedClientService);
    }

    @Bean
    public Http401LoginUrlAuthenticationEntryPoint loginUrlAuthenticationEntryPoint() {
        return new Http401LoginUrlAuthenticationEntryPoint(OIDC_LOGIN);
    }

    @Bean
    public JwtDecoderFactory<ClientRegistration> idTokenDecoderFactory() {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory(this.getClientHttpRequestFactory());
        JwsAlgorithm jwsAlgorithm = this.getJwsAlgorithm(this.idTokenJWSAlg, "idTokenJWSAlg", JwsAlgorithmTypeSupported.MAC_AND_SIGNATURE_ALGORITHM_SUPPORTED);
        CustomOidcIdTokenDecoderFactory idTokenDecoderFactory = new CustomOidcIdTokenDecoderFactory();
        idTokenDecoderFactory.setJwsAlgorithmResolver(clientRegistration -> jwsAlgorithm);
        idTokenDecoderFactory.setRestOperations((RestOperations)restTemplate);
        return idTokenDecoderFactory;
    }

    @Bean
    @Autowired
    public JwtDecoder jwtDecoder(ServerConfiguration serverConfiguration) {
        NimbusJwtDecoder jwtDecoder;
        JwsAlgorithm jwsAlgorithm = this.getJwsAlgorithm(this.accessTokenJWSAlg, "jwsAlg", JwsAlgorithmTypeSupported.MAC_AND_SIGNATURE_ALGORITHM_SUPPORTED);
        if (SignatureAlgorithm.class.isAssignableFrom(jwsAlgorithm.getClass())) {
            String jwkSetUri = this.clientRegistration(serverConfiguration.getServerUrl()).getProviderDetails().getJwkSetUri();
            if (Strings.isNotBlank((String)this.accessTokenKeyUri)) {
                jwkSetUri = this.accessTokenKeyUri;
            }
            jwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)jwkSetUri).jwsAlgorithm((SignatureAlgorithm)jwsAlgorithm).build();
        } else if (MacAlgorithm.class.isAssignableFrom(jwsAlgorithm.getClass())) {
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.accessTokenSecretKey), (String)this.getPlaceholderErrorMessage("xl.security.auth.providers.oidc.access-token.secretKey"), (Object[])new Object[0]);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.accessTokenSecretKey.getBytes(StandardCharsets.UTF_8), MAC_ALGORITHM_MAPPING.get(jwsAlgorithm));
            jwtDecoder = NimbusJwtDecoder.withSecretKey((SecretKey)secretKeySpec).macAlgorithm((MacAlgorithm)jwsAlgorithm).build();
        } else {
            throw new UnsupportedOidcConfigurationException(CHECK_JWS_ALG_MESSAGE);
        }
        OAuth2TokenValidator<Jwt> jwtValidator = this.getJwtOAuth2TokenValidator();
        jwtDecoder.setJwtValidator(jwtValidator);
        return jwtDecoder;
    }

    @Bean
    public JwtAuthenticationConverter jwtAuthenticationConverter() {
        JwtAuthenticationConverter jwtAuthenticationConverter = new JwtAuthenticationConverter();
        jwtAuthenticationConverter.setPrincipalClaimName(this.userNameClaim);
        jwtAuthenticationConverter.setJwtGrantedAuthoritiesConverter((Converter)new GrantedAuthoritiesExtractor(this.claimsToGrantedAuthoritiesPolicy()));
        return jwtAuthenticationConverter;
    }

    @Bean
    @Autowired
    public DefaultAuthorizationCodeTokenResponseClient authorizationCodeTokenResponseClient(ClientRegistrationRepository clientRegistrationRepository) {
        RestTemplate restTemplate = new RestTemplate(Arrays.asList(new FormHttpMessageConverter(), new OAuth2AccessTokenResponseHttpMessageConverter()));
        restTemplate.setRequestFactory(this.getClientHttpRequestFactory());
        restTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
        DefaultAuthorizationCodeTokenResponseClient authorizationCodeTokenResponseClient = new DefaultAuthorizationCodeTokenResponseClient();
        authorizationCodeTokenResponseClient.setRestOperations((RestOperations)restTemplate);
        ClientRegistration clientRegistration = clientRegistrationRepository.findByRegistrationId(REGISTRATION_ID);
        if (clientRegistration.getClientAuthenticationMethod().equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_JWT) || clientRegistration.getClientAuthenticationMethod().equals((Object)ClientAuthenticationMethod.PRIVATE_KEY_JWT)) {
            this.setJwk(clientRegistration);
            OAuth2AuthorizationCodeGrantRequestEntityConverter requestEntityConverter = new OAuth2AuthorizationCodeGrantRequestEntityConverter();
            requestEntityConverter.addParametersConverter((Converter)new NimbusJwtClientAuthenticationParametersConverter(this.jwkResolver));
            authorizationCodeTokenResponseClient.setRequestEntityConverter((Converter)requestEntityConverter);
        }
        return authorizationCodeTokenResponseClient;
    }

    @Bean
    @Autowired
    public LogoutSuccessHandler xlrOidcLogoutSuccessHandler(ClientRegistrationRepository clientRegistrationRepository) {
        return new OidcLogoutSuccessHandler(clientRegistrationRepository, this.postLogoutRedirectUri, "login");
    }

    @Bean
    public OidcLoginFailureHandler oidcLoginFailureHandler() {
        return new OidcLoginFailureHandler();
    }

    @Bean
    public XlReleaseLoginFailureHandler xlreleaseLoginFailureHandler() {
        return new XlReleaseLoginFailureHandler();
    }

    @Bean
    public NullRequestCache nullRequestCache() {
        return new NullRequestCache();
    }

    @Bean
    @Autowired
    public OpenIdConnectRetainAnchorFilter openIdConnectRetainAnchorFilter(XlrConfig xlrConfig, ServerConfiguration serverConfiguration) {
        OpenIdConnectRetainAnchorFilter openIdConnectRetainAnchorFilter = new OpenIdConnectRetainAnchorFilter(xlrConfig.server_http_cookie_sameSite().getAttributeValue());
        if (!serverConfiguration.isSsl()) {
            openIdConnectRetainAnchorFilter.setSecureCookie(serverConfiguration.isSecureCookieEnabled());
        }
        return openIdConnectRetainAnchorFilter;
    }

    @Bean
    public BeforeLicenseCheckFilter beforeLicenseCheckFilter() {
        return new BeforeLicenseCheckFilter();
    }

    @Bean
    @Autowired
    public XlReleaseLoginFormFilter xlReleaseLoginFormFilter(AuthenticationManager authenticationManager, SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        XlReleaseLoginFormFilter filter = new XlReleaseLoginFormFilter(this.defaultOidcMustacheTemplateSettings());
        filter.setAuthenticationManager(authenticationManager);
        filter.setSessionAuthenticationStrategy(sessionAuthenticationStrategy);
        filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)new RedirectToUrlSuccessHandler(INTERNAL_USER_LOGIN_SUCCESS_URL));
        filter.setAuthenticationFailureHandler(this.xlreleaseLoginFailureHandler());
        return filter;
    }

    public Map<String, String> defaultOidcMustacheTemplateSettings() {
        HashMap<String, String> scope = new HashMap<String, String>();
        scope.put("productLogo", "static/0/styles/img/digital-ai-release.svg");
        scope.put("productColor", "#498500");
        scope.put("productIcon", "static/0/styles/img/favicon.ico");
        scope.put("productName", "Digital.ai Release");
        return scope;
    }

    private ClientRegistration clientRegistration(String serverUrl) {
        ClientRegistration.Builder clientRegistrationBuilder = this.getClientRegistrationBuilder();
        ClientAuthenticationMethod authenticationMethod = this.getClientAuthMethod();
        clientRegistrationBuilder.clientId(this.clientId).clientAuthenticationMethod(authenticationMethod).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).userInfoUri("").scope((Collection)Stream.of(this.scopes.split(",")).collect(Collectors.toList())).userNameAttributeName(this.userNameClaim);
        if (!authenticationMethod.equals((Object)ClientAuthenticationMethod.NONE) && !authenticationMethod.equals((Object)ClientAuthenticationMethod.PRIVATE_KEY_JWT)) {
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.clientSecret), (String)this.getPlaceholderErrorMessage("xl.security.auth.providers.oidc.clientSecret"), (Object[])new Object[0]);
            clientRegistrationBuilder.clientSecret(this.clientSecret);
        }
        if (authenticationMethod.equals((Object)ClientAuthenticationMethod.PRIVATE_KEY_JWT)) {
            if (Strings.isBlank((String)this.keyStorePath)) {
                this.keyStorePath = System.getProperty(SSLConstants.KEYSTORE_PROPERTY());
                this.keyStorePassword = System.getProperty(SSLConstants.KEYSTORE_PASSWORD_PROPERTY());
            }
            String clientAuthJwtProperty = "xl.security.auth.providers.oidc.clientAuthJwt";
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.keyStorePath), (String)this.getPlaceholderErrorMessage(clientAuthJwtProperty + ".keyStore.path"), (Object[])new Object[0]);
            Checks.checkArgument((boolean)Strings.isNotBlank((String)this.keyAlias), (String)this.getPlaceholderErrorMessage(clientAuthJwtProperty + ".key.alias"), (Object[])new Object[0]);
        }
        if (Strings.isNotBlank((String)this.redirectUri)) {
            clientRegistrationBuilder.redirectUri(this.redirectUri);
        } else {
            clientRegistrationBuilder.redirectUri(URI.create(serverUrl + OIDC_PROCESSING_URL).normalize().toString());
        }
        if (Strings.isNotBlank((String)this.userAuthorizationUri)) {
            clientRegistrationBuilder.authorizationUri(this.getEncodedUriString(this.userAuthorizationUri));
        }
        if (Strings.isNotBlank((String)this.accessTokenUri)) {
            clientRegistrationBuilder.tokenUri(this.getDecodedUriString(this.accessTokenUri));
        }
        if (Strings.isNotBlank((String)this.keyRetrievalUri)) {
            clientRegistrationBuilder.jwkSetUri(this.getEncodedUriString(this.keyRetrievalUri));
        }
        ClientRegistration clientRegistration = clientRegistrationBuilder.build();
        Map configurationMetadata = clientRegistration.getProviderDetails().getConfigurationMetadata();
        HashMap<String, String> updatedConfigurationMetadata = new HashMap<String, String>(configurationMetadata);
        if (Strings.isNotBlank((String)this.logoutUri)) {
            updatedConfigurationMetadata.put("end_session_endpoint", this.getDecodedUriString(this.logoutUri));
        }
        updatedConfigurationMetadata.put("fullNameClaim", this.fullNameClaim);
        updatedConfigurationMetadata.put("emailClaim", this.emailClaim);
        updatedConfigurationMetadata.put("rolesClaim", this.rolesClaim);
        return ClientRegistration.withClientRegistration((ClientRegistration)clientRegistration).providerConfigurationMetadata(updatedConfigurationMetadata).build();
    }

    private ClientRegistration.Builder getClientRegistrationBuilder() {
        String decodedIssuer = this.getDecodedUriString(this.issuer);
        try {
            if (decodedIssuer.matches("\\S+")) {
                return ClientRegistrations.fromOidcIssuerLocation((String)decodedIssuer).registrationId(REGISTRATION_ID);
            }
            throw new UnsupportedOidcConfigurationException(String.format("Whitespace characters in issuer url [%s] is not supported. Recommendation is to avoid using spaces in URLs, and instead use hyphens to separate words.", decodedIssuer));
        }
        catch (IllegalArgumentException re) {
            logger.warn(String.format("Unable to resolve Configuration with the provided Issuer of [%s]", this.issuer));
            this.validateOidcConfiguration();
            return ClientRegistration.withRegistrationId((String)REGISTRATION_ID);
        }
        catch (UnsupportedOidcConfigurationException e) {
            logger.warn(e.getMessage());
            this.validateOidcConfiguration();
            return ClientRegistration.withRegistrationId((String)REGISTRATION_ID);
        }
    }

    private ClientHttpRequestFactory getClientHttpRequestFactory() {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        if (Strings.isNotBlank((String)this.proxyHost)) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, (int)this.proxyPort));
            requestFactory.setProxy(proxy);
        }
        return requestFactory;
    }

    private JwsAlgorithm getJwsAlgorithm(String jwsAlgorithm, String propertyName, JwsAlgorithmTypeSupported supported) {
        Map<String, JwsAlgorithm> jwsAlgorithms = this.computeJwsAlgorithmMap(supported);
        if (Strings.isNotBlank((String)jwsAlgorithm)) {
            if (jwsAlgorithms.containsKey(jwsAlgorithm)) {
                return jwsAlgorithms.get(jwsAlgorithm);
            }
            throw new IllegalArgumentException(String.format("%s value [%s] is not supported. Ensure you have configured a valid JWS Algorithm.", propertyName, jwsAlgorithm));
        }
        switch (supported) {
            case MAC_ALGORITHM_SUPPORTED: {
                return MacAlgorithm.HS256;
            }
        }
        return SignatureAlgorithm.RS256;
    }

    private Map<String, JwsAlgorithm> computeJwsAlgorithmMap(JwsAlgorithmTypeSupported typeSupported) {
        HashMap<String, JwsAlgorithm> jwsAlgorithms = new HashMap<String, JwsAlgorithm>();
        if (typeSupported == JwsAlgorithmTypeSupported.SIGNATURE_ALGORITHM_SUPPORTED || typeSupported == JwsAlgorithmTypeSupported.MAC_AND_SIGNATURE_ALGORITHM_SUPPORTED) {
            jwsAlgorithms.putAll(EnumSet.allOf(SignatureAlgorithm.class).stream().collect(Collectors.toMap(SignatureAlgorithm::getName, x -> x)));
        }
        if (typeSupported == JwsAlgorithmTypeSupported.MAC_ALGORITHM_SUPPORTED || typeSupported == JwsAlgorithmTypeSupported.MAC_AND_SIGNATURE_ALGORITHM_SUPPORTED) {
            jwsAlgorithms.putAll(EnumSet.allOf(MacAlgorithm.class).stream().collect(Collectors.toMap(MacAlgorithm::getName, x -> x)));
        }
        return jwsAlgorithms;
    }

    private ClientAuthenticationMethod getClientAuthMethod() {
        HashMap<String, ClientAuthenticationMethod> clientAuthMethods = new HashMap<String, ClientAuthenticationMethod>();
        clientAuthMethods.put("client_secret_basic", ClientAuthenticationMethod.CLIENT_SECRET_BASIC);
        clientAuthMethods.put("client_secret_post", ClientAuthenticationMethod.CLIENT_SECRET_POST);
        clientAuthMethods.put("client_secret_jwt", ClientAuthenticationMethod.CLIENT_SECRET_JWT);
        clientAuthMethods.put("private_key_jwt", ClientAuthenticationMethod.PRIVATE_KEY_JWT);
        clientAuthMethods.put("none", ClientAuthenticationMethod.NONE);
        if (Strings.isNotBlank((String)this.clientAuthMethod)) {
            String authMethod = this.clientAuthMethod.toLowerCase();
            if (clientAuthMethods.containsKey(authMethod)) {
                return (ClientAuthenticationMethod)clientAuthMethods.get(authMethod);
            }
            throw new IllegalArgumentException(String.format("clientAuthMethod value [%s] is not supported. Ensure you have configured a valid client authentication method.", this.clientAuthMethod));
        }
        return ClientAuthenticationMethod.CLIENT_SECRET_POST;
    }

    private OAuth2TokenValidator<Jwt> getJwtOAuth2TokenValidator() {
        ArrayList<Object> validators = new ArrayList<Object>();
        validators.add(new JwtTimestampValidator());
        validators.add(new JwtIssuerValidator(Strings.isNotBlank((String)this.accessTokenIssuer) ? this.accessTokenIssuer : this.issuer));
        validators.add(new JwtClaimValidator("aud", aud -> aud.contains(Strings.isNotBlank((String)this.accessTokenAudience) ? this.accessTokenAudience : this.clientId)));
        return new DelegatingOAuth2TokenValidator(validators);
    }

    private String getEncodedUriString(String uri) {
        try {
            return URI.create(uri).toASCIIString();
        }
        catch (IllegalArgumentException e) {
            return UriComponentsBuilder.fromUriString((String)uri).build().toUri().toASCIIString();
        }
    }

    private String getDecodedUriString(String uri) {
        try {
            return URLDecoder.decode(uri, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(String.format("Cannot decode value [%s] with 'utf-8' charset", uri));
        }
    }

    private void validateOidcConfiguration() {
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.userAuthorizationUri), (String)this.getPlaceholderErrorMessage("xl.security.auth.providers.oidc.userAuthorizationUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.accessTokenUri), (String)this.getPlaceholderErrorMessage("xl.security.auth.providers.oidc.accessTokenUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.keyRetrievalUri), (String)this.getPlaceholderErrorMessage("xl.security.auth.providers.oidc.keyRetrievalUri"), (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)this.logoutUri), (String)this.getPlaceholderErrorMessage("xl.security.auth.providers.oidc.logoutUri"), (Object[])new Object[0]);
    }

    private String getPlaceholderErrorMessage(String placeholder) {
        return String.format("Could not resolve placeholder '%s' in value ${%s}", placeholder, placeholder);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setJwk(ClientRegistration clientRegistration) {
        if (clientRegistration.getClientAuthenticationMethod().equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_JWT)) {
            JwsAlgorithm jwsAlgorithm = this.getJwsAlgorithm(this.clientAuthJWSAlg, "xl.security.auth.providers.oidc.clientAuthJwt.jwsAlg", JwsAlgorithmTypeSupported.MAC_ALGORITHM_SUPPORTED);
            if (!MacAlgorithm.class.isAssignableFrom(jwsAlgorithm.getClass())) throw new UnsupportedOidcConfigurationException(CHECK_JWS_ALG_MESSAGE);
            SecretKeySpec secretKey = new SecretKeySpec(clientRegistration.getClientSecret().getBytes(StandardCharsets.UTF_8), MAC_ALGORITHM_MAPPING.get(jwsAlgorithm));
            this.jwk = new OctetSequenceKey.Builder((SecretKey)secretKey).algorithm(new Algorithm(((MacAlgorithm)jwsAlgorithm).name())).keyUse(KeyUse.SIGNATURE).keyID(UUID.randomUUID().toString()).build();
            return;
        } else {
            if (!clientRegistration.getClientAuthenticationMethod().equals((Object)ClientAuthenticationMethod.PRIVATE_KEY_JWT)) return;
            JwsAlgorithm jwsAlgorithm = this.getJwsAlgorithm(this.clientAuthJWSAlg, "xl.security.auth.providers.oidc.clientAuthJwt.jwsAlg", JwsAlgorithmTypeSupported.SIGNATURE_ALGORITHM_SUPPORTED);
            KeyPair keyPair = this.getKeyPair();
            if (!SignatureAlgorithm.class.isAssignableFrom(jwsAlgorithm.getClass())) throw new UnsupportedOidcConfigurationException(CHECK_JWS_ALG_MESSAGE);
            if (RSA_ALGORITHM_MAP.containsKey(jwsAlgorithm)) {
                this.jwk = this.getRSAKey(keyPair, (Algorithm)RSA_ALGORITHM_MAP.get(jwsAlgorithm));
                return;
            } else {
                if (!ESA_ALGORITHM_MAP.containsKey(jwsAlgorithm)) throw new UnsupportedOidcConfigurationException(CHECK_JWS_ALG_MESSAGE);
                this.jwk = this.getESAKey(keyPair, (Algorithm)ESA_ALGORITHM_MAP.get(jwsAlgorithm), ESA_ALGORITHM_CURVE_MAPPING.get(jwsAlgorithm));
            }
        }
    }

    private KeyPair getKeyPair() {
        KeyPair keyPair;
        File file = new File(this.keyStorePath);
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("Cannot find keystore [%s]", this.keyStorePath));
        }
        if (Strings.isBlank((String)this.keyStorePassword)) {
            logger.warn("The keystore [{}] is not protected by a password. It is recommended to secure it using a password.", (Object)this.keyStorePath);
        }
        try (FileInputStream in = new FileInputStream(file);){
            KeyStore keystore = KeyStore.getInstance(Strings.isNotBlank((String)this.keyStoreType) ? this.keyStoreType : KeyStore.getDefaultType());
            keystore.load(in, Strings.isNotBlank((String)this.keyStorePassword) ? this.keyStorePassword.toCharArray() : null);
            PrivateKey privateKey = (PrivateKey)keystore.getKey(this.keyAlias, Strings.isNotBlank((String)this.keyPassword) ? this.keyPassword.toCharArray() : null);
            Certificate cert = keystore.getCertificate(this.keyAlias);
            PublicKey publicKey = cert.getPublicKey();
            keyPair = new KeyPair(publicKey, privateKey);
        }
        catch (IOException | RuntimeException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new DeployitException((Throwable)e);
        }
        return keyPair;
    }

    private RSAKey getRSAKey(KeyPair keyPair, Algorithm algorithm) {
        RSAKey.Builder builder = new RSAKey.Builder((RSAPublicKey)keyPair.getPublic()).privateKey(keyPair.getPrivate()).algorithm(algorithm).keyUse(KeyUse.SIGNATURE);
        if (Strings.isNotBlank((String)this.tokenKeyId)) {
            builder.keyID(this.tokenKeyId);
        } else {
            logger.debug("Building RSAKey without token k-id. Token key Id not provided in configuration.");
        }
        return builder.build();
    }

    private ECKey getESAKey(KeyPair keyPair, Algorithm algorithm, Curve curve) {
        ECKey.Builder builder = new ECKey.Builder(curve, (ECPublicKey)keyPair.getPublic()).privateKey((ECPrivateKey)keyPair.getPrivate()).algorithm(algorithm).keyUse(KeyUse.SIGNATURE);
        if (Strings.isNotBlank((String)this.tokenKeyId)) {
            builder.keyID(this.tokenKeyId);
        } else {
            logger.debug("Building ECKey without token k-id. Token key Id not provided in configuration.");
        }
        return builder.build();
    }

    private static enum JwsAlgorithmTypeSupported {
        MAC_ALGORITHM_SUPPORTED,
        SIGNATURE_ALGORITHM_SUPPORTED,
        MAC_AND_SIGNATURE_ALGORITHM_SUPPORTED;

    }
}

