/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import java.util.Date;
import org.kohsuke.github.GHCommentAuthorAssociation;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.internal.EnumUtils;

public class GHRepositoryDiscussion
extends GHObject {
    private Category category;
    private String answerHtmlUrl;
    private String answerChosenAt;
    private GHUser answerChosenBy;
    private String htmlUrl;
    private int number;
    private String title;
    private GHUser user;
    private String state;
    private boolean locked;
    private int comments;
    private GHCommentAuthorAssociation authorAssociation;
    private String activeLockReason;
    private String body;
    private String timelineUrl;

    public Category getCategory() {
        return this.category;
    }

    public URL getAnswerHtmlUrl() {
        return GitHubClient.parseURL(this.answerHtmlUrl);
    }

    public Date getAnswerChosenAt() {
        return GitHubClient.parseDate(this.answerChosenAt);
    }

    public GHUser getAnswerChosenBy() throws IOException {
        return this.root().intern(this.answerChosenBy);
    }

    @Override
    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    public int getNumber() {
        return this.number;
    }

    public String getTitle() {
        return this.title;
    }

    public GHUser getUser() throws IOException {
        return this.root().intern(this.user);
    }

    public State getState() {
        return EnumUtils.getEnumOrDefault(State.class, this.state, State.UNKNOWN);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public int getComments() {
        return this.comments;
    }

    public GHCommentAuthorAssociation getAuthorAssociation() {
        return this.authorAssociation;
    }

    public String getActiveLockReason() {
        return this.activeLockReason;
    }

    public String getBody() {
        return this.body;
    }

    public String getTimelineUrl() {
        return this.timelineUrl;
    }

    public static enum State {
        OPEN,
        LOCKED,
        UNKNOWN;

    }

    public static class Category {
        private long id;
        private long repositoryId;
        private String emoji;
        private String name;
        private String description;
        private String createdAt;
        private String updatedAt;
        private String slug;
        private boolean isAnswerable;

        public long getId() {
            return this.id;
        }

        public long getRepositoryId() {
            return this.repositoryId;
        }

        public String getEmoji() {
            return this.emoji;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public Date getCreatedAt() {
            return GitHubClient.parseDate(this.createdAt);
        }

        public Date getUpdatedAt() {
            return GitHubClient.parseDate(this.updatedAt);
        }

        public String getSlug() {
            return this.slug;
        }

        public boolean isAnswerable() {
            return this.isAnswerable;
        }
    }
}

