/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.sharding.internal;

import akka.actor.ActorRef;
import akka.annotation.InternalApi;
import akka.cluster.sharding.internal.AbstractLeastShardAllocationStrategy;
import akka.cluster.sharding.internal.AbstractLeastShardAllocationStrategy$ShardSuitabilityOrdering$;
import akka.cluster.sharding.internal.LeastShardAllocationStrategy$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ReusableBuilder;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005]<aa\u0003\u0007\t\u0002I!bA\u0002\f\r\u0011\u0003\u0011r\u0003C\u0003\u001f\u0003\u0011\u0005\u0001\u0005C\u0004\"\u0003\t\u0007I\u0011\u0002\u0012\t\r\u0005\u000b\u0001\u0015!\u0003$\r\u00151B\u0002\u0001\nK\u0011!qUA!A!\u0002\u0013y\u0005\u0002\u0003*\u0006\u0005\u0003\u0005\u000b\u0011B*\t\u000by)A\u0011\u0001,\t\u000bi+A\u0011I.\t\u000bQ,A\u0011I;\u000291+\u0017m\u001d;TQ\u0006\u0014H-\u00117m_\u000e\fG/[8o'R\u0014\u0018\r^3hs*\u0011QBD\u0001\tS:$XM\u001d8bY*\u0011q\u0002E\u0001\tg\"\f'\u000fZ5oO*\u0011\u0011CE\u0001\bG2,8\u000f^3s\u0015\u0005\u0019\u0012\u0001B1lW\u0006\u0004\"!F\u0001\u000e\u00031\u0011A\u0004T3bgR\u001c\u0006.\u0019:e\u00032dwnY1uS>t7\u000b\u001e:bi\u0016<\u0017p\u0005\u0002\u00021A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002)\u0005!R-\u001c9usJ+'-\u00197b]\u000e,'+Z:vYR,\u0012a\t\t\u0004I\u001dJS\"A\u0013\u000b\u0005\u0019R\u0012AC2p]\u000e,(O]3oi&\u0011\u0001&\n\u0002\u0007\rV$XO]3\u0011\u0007)z\u0013'D\u0001,\u0015\taS&A\u0005j[6,H/\u00192mK*\u0011aFG\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u0019,\u0005\r\u0019V\r\u001e\t\u0003eyr!a\r\u001f\u000f\u0005QZdBA\u001b;\u001d\t1\u0014(D\u00018\u0015\tAt$\u0001\u0004=e>|GOP\u0005\u0002'%\u0011\u0011CE\u0005\u0003\u001fAI!!\u0010\b\u0002\u0017MC\u0017M\u001d3SK\u001eLwN\\\u0005\u0003\u007f\u0001\u0013qa\u00155be\u0012LEM\u0003\u0002>\u001d\u0005)R-\u001c9usJ+'-\u00197b]\u000e,'+Z:vYR\u0004\u0003FA\u0001D!\t!u)D\u0001F\u0015\t1%#\u0001\u0006b]:|G/\u0019;j_:L!\u0001S#\u0003\u0017%sG/\u001a:oC2\f\u0005/\u001b\u0015\u0003\u0001\r\u001b\"!B&\u0011\u0005Ua\u0015BA'\r\u0005\u0011\n%m\u001d;sC\u000e$H*Z1tiNC\u0017M\u001d3BY2|7-\u0019;j_:\u001cFO]1uK\u001eL\u0018!D1cg>dW\u000f^3MS6LG\u000f\u0005\u0002\u001a!&\u0011\u0011K\u0007\u0002\u0004\u0013:$\u0018!\u0004:fY\u0006$\u0018N^3MS6LG\u000f\u0005\u0002\u001a)&\u0011QK\u0007\u0002\u0007\t>,(\r\\3\u0015\u0007]C\u0016\f\u0005\u0002\u0016\u000b!)a\n\u0003a\u0001\u001f\")!\u000b\u0003a\u0001'\u0006I!/\u001a2bY\u0006t7-\u001a\u000b\u00049\u0012\u0014\bc\u0001\u0013(;B\u0019aLY\u0019\u000f\u0005}\u0003\u0007C\u0001\u001c\u001b\u0013\t\t'$\u0001\u0004Qe\u0016$WMZ\u0005\u0003a\rT!!\u0019\u000e\t\u000b\u0015L\u0001\u0019\u00014\u0002/\r,(O]3oiNC\u0017M\u001d3BY2|7-\u0019;j_:\u001c\b\u0003\u00020hS>L!\u0001[2\u0003\u00075\u000b\u0007\u000f\u0005\u0002k[6\t1N\u0003\u0002m%\u0005)\u0011m\u0019;pe&\u0011an\u001b\u0002\t\u0003\u000e$xN\u001d*fMB\u0019!\u0006]\u0019\n\u0005E\\#AC%oI\u0016DX\rZ*fc\")1/\u0003a\u0001;\u0006\u0019\"/\u001a2bY\u0006t7-Z%o!J|wM]3tg\u0006AAo\\*ue&tw\rF\u00012Q\t)1\t")
@InternalApi
public class LeastShardAllocationStrategy
extends AbstractLeastShardAllocationStrategy {
    private final int absoluteLimit;
    private final double relativeLimit;

    @Override
    public Future<Set<String>> rebalance(Map<ActorRef, IndexedSeq<String>> currentShardAllocations, Set<String> rebalanceInProgress) {
        Future future;
        if (rebalanceInProgress.nonEmpty()) {
            future = LeastShardAllocationStrategy$.MODULE$.akka$cluster$sharding$internal$LeastShardAllocationStrategy$$emptyRebalanceResult();
        } else {
            Vector sortedRegionEntries = (Vector)this.regionEntriesFor(currentShardAllocations).toVector().sorted((Ordering)AbstractLeastShardAllocationStrategy$ShardSuitabilityOrdering$.MODULE$);
            if (!this.isAGoodTimeToRebalance((Iterable<AbstractLeastShardAllocationStrategy.RegionEntry>)sortedRegionEntries)) {
                future = LeastShardAllocationStrategy$.MODULE$.akka$cluster$sharding$internal$LeastShardAllocationStrategy$$emptyRebalanceResult();
            } else {
                int numberOfShards = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)sortedRegionEntries.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)LeastShardAllocationStrategy.$anonfun$rebalance$4(x$1)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                int numberOfRegions = sortedRegionEntries.size();
                if (numberOfRegions == 0 || numberOfShards == 0) {
                    future = LeastShardAllocationStrategy$.MODULE$.akka$cluster$sharding$internal$LeastShardAllocationStrategy$$emptyRebalanceResult();
                } else {
                    int optimalPerRegion = numberOfShards / numberOfRegions + (numberOfShards % numberOfRegions == 0 ? 0 : 1);
                    Set result1 = this.rebalancePhase1$1(numberOfShards, optimalPerRegion, (Iterable)sortedRegionEntries);
                    future = result1.nonEmpty() ? Future$.MODULE$.successful((Object)result1) : this.rebalancePhase2$1(numberOfShards, optimalPerRegion, (Iterable)sortedRegionEntries);
                }
            }
        }
        return future;
    }

    public String toString() {
        return new StringBuilder(31).append("LeastShardAllocationStrategy(").append(this.absoluteLimit).append(",").append(this.relativeLimit).append(")").toString();
    }

    private final int limit$1(int numberOfShards) {
        return package$.MODULE$.max(1, package$.MODULE$.min((int)(this.relativeLimit * (double)numberOfShards), this.absoluteLimit));
    }

    private final Set rebalancePhase1$1(int numberOfShards, int optimalPerRegion, Iterable sortedEntries) {
        ReusableBuilder selected = scala.package$.MODULE$.Vector().newBuilder();
        sortedEntries.foreach((Function1 & Serializable)x0$1 -> {
            AbstractLeastShardAllocationStrategy.RegionEntry regionEntry = x0$1;
            if (regionEntry == null) {
                throw new MatchError((Object)regionEntry);
            }
            IndexedSeq<String> shardIds = regionEntry.shardIds();
            BoxedUnit boxedUnit = shardIds.size() > optimalPerRegion ? selected.$plus$plus$eq((IterableOnce)shardIds.take(shardIds.size() - optimalPerRegion)) : BoxedUnit.UNIT;
            return boxedUnit;
        });
        Vector result = (Vector)selected.result();
        return result.take(this.limit$1(numberOfShards)).toSet();
    }

    private final Future rebalancePhase2$1(int numberOfShards, int optimalPerRegion, Iterable sortedEntries) {
        Future future;
        int countBelowOptimal = BoxesRunTime.unboxToInt((Object)sortedEntries.iterator().map((Function1 & Serializable)entry -> BoxesRunTime.boxToInteger((int)package$.MODULE$.max(0, optimalPerRegion - 1 - entry.shardIds().size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        if (countBelowOptimal == 0) {
            future = LeastShardAllocationStrategy$.MODULE$.akka$cluster$sharding$internal$LeastShardAllocationStrategy$$emptyRebalanceResult();
        } else {
            ReusableBuilder selected = scala.package$.MODULE$.Vector().newBuilder();
            sortedEntries.foreach((Function1 & Serializable)x0$1 -> {
                AbstractLeastShardAllocationStrategy.RegionEntry regionEntry = x0$1;
                if (regionEntry == null) {
                    throw new MatchError((Object)regionEntry);
                }
                IndexedSeq<String> shardIds = regionEntry.shardIds();
                BoxedUnit boxedUnit = shardIds.size() >= optimalPerRegion ? selected.$plus$eq(shardIds.head()) : BoxedUnit.UNIT;
                return boxedUnit;
            });
            Set result = ((Vector)selected.result()).take(package$.MODULE$.min(countBelowOptimal, this.limit$1(numberOfShards))).toSet();
            future = Future$.MODULE$.successful((Object)result);
        }
        return future;
    }

    public static final /* synthetic */ int $anonfun$rebalance$4(AbstractLeastShardAllocationStrategy.RegionEntry x$1) {
        return x$1.shardIds().size();
    }

    public LeastShardAllocationStrategy(int absoluteLimit, double relativeLimit) {
        this.absoluteLimit = absoluteLimit;
        this.relativeLimit = relativeLimit;
    }
}

