/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.app;

import java.net.URL;
import org.rzo.yajsw.app.WrapperManager;
import org.rzo.yajsw.boot.WrapperClassLoader;
import org.rzo.yajsw.boot.WrapperLoader;

public class WrapperManagerProxy {
    static ClassLoader wrapperClassLoader;

    public static WrapperManager getWrapperManager(String[] args) {
        wrapperClassLoader = WrapperManagerProxy.getWrapperClassLoader();
        WrapperManager result = null;
        try {
            Class<?> wrapperManagerClass = wrapperClassLoader.loadClass("org.rzo.yajsw.app.WrapperManagerImpl");
            final WrapperManager wm = (WrapperManager)wrapperManagerClass.newInstance();
            wm.init(args, wrapperClassLoader);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        wm.start();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }, "yajsw.app.manager.start").start();
            Thread.yield();
            result = wm;
            String preScript = System.getProperty("wrapper.app.pre_main.script");
            if (preScript != null & !"".equals(preScript)) {
                wm.executeScript(preScript, wrapperClassLoader);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return result;
    }

    private static ClassLoader getWrapperClassLoader() {
        URL[] urlsArr = WrapperLoader.getWrapperClasspath("App", true);
        if (urlsArr == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        URL[] extended = WrapperLoader.getWrapperClasspath("App-Extended", false);
        URL[] urls = new URL[urlsArr.length + extended.length];
        System.arraycopy(urlsArr, 0, urls, 0, urlsArr.length);
        System.arraycopy(extended, 0, urls, urlsArr.length, extended.length);
        return new WrapperClassLoader(urls, ClassLoader.getSystemClassLoader());
    }
}

