import some from 'lodash/some';

const existByField = (list, field, value) => {
    return some(list, (e) => e[field].trim().toLowerCase() === value.trim().toLowerCase());
};

const findById = (list, id, defaultField) => {
    return list.find((e) => e.id === id) || { [defaultField]: '' };
};

export const itemAlreadyDefined = (list, selectedId, field, value) => {
    return existByField(list, field, value) && findById(list, selectedId, field)[field].trim().toLowerCase() !== value.trim().toLowerCase();
};

export const validateMaxLength = (inputText, maxLength) => {
    return inputText && inputText.trim().length > maxLength;
};

export const validateMinLength = (inputText, minLength) => {
    return inputText && inputText.trim().length < minLength;
};

export const validateExistence = (inputText) => !inputText || !inputText.trim();

const validateReservedCharacters = (text) => {
    return text.includes('`');
};

export const createErrorMessage = (text) => ({ show: false, text, type: 'ERROR' });

export const reservedCharactersValidator = (label) => (text) => ({
    condition: validateReservedCharacters(text),
    message: createErrorMessage(`${label} contains forbidden characters`),
});
