/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config;

import com.datical.liquibase.ext.checks.config.FileAccessor;
import com.datical.liquibase.ext.checks.config.IFileAccessor;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import liquibase.Scope;
import liquibase.exception.CommandExecutionException;
import liquibase.util.StringUtil;
import org.yaml.snakeyaml.Yaml;

public class CheckSettingsConfigHelper {
    public static final String LIQUIBASE_CHECKS_SETTINGS_CONF = "liquibase.checks-settings.conf";
    private final String checkSettingsFilename;
    private final IFileAccessor fileAccessor;
    private final Yaml yaml = new Yaml();

    public CheckSettingsConfigHelper() {
        this((String)null);
    }

    public CheckSettingsConfigHelper(String string) {
        this.fileAccessor = new FileAccessor();
        if (StringUtil.isEmpty(string)) {
            this.checkSettingsFilename = LIQUIBASE_CHECKS_SETTINGS_CONF;
            return;
        }
        this.checkSettingsFilename = string;
    }

    public CheckSettingsConfigHelper(IFileAccessor iFileAccessor) {
        this.fileAccessor = iFileAccessor;
        this.checkSettingsFilename = LIQUIBASE_CHECKS_SETTINGS_CONF;
    }

    public CheckSettingsConfig read(List<AbstractLiquibaseRule> list) {
        Object object;
        try {
            object = this.fileAccessor.loadFileContents(this.checkSettingsFilename);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string2 = Scope.getCurrentScope().getUI().prompt(this.checkSettingsFilename + " does not exist." + System.lineSeparator() + "Would you like to create it? (Y/n)", "Y", (string, clazz) -> {
                if (string == null || !string.equalsIgnoreCase("y") && !string.equalsIgnoreCase("n")) {
                    throw new IllegalArgumentException();
                }
                return string;
            }, String.class);
            if (string2 != null && string2.equalsIgnoreCase("y")) {
                this.write(CheckSettingsConfig.generateDefaultConfigFromRules(list));
                Scope.getCurrentScope().getUI().sendMessage(this.checkSettingsFilename + " successfully created!");
                string2 = this.fileAccessor.loadFileContents(this.checkSettingsFilename);
                return (CheckSettingsConfig)this.yaml.loadAs(string2, CheckSettingsConfig.class);
            }
            Scope.getCurrentScope().getUI().sendMessage("No changes have been made to default check configuration.");
            return null;
        }
        object = (CheckSettingsConfig)this.yaml.loadAs((String)object, CheckSettingsConfig.class);
        if (this.addMissingRules(list, (CheckSettingsConfig)object)) {
            this.write((CheckSettingsConfig)object);
        }
        this.sortRulesByPriority(list, (CheckSettingsConfig)object);
        return object;
    }

    private void sortRulesByPriority(List<AbstractLiquibaseRule> object, CheckSettingsConfig checkSettingsConfig) {
        ArrayList<AbstractConfigurableRule> arrayList = new ArrayList<AbstractConfigurableRule>(checkSettingsConfig.getRules().size());
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                AbstractLiquibaseRule abstractLiquibaseRule = (AbstractLiquibaseRule)object.next();
                arrayList.addAll(checkSettingsConfig.getExecutableRulesByRuleId(abstractLiquibaseRule.getId()));
            }
        }
        if (arrayList.size() != checkSettingsConfig.getRules().size()) {
            throw new CommandExecutionException("Some of the rules in your check settings config file do not match any of the known rules loaded by Liquibase.");
        }
        checkSettingsConfig.setRules(arrayList);
    }

    private boolean addMissingRules(List<AbstractLiquibaseRule> object, CheckSettingsConfig checkSettingsConfig) {
        boolean bl2 = false;
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                AbstractLiquibaseRule abstractLiquibaseRule = (AbstractLiquibaseRule)object.next();
                if (checkSettingsConfig.getRuleById(abstractLiquibaseRule.getId()) != null) continue;
                bl2 = checkSettingsConfig.getRules().add(AbstractConfigurableRule.fromRuleImplementation(abstractLiquibaseRule));
            }
        }
        return bl2;
    }

    public void write(CheckSettingsConfig object) {
        object = this.yaml.dump(object);
        this.fileAccessor.writeFileContents(this.checkSettingsFilename, (String)object);
    }
}

