/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.builder;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import java.security.AccessController;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.CompilerConfiguration;

public class AstStringCompiler {
    public List<ASTNode> compile(String script, CompilePhase compilePhase, boolean statementsOnly) {
        String scriptClassName = AstStringCompiler.makeScriptClassName();
        GroovyCodeSource codeSource = new GroovyCodeSource(script, scriptClassName + ".groovy", "/groovy/script");
        CompilationUnit cu = new CompilationUnit(CompilerConfiguration.DEFAULT, codeSource.getCodeSource(), AccessController.doPrivileged(GroovyClassLoader::new));
        cu.addSource(codeSource.getName(), script);
        cu.compile(compilePhase.getPhaseNumber());
        List result = cu.getAST().getModules().stream().reduce(new LinkedList(), (acc, node) -> {
            BlockStatement statementBlock = node.getStatementBlock();
            if (null != statementBlock) {
                acc.add(statementBlock);
            }
            acc.addAll(node.getClasses().stream().filter(c -> !statementsOnly || !scriptClassName.equals(c.getName())).collect(Collectors.toList()));
            return acc;
        }, (o1, o2) -> o1);
        return result;
    }

    public List<ASTNode> compile(String script) {
        return this.compile(script, CompilePhase.CONVERSION, true);
    }

    private static String makeScriptClassName() {
        return "Script" + System.nanoTime();
    }
}

