import React from 'react';
import { mount } from 'enzyme/build';
import { TextAreaMarkdown } from './textarea-markdown.component';

describe('TextAreaMarkdown Component', () => {
    test('should render markdown by default', () => {
        const onTextChange = jest.fn();
        const component = mount(<TextAreaMarkdown onTextChange={onTextChange} rows={5} text={'my **markdown** text'} />);
        expect(component.find('.markdown-switcher textarea').exists()).toBeFalsy();
        expect(component.find('.markdown-switcher .markdown-wrapper strong').text()).toBe('markdown');
    });

    test('should switch to edit mode', () => {
        const onTextChange = jest.fn();
        const component = mount(<TextAreaMarkdown onTextChange={onTextChange} rows={5} text={'my **markdown** text'} />);
        // initial markdown mode
        expect(component.find('.markdown-switcher .markdown-wrapper strong').text()).toBe('markdown');
        expect(component.find('.markdown-switcher textarea').exists()).toBeFalsy();
        // edit mode
        component.find('.markdown-switcher .xl-icon.edit-icon').simulate('click');
        expect(component.find('.markdown-switcher textarea').exists()).toBeTruthy();
        expect(component.find('.markdown-switcher .markdown-wrapper strong').exists()).toBeFalsy();
        // markdown mode
        component.find('.markdown-switcher .actions-wrapper .cancel').simulate('click');
        expect(component.find('.markdown-switcher .markdown-wrapper strong').text()).toBe('markdown');
        expect(component.find('.markdown-switcher textarea').exists()).toBeFalsy();
        expect(onTextChange).not.toHaveBeenCalled();
    });

    test('should save and cancel changes', () => {
        const onTextChange = jest.fn();
        const component = mount(<TextAreaMarkdown onTextChange={onTextChange} rows={5} text={'my **markdown** text'} />);
        // original text
        expect(component.find('.markdown-switcher .markdown-wrapper strong').text()).toBe('markdown');
        expect(component.find('.markdown-switcher textarea').exists()).toBeFalsy();

        // do change
        component.find('.markdown-switcher .xl-icon.edit-icon').simulate('click');
        expect(component.find('.markdown-switcher textarea').exists()).toBeTruthy();
        component.find('.markdown-switcher textarea').simulate('change', { target: { value: 'my ```fancy code```' } });
        // cancel change
        component.find('.markdown-switcher .actions-wrapper .cancel').simulate('click');
        // original state
        expect(component.find('.markdown-switcher textarea').exists()).toBeFalsy();
        expect(component.find('.markdown-switcher .markdown-wrapper strong').text()).toBe('markdown');
        expect(component.find('.markdown-switcher .markdown-wrapper pre code').exists()).toBeFalsy();
        // do change
        component.find('.markdown-switcher .xl-icon.edit-icon').simulate('click');
        component.find('.markdown-switcher textarea').simulate('change', { target: { value: 'my ```fancy code```' } });
        // save change
        component.find('.markdown-switcher .actions-wrapper .ok').simulate('click');
        expect(onTextChange).toHaveBeenCalledWith('my ```fancy code```');
        // can't make this to work, enzyme shows old component state
        // expect(component.find('.markdown-switcher .markdown-wrapper pre code').text()).toBe('fancy code');
    });
});
