/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.rest.credentials;

import com.synopsys.integration.builder.Buildable;
import com.synopsys.integration.rest.credentials.CredentialsBuilder;
import com.synopsys.integration.util.MaskedStringFieldToStringBuilder;
import com.synopsys.integration.util.Stringable;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class Credentials
extends Stringable
implements Buildable {
    public static final Credentials NO_CREDENTIALS = new Credentials(null, null);
    private final String username;
    private final String password;

    public static CredentialsBuilder newBuilder() {
        return new CredentialsBuilder();
    }

    Credentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    public Optional<String> getPassword() {
        return Optional.ofNullable(this.password);
    }

    public String getMaskedPassword() {
        return "************************";
    }

    public boolean isBlank() {
        return StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.username, this.password});
    }

    @Override
    public String toString() {
        return new MaskedStringFieldToStringBuilder(this, "password").toString();
    }
}

