/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.shared.common.error.ShutdownException;
import org.apache.derby.shared.common.error.StandardException;

public class InterruptStatus {
    public static final int MAX_INTERRUPT_RETRIES = 120;
    public static final int INTERRUPT_RETRY_SLEEP = 500;
    private static final ThreadLocal<Exception> exception = new ThreadLocal();

    public static void setInterrupted() {
        LanguageConnectionContext languageConnectionContext = null;
        try {
            languageConnectionContext = (LanguageConnectionContext)InterruptStatus.getContextOrNull("LanguageConnectionContext");
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        Thread.interrupted();
        StandardException standardException = StandardException.newException((String)"08000", (Object[])new Object[0]);
        if (languageConnectionContext != null) {
            languageConnectionContext.setInterruptedException(standardException);
        } else {
            exception.set((Exception)((Object)standardException));
        }
    }

    public static void saveInfoFromLcc(LanguageConnectionContext languageConnectionContext) {
        StandardException standardException = languageConnectionContext.getInterruptedException();
        if (standardException != null) {
            exception.set((Exception)((Object)standardException));
        }
    }

    public static boolean noteAndClearInterrupt(String string, int n, int n2) {
        if (Thread.currentThread().isInterrupted()) {
            InterruptStatus.setInterrupted();
            Thread.interrupted();
            return true;
        }
        return false;
    }

    public static void restoreIntrFlagIfSeen() {
        LanguageConnectionContext languageConnectionContext = null;
        try {
            languageConnectionContext = (LanguageConnectionContext)InterruptStatus.getContextOrNull("LanguageConnectionContext");
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        if (languageConnectionContext == null) {
            if (exception.get() != null) {
                exception.set(null);
                Thread.currentThread().interrupt();
            }
        } else if (languageConnectionContext.getInterruptedException() != null) {
            languageConnectionContext.setInterruptedException(null);
            Thread.currentThread().interrupt();
        }
    }

    public static void restoreIntrFlagIfSeen(LanguageConnectionContext languageConnectionContext) {
        if (languageConnectionContext.getInterruptedException() != null) {
            languageConnectionContext.setInterruptedException(null);
            Thread.currentThread().interrupt();
        }
    }

    public static void throwIf(LanguageConnectionContext languageConnectionContext) throws StandardException {
        StandardException standardException;
        if (Thread.currentThread().isInterrupted()) {
            InterruptStatus.setInterrupted();
        }
        if ((standardException = languageConnectionContext.getInterruptedException()) != null) {
            languageConnectionContext.setInterruptedException(null);
            throw standardException;
        }
    }

    private static Context getContextOrNull(final String string) {
        if (System.getSecurityManager() == null) {
            return ContextService.getContextOrNull(string);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContextOrNull(string);
            }
        });
    }
}

