import React from 'react';
import { mount } from 'enzyme/build';
import { ReleaseStatusComponent } from './release-status.component';

describe('ReleaseStatusComponent', () => {
    test('should render release status label', () => {
        const releaseStatusInProgressComponent = mount(<ReleaseStatusComponent status="IN_PROGRESS" />);
        expect(releaseStatusInProgressComponent.find('.release-status-view > span').text()).toContain('In progress');
        expect(releaseStatusInProgressComponent.find('.release-status-view > span').prop('className')).toContain('release-status-label in_progress');

        const releaseStatusPlannedComponent = mount(<ReleaseStatusComponent status="PLANNED" />);
        expect(releaseStatusPlannedComponent.find('.release-status-view > span').text()).toContain('Planned');
        expect(releaseStatusPlannedComponent.find('.release-status-view > span').prop('className')).toContain('release-status-label planned');

        const releaseStatusAbortedComponent = mount(<ReleaseStatusComponent status="ABORTED" />);
        expect(releaseStatusAbortedComponent.find('.release-status-view > span').text()).toContain('Aborted');
        expect(releaseStatusAbortedComponent.find('.release-status-view > span').prop('className')).toContain('release-status-label aborted');

        const releaseStatusPausedComponent = mount(<ReleaseStatusComponent status="PAUSED" />);
        expect(releaseStatusPausedComponent.find('.release-status-view > span').text()).toContain('Paused');
        expect(releaseStatusPausedComponent.find('.release-status-view > span').prop('className')).toContain('release-status-label paused');

        const releaseStatusFailingComponent = mount(<ReleaseStatusComponent status="FAILING" />);
        expect(releaseStatusFailingComponent.find('.release-status-view > span').text()).toContain('Failing');
        expect(releaseStatusFailingComponent.find('.release-status-view > span').prop('className')).toContain('release-status-label failing');

        const releaseStatusFailedComponent = mount(<ReleaseStatusComponent status="FAILED" />);
        expect(releaseStatusFailedComponent.find('.release-status-view > span').text()).toContain('Failed');
        expect(releaseStatusFailedComponent.find('.release-status-view > span').prop('className')).toContain('release-status-label failed');

        const releaseStatusCompletedComponent = mount(<ReleaseStatusComponent status="COMPLETED" />);
        expect(releaseStatusCompletedComponent.find('.release-status-view > span').text()).toContain('Completed');
        expect(releaseStatusCompletedComponent.find('.release-status-view > span').prop('className')).toContain('release-status-label completed');
    });

    test('should render completed and archived release status', () => {
        const releaseStatuses = [
            {
                status: 'Completed',
                className: 'release-status-label completed',
            },
            {
                status: 'Archived',
                className: 'release-status-label archived',
            },
        ];
        const releaseStatusComponent = mount(<ReleaseStatusComponent isArchived={true} status="COMPLETED" />);
        releaseStatusComponent.find('.release-status-view > span').forEach((node, idx) => {
            expect(node.text()).toContain(releaseStatuses[idx].status);
            expect(node.prop('className')).toContain(releaseStatuses[idx].className);
        });
    });
});
