/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.reactor;

import java.io.IOException;
import java.util.Set;
import org.apache.qpid.proton.engine.Collector;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.HandlerException;
import org.apache.qpid.proton.engine.Record;
import org.apache.qpid.proton.reactor.Acceptor;
import org.apache.qpid.proton.reactor.ReactorChild;
import org.apache.qpid.proton.reactor.ReactorOptions;
import org.apache.qpid.proton.reactor.Selectable;
import org.apache.qpid.proton.reactor.Task;
import org.apache.qpid.proton.reactor.impl.ReactorImpl;

public interface Reactor {
    public long mark();

    public long now();

    public Record attachments();

    public void setTimeout(long var1);

    public long getTimeout();

    public Handler getGlobalHandler();

    public void setGlobalHandler(Handler var1);

    public Handler getHandler();

    public void setHandler(Handler var1);

    public Set<ReactorChild> children();

    public Collector collector();

    public Selectable selectable();

    public void update(Selectable var1);

    public void yield();

    public boolean quiesced();

    public boolean process() throws HandlerException;

    public void wakeup();

    public void start();

    public void stop() throws HandlerException;

    public void run() throws HandlerException;

    public Task schedule(int var1, Handler var2);

    @Deprecated
    public Connection connection(Handler var1);

    public Connection connectionToHost(String var1, int var2, Handler var3);

    public void setConnectionHost(Connection var1, String var2, int var3);

    public ReactorOptions getOptions();

    public String getConnectionAddress(Connection var1);

    public Acceptor acceptor(String var1, int var2) throws IOException;

    public Acceptor acceptor(String var1, int var2, Handler var3) throws IOException;

    public void free();

    public static final class Factory {
        public static Reactor create() throws IOException {
            return new ReactorImpl();
        }

        public static Reactor create(ReactorOptions options) throws IOException {
            return new ReactorImpl(options);
        }
    }
}

