/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.delivery.conditions;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.delivery.Condition;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.TrackedItemStatus;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Metadata(versioned=false, description="Condition which completes when all tracked items preceding the transition are in a certain status.")
@PublicApiRef
@ShowOnlyPublicApiMembers
public class ItemsCompletionCondition
extends Condition {
    private static final List<String> DEFAULT_COMPLETED_STATUSES = Arrays.stream(TrackedItemStatus.DONE_STATUSES).map(Objects::toString).collect(Collectors.toList());
    @Property(isTransient=true, hidden=true, defaultValue="READY,SKIPPED", description="Allowed statuses of tracked items.")
    private List<String> statuses = DEFAULT_COMPLETED_STATUSES;
    @Property(isTransient=true, hidden=true, defaultValue="true", description="Transition even with de-scoped tracked items present.")
    private boolean ignoreDescoped = true;

    public ItemsCompletionCondition() {
    }

    public ItemsCompletionCondition(List<String> statuses) {
        this.statuses = statuses;
    }

    @Override
    public String getDescription() {
        return "Wait for all items to be completed";
    }

    @Override
    public void validate(Delivery delivery) {
        Checks.checkNotNull(this.statuses, (String)"Statuses");
        Checks.checkArgument((this.statuses.size() > 0 ? 1 : 0) != 0, (String)"Statuses must not be empty", (Object[])new Object[0]);
        Checks.checkArgument((boolean)DEFAULT_COMPLETED_STATUSES.containsAll(this.statuses), (String)"Status must be one of the values: %s", (Object[])new Object[]{DEFAULT_COMPLETED_STATUSES});
    }

    public List<String> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<String> statuses) {
        this.statuses = statuses;
    }

    public boolean isIgnoreDescoped() {
        return this.ignoreDescoped;
    }

    public void setIgnoreDescoped(boolean ignoreDescoped) {
        this.ignoreDescoped = ignoreDescoped;
    }
}

