/*
 * Decompiled with CFR 0.152.
 */
package akka.http.scaladsl.server.directives;

import akka.event.LoggingAdapter;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.server.ConjunctionMagnet$;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.directives.CodingDirectives$;
import akka.http.scaladsl.server.directives.ContentTypeResolver;
import akka.http.scaladsl.server.directives.FileAndResourceDirectives;
import akka.http.scaladsl.server.directives.RangeDirectives$;
import akka.http.scaladsl.server.util.TupleOps$Join$;
import java.io.File;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;

public final class FileAndResourceDirectives$
implements FileAndResourceDirectives {
    public static final FileAndResourceDirectives$ MODULE$ = new FileAndResourceDirectives$();
    private static final Directive<BoxedUnit> akka$http$scaladsl$server$directives$FileAndResourceDirectives$$withRangeSupportAndPrecompressedMediaTypeSupport;

    static {
        FileAndResourceDirectives.$init$(MODULE$);
        akka$http$scaladsl$server$directives$FileAndResourceDirectives$$withRangeSupportAndPrecompressedMediaTypeSupport = (Directive)RangeDirectives$.MODULE$.withRangeSupport().$amp(ConjunctionMagnet$.MODULE$.fromDirective(CodingDirectives$.MODULE$.withPrecompressedMediaTypeSupport(), TupleOps$Join$.MODULE$.join0P()));
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromFile(String fileName, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromFile$((FileAndResourceDirectives)this, fileName, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromFile(File file, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromFile$((FileAndResourceDirectives)this, file, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromFile(File file, ContentType contentType) {
        return FileAndResourceDirectives.getFromFile$((FileAndResourceDirectives)this, file, contentType);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromResource(String resourceName, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromResource$(this, resourceName, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromResource(String resourceName, ContentType contentType, ClassLoader classLoader) {
        return FileAndResourceDirectives.getFromResource$(this, resourceName, contentType, classLoader);
    }

    @Override
    public ClassLoader getFromResource$default$3() {
        return FileAndResourceDirectives.getFromResource$default$3$(this);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromDirectory(String directoryName, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromDirectory$(this, directoryName, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> listDirectoryContents(Seq<String> directories, FileAndResourceDirectives.DirectoryRenderer renderer) {
        return FileAndResourceDirectives.listDirectoryContents$(this, directories, renderer);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromBrowseableDirectory(String directory, FileAndResourceDirectives.DirectoryRenderer renderer, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromBrowseableDirectory$(this, directory, renderer, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromBrowseableDirectories(Seq<String> directories, FileAndResourceDirectives.DirectoryRenderer renderer, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromBrowseableDirectories$(this, directories, renderer, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromResourceDirectory(String directoryName, ClassLoader classLoader, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromResourceDirectory$(this, directoryName, classLoader, resolver);
    }

    @Override
    public ClassLoader getFromResourceDirectory$default$2() {
        return FileAndResourceDirectives.getFromResourceDirectory$default$2$(this);
    }

    @Override
    public ClassLoader _defaultClassLoader() {
        return FileAndResourceDirectives._defaultClassLoader$(this);
    }

    public Directive<BoxedUnit> akka$http$scaladsl$server$directives$FileAndResourceDirectives$$withRangeSupportAndPrecompressedMediaTypeSupport() {
        return akka$http$scaladsl$server$directives$FileAndResourceDirectives$$withRangeSupportAndPrecompressedMediaTypeSupport;
    }

    public String akka$http$scaladsl$server$directives$FileAndResourceDirectives$$withTrailingSlash(String path) {
        return path.endsWith("/") ? path : new StringBuilder(0).append(path).append('/').toString();
    }

    public String akka$http$scaladsl$server$directives$FileAndResourceDirectives$$safeDirectoryChildPath(String basePath, Uri.Path path, LoggingAdapter log, char separator) {
        String string;
        block3: {
            String string2 = this.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$safeJoinPaths(basePath, path, log, separator);
            switch (string2 == null ? 0 : string2.hashCode()) {
                case 0: {
                    if (!"".equals(string2)) break;
                    string = "";
                    break block3;
                }
            }
            string = this.checkIsSafeDescendant(basePath, string2, log);
        }
        return string;
    }

    public char akka$http$scaladsl$server$directives$FileAndResourceDirectives$$safeDirectoryChildPath$default$4() {
        return File.separatorChar;
    }

    public String akka$http$scaladsl$server$directives$FileAndResourceDirectives$$safeJoinPaths(String base, Uri.Path path, LoggingAdapter log, char separator) {
        return this.rec$1(path.startsWithSlash() ? path.tail() : path, FileAndResourceDirectives$.rec$default$2$1(base), separator, log, base, path);
    }

    private String checkIsSafeDescendant(String basePath, String finalPath, LoggingAdapter log) {
        String string;
        File baseFile = new File(basePath);
        File finalFile = new File(finalPath);
        String canonicalFinalPath = finalFile.getCanonicalPath();
        if (!canonicalFinalPath.startsWith(baseFile.getCanonicalPath())) {
            log.warning(new StringBuilder(18).append(new StringBuilder(74).append("[").append(finalFile).append("] points to a location that is not part of [").append(baseFile).append("]. This might be a directory ").toString()).append("traversal attempt.").toString());
            string = "";
        } else {
            string = canonicalFinalPath;
        }
        return string;
    }

    private final String rec$1(Uri.Path p, StringBuilder result, char separator$1, LoggingAdapter log$1, String base$2, Uri.Path path$2) {
        String string;
        block4: {
            Uri.Path path;
            block5: {
                String head;
                while (true) {
                    if (Uri.Path$.Empty$.MODULE$.equals(path = p)) {
                        string = result.toString();
                        break block4;
                    }
                    if (path instanceof Uri.Path$.Slash) {
                        Uri.Path$.Slash slash = (Uri.Path$.Slash)path;
                        Uri.Path tail = slash.tail();
                        result = result.append(separator$1);
                        p = tail;
                        continue;
                    }
                    if (!(path instanceof Uri.Path$.Segment)) break block5;
                    Uri.Path$.Segment segment = (Uri.Path$.Segment)path;
                    head = segment.head();
                    Uri.Path.SlashOrEmpty tail = segment.tail();
                    if (head.indexOf(47) >= 0 || head.indexOf(92) >= 0) break;
                    String string2 = head;
                    String string3 = "..";
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        break;
                    }
                    result = result.append(head);
                    p = tail;
                }
                log$1.warning("File-system path for base [{}] and Uri.Path [{}] contains suspicious path segment [{}], GET access was disallowed", (Object)base$2, (Object)path$2, (Object)head);
                string = "";
                break block4;
            }
            throw new MatchError((Object)path);
        }
        return string;
    }

    private static final StringBuilder rec$default$2$1(String base$2) {
        return new StringBuilder(base$2);
    }

    private FileAndResourceDirectives$() {
    }
}

