/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.DependencyBuilder;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.DependencyCreatedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyDeletedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.IdMatchers;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseRepository;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.DependencyCandidateCollector;
import com.xebialabs.xlrelease.service.DependencyService$IdAndStatus$;
import com.xebialabs.xlrelease.service.LockedTaskOperationChecks$;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseTreeBuilder;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import com.xebialabs.xlrelease.views.ReleaseTree;
import com.xebialabs.xlrelease.views.ReleaseTreeItem;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Service
@ScalaSignature(bytes="\u0006\u0005\r-f\u0001B\"E\u00015C\u0001b\u0019\u0001\u0003\u0006\u0004%\t\u0001\u001a\u0005\tW\u0002\u0011\t\u0011)A\u0005K\"AA\u000e\u0001BC\u0002\u0013\u0005Q\u000e\u0003\u0005r\u0001\t\u0005\t\u0015!\u0003o\u0011!\u0011\bA!b\u0001\n\u0003\u0019\b\u0002C<\u0001\u0005\u0003\u0005\u000b\u0011\u0002;\t\u0011a\u0004!Q1A\u0005\u0002eD\u0001\" \u0001\u0003\u0002\u0003\u0006IA\u001f\u0005\t}\u0002\u0011)\u0019!C\u0001\u007f\"Q\u0011Q\u0002\u0001\u0003\u0002\u0003\u0006I!!\u0001\t\u0015\u0005=\u0001A!b\u0001\n\u0003\t\t\u0002\u0003\u0006\u0002\u001a\u0001\u0011\t\u0011)A\u0005\u0003'A!\"a\u0007\u0001\u0005\u000b\u0007I\u0011AA\u000f\u0011)\t)\u0003\u0001B\u0001B\u0003%\u0011q\u0004\u0005\u000b\u0003O\u0001!Q1A\u0005\u0002\u0005%\u0002BCA\u0019\u0001\t\u0005\t\u0015!\u0003\u0002,!Q\u00111\u0007\u0001\u0003\u0006\u0004%\t!!\u000e\t\u0015\u0005u\u0002A!A!\u0002\u0013\t9\u0004C\u0004\u0002@\u0001!\t!!\u0011\t\u0013\u0005U\u0004A1A\u0005\u0002\u0005]\u0004\u0002CAQ\u0001\u0001\u0006I!!\u001f\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002&\"9\u0011Q\u001b\u0001\u0005\u0002\u0005]\u0007bBAq\u0001\u0011\u0005\u00111\u001d\u0005\b\u0003w\u0004A\u0011AA\u007f\u0011\u001d\u0011i\u0002\u0001C\u0001\u0005?AqA!\f\u0001\t\u0003\u0011y\u0003C\u0004\u00038\u0001!IA!\u000f\t\u000f\tu\u0002\u0001\"\u0001\u0003@!9!Q\b\u0001\u0005\u0002\t\u0015\u0003b\u0002B'\u0001\u0011%!q\n\u0005\n\u0005G\u0002\u0011\u0013!C\u0005\u0005KB\u0011B!\u001f\u0001#\u0003%IAa\u001f\t\u000f\t}\u0004\u0001\"\u0001\u0003\u0002\"9!q\u0011\u0001\u0005\n\t%\u0005b\u0002BI\u0001\u0011\u0005!1\u0013\u0005\b\u0005K\u0003A\u0011\u0001BT\u0011\u001d\u0011I\f\u0001C\u0001\u0005w3aA!2\u0001\u0001\n\u001d\u0007BCA|O\tU\r\u0011\"\u0001\u0003V\"Q!q[\u0014\u0003\u0012\u0003\u0006I!!%\t\u0015\tewE!f\u0001\n\u0003\u0011)\u000e\u0003\u0006\u0003\\\u001e\u0012\t\u0012)A\u0005\u0003#Cq!a\u0010(\t\u0003\u0011i\u000eC\u0005\u0003h\u001e\n\t\u0011\"\u0001\u0003j\"I!q^\u0014\u0012\u0002\u0013\u0005!\u0011\u001f\u0005\n\u0005k<\u0013\u0013!C\u0001\u0005cD\u0011Ba>(\u0003\u0003%\tE!?\t\u0013\r\u0015q%!A\u0005\u0002\r\u001d\u0001\"CB\bO\u0005\u0005I\u0011AB\t\u0011%\u0019ibJA\u0001\n\u0003\u001ay\u0002C\u0005\u0004.\u001d\n\t\u0011\"\u0001\u00040!I11G\u0014\u0002\u0002\u0013\u00053Q\u0007\u0005\n\u0007s9\u0013\u0011!C!\u0007wA\u0011b!\u0010(\u0003\u0003%\tea\u0010\t\u0013\r\u0005s%!A\u0005B\r\rs!CB$\u0001\u0005\u0005\t\u0012AB%\r%\u0011)\rAA\u0001\u0012\u0003\u0019Y\u0005C\u0004\u0002@i\"\taa\u0019\t\u0013\ru\"(!A\u0005F\r}\u0002\"CB3u\u0005\u0005I\u0011QB4\u0011%\u0019iGOA\u0001\n\u0003\u001by\u0007C\u0004\u0004\u0002\u0002!\taa!\t\u000f\r-\u0005\u0001\"\u0003\u0004\u000e\"91\u0011\u0013\u0001\u0005\u0012\rM\u0005bBBL\u0001\u0011E1\u0011\u0014\u0002\u0012\t\u0016\u0004XM\u001c3f]\u000eL8+\u001a:wS\u000e,'BA#G\u0003\u001d\u0019XM\u001d<jG\u0016T!a\u0012%\u0002\u0013ad'/\u001a7fCN,'BA%K\u0003%AXMY5bY\u0006\u00147OC\u0001L\u0003\r\u0019w.\\\u0002\u0001'\u0015\u0001a\n\u0016-\\!\ty%+D\u0001Q\u0015\u0005\t\u0016!B:dC2\f\u0017BA*Q\u0005\u0019\te.\u001f*fMB\u0011QKV\u0007\u0002\t&\u0011q\u000b\u0012\u0002\u0013%\u0016dW-Y:f)J,WMQ;jY\u0012,'\u000f\u0005\u0002V3&\u0011!\f\u0012\u0002\u001d\t\u0016\u0004XM\u001c3f]\u000eL8)\u00198eS\u0012\fG/Z\"pY2,7\r^8s!\ta\u0016-D\u0001^\u0015\tqv,A\u0003tY\u001a$$NC\u0001a\u0003!9'/\u001b>{Y\u0016$\u0017B\u00012^\u0005\u001daunZ4j]\u001e\f\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z+\u0005)\u0007C\u00014j\u001b\u00059'B\u00015G\u0003)\u0011X\r]8tSR|'/_\u0005\u0003U\u001e\u0014\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0003I\u0011X\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\u0011\u0002)I,G.Z1tKN+\u0017M]2i'\u0016\u0014h/[2f+\u0005q\u0007CA+p\u0013\t\u0001HI\u0001\u000bSK2,\u0017m]3TK\u0006\u00148\r[*feZL7-Z\u0001\u0016e\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3!\u0003I\u0001H.\u00198Ji\u0016l'+\u001a9pg&$xN]=\u0016\u0003Q\u0004\"AZ;\n\u0005Y<'A\u0005)mC:LE/Z7SKB|7/\u001b;pef\f1\u0003\u001d7b]&#X-\u001c*fa>\u001c\u0018\u000e^8ss\u0002\nA\u0003Z3qK:$WM\\2z%\u0016\u0004xn]5u_JLX#\u0001>\u0011\u0005\u0019\\\u0018B\u0001?h\u0005Q!U\r]3oI\u0016t7-\u001f*fa>\u001c\u0018\u000e^8ss\u0006)B-\u001a9f]\u0012,gnY=SKB|7/\u001b;pef\u0004\u0013\u0001C3wK:$()^:\u0016\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001da)\u0001\u0004fm\u0016tGo]\u0005\u0005\u0003\u0017\t)A\u0001\u0005Fm\u0016tGOQ;t\u0003%)g/\u001a8u\u0005V\u001c\b%\u0001\buCN\\'+\u001a9pg&$xN]=\u0016\u0005\u0005M\u0001c\u00014\u0002\u0016%\u0019\u0011qC4\u0003\u001dQ\u000b7o\u001b*fa>\u001c\u0018\u000e^8ss\u0006yA/Y:l%\u0016\u0004xn]5u_JL\b%A\bqQ\u0006\u001cXMU3q_NLGo\u001c:z+\t\ty\u0002E\u0002g\u0003CI1!a\th\u0005=\u0001\u0006.Y:f%\u0016\u0004xn]5u_JL\u0018\u0001\u00059iCN,'+\u001a9pg&$xN]=!\u0003-\u0019\u0017.\u00133TKJ4\u0018nY3\u0016\u0005\u0005-\u0002cA+\u0002.%\u0019\u0011q\u0006#\u0003\u0017\rK\u0017\nZ*feZL7-Z\u0001\rG&LEmU3sm&\u001cW\rI\u0001\u0011CJ\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016,\"!a\u000e\u0011\u0007U\u000bI$C\u0002\u0002<\u0011\u0013\u0001#\u0011:dQ&4\u0018N\\4TKJ4\u0018nY3\u0002#\u0005\u00148\r[5wS:<7+\u001a:wS\u000e,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0015\u0003\u0007\n)%a\u0012\u0002J\u0005-\u0013QJA(\u0003#\n\u0019&!\u0016\u0011\u0005U\u0003\u0001\"B2\u0014\u0001\u0004)\u0007\"\u00027\u0014\u0001\u0004q\u0007\"\u0002:\u0014\u0001\u0004!\b\"\u0002=\u0014\u0001\u0004Q\bB\u0002@\u0014\u0001\u0004\t\t\u0001C\u0004\u0002\u0010M\u0001\r!a\u0005\t\u000f\u0005m1\u00031\u0001\u0002 !9\u0011qE\nA\u0002\u0005-\u0002bBA\u001a'\u0001\u0007\u0011q\u0007\u0015\u0004'\u0005e\u0003\u0003BA.\u0003cj!!!\u0018\u000b\t\u0005}\u0013\u0011M\u0001\u000bC:tw\u000e^1uS>t'\u0002BA2\u0003K\nqAZ1di>\u0014\u0018P\u0003\u0003\u0002h\u0005%\u0014!\u00022fC:\u001c(\u0002BA6\u0003[\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003_\n1a\u001c:h\u0013\u0011\t\u0019(!\u0018\u0003\u0013\u0005+Ho\\<je\u0016$\u0017\u0001G1di&4X\rR3qK:$WM\\2z'R\fG/^:fgV\u0011\u0011\u0011\u0010\t\u0007\u0003w\nY)!%\u000f\t\u0005u\u0014q\u0011\b\u0005\u0003\u007f\n))\u0004\u0002\u0002\u0002*\u0019\u00111\u0011'\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0016bAAE!\u00069\u0001/Y2lC\u001e,\u0017\u0002BAG\u0003\u001f\u00131aU3r\u0015\r\tI\t\u0015\t\u0005\u0003'\u000bYJ\u0004\u0003\u0002\u0016\u0006]\u0005cAA@!&\u0019\u0011\u0011\u0014)\u0002\rA\u0013X\rZ3g\u0013\u0011\ti*a(\u0003\rM#(/\u001b8h\u0015\r\tI\nU\u0001\u001aC\u000e$\u0018N^3EKB,g\u000eZ3oGf\u001cF/\u0019;vg\u0016\u001c\b%\u0001\u0004de\u0016\fG/\u001a\u000b\u0007\u0003O\u000b\u0019,!0\u0011\t\u0005%\u0016qV\u0007\u0003\u0003WS1!!,G\u0003\u0019!w.\\1j]&!\u0011\u0011WAV\u0005)!U\r]3oI\u0016t7-\u001f\u0005\b\u0003k3\u0002\u0019AA\\\u0003\u00119\u0017\r^3\u0011\t\u0005%\u0016\u0011X\u0005\u0005\u0003w\u000bYK\u0001\u0005HCR,G+Y:l\u0011\u001d\tyL\u0006a\u0001\u0003#\u000b!\u0003^1sO\u0016$\u0018\nZ(s-\u0006\u0014\u0018.\u00192mK\"\u001aa#a1\u0011\t\u0005\u0015\u0017\u0011[\u0007\u0003\u0003\u000fTA!a\u0018\u0002J*!\u00111ZAg\u0003\u001diW\r\u001e:jGNT1!a4K\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BAj\u0003\u000f\u0014Q\u0001V5nK\u0012\fA\"\u001e9eCR,G+\u0019:hKR$b!a*\u0002Z\u0006u\u0007bBAn/\u0001\u0007\u0011\u0011S\u0001\rI\u0016\u0004XM\u001c3f]\u000eL\u0018\n\u001a\u0005\b\u0003\u007f;\u0002\u0019AAIQ\r9\u00121Y\u0001\u0007I\u0016dW\r^3\u0015\r\u0005\u0015\u00181^A{!\ry\u0015q]\u0005\u0004\u0003S\u0004&\u0001B+oSRDq!!<\u0019\u0001\u0004\ty/A\u0004sK2,\u0017m]3\u0011\t\u0005%\u0016\u0011_\u0005\u0005\u0003g\fYKA\u0004SK2,\u0017m]3\t\u000f\u0005]\b\u00041\u0001\u0002\u0012\u0006\u0011\u0011\u000e\u001a\u0015\u00041\u0005\r\u0017!F4fi\u000e{W\u000e\u001d7fi\u0006\u0014G.Z$bi\u0016LEm\u001d\u000b\u0005\u0003\u007f\u0014y\u0001\u0005\u0004\u0003\u0002\t-\u0011\u0011S\u0007\u0003\u0005\u0007QAA!\u0002\u0003\b\u0005!Q\u000f^5m\u0015\t\u0011I!\u0001\u0003kCZ\f\u0017\u0002\u0002B\u0007\u0005\u0007\u0011!bQ8mY\u0016\u001cG/[8o\u0011\u001d\u0011\t\"\u0007a\u0001\u0005'\tq\u0001^1sO\u0016$8\u000f\u0005\u0004\u0003\u0002\t-!Q\u0003\t\u0005\u0003S\u00139\"\u0003\u0003\u0003\u001a\u0005-&\u0001\u0003)mC:LE/Z7)\u0007e\t\u0019-A\rgS:$\u0017i\u0019;jm\u0016LenY8nS:<w)\u0019;f\u0013\u0012\u001cH\u0003\u0002B\u0011\u0005O\u0001bA!\u0001\u0003$\u0005E\u0015\u0002\u0002B\u0013\u0005\u0007\u0011A\u0001T5ti\"9!\u0011\u0006\u000eA\u0002\u0005E\u0015!\u0003:fY\u0016\f7/Z%eQ\rQ\u00121Y\u0001,M&tG-Q2uSZ,\u0017J\\2p[&twmR1uK&#7oV5uQ>,H/\u0012=jgR\u001c8\t[3dWR!\u0011\u0011\u0010B\u0019\u0011\u001d\u0011\u0019d\u0007a\u0001\u0003#\u000b\u0001\u0002]1sK:$\u0018\n\u001a\u0015\u00047\u0005\r\u0017a\u00073p\r&tG-Q2uSZ,\u0017J\\2p[&twmR1uK&#7\u000f\u0006\u0003\u0002z\tm\u0002b\u0002B\u001a9\u0001\u0007\u0011\u0011S\u0001\u0013O\u0016$h)Y5mC\ndWmR1uK&#7\u000f\u0006\u0003\u0002\u0000\n\u0005\u0003b\u0002B\u0015;\u0001\u0007\u0011\u0011\u0013\u0015\u0004;\u0005\rG\u0003BA\u0000\u0005\u000fBqA!\u0013\u001f\u0001\u0004\u0011\u0019\"\u0001\bbE>\u0014H/\u001a3UCJ<W\r^:)\u0007y\t\u0019-\u0001\u000fgS:$\u0017\t\u001c7J]\u000e|W.\u001b8h\t\u0016\u0004XM\u001c3f]\u000eL\u0018\nZ:\u0015\u0011\u0005e$\u0011\u000bB+\u00053BqAa\u0015 \u0001\u0004\tI(A\u0005uCJ<W\r^%eg\"I!qK\u0010\u0011\u0002\u0003\u0007\u0011\u0011P\u0001\tgR\fG/^:fg\"I!1L\u0010\u0011\u0002\u0003\u0007!QL\u0001\u0014e\u00164WM]3oG&twm\u00115jY\u0012\u0014XM\u001c\t\u0004\u001f\n}\u0013b\u0001B1!\n9!i\\8mK\u0006t\u0017A\n4j]\u0012\fE\u000e\\%oG>l\u0017N\\4EKB,g\u000eZ3oGfLEm\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\r\u0016\u0005\u0003s\u0012Ig\u000b\u0002\u0003lA!!Q\u000eB;\u001b\t\u0011yG\u0003\u0003\u0003r\tM\u0014!C;oG\",7m[3e\u0015\r\ty\u0006U\u0005\u0005\u0005o\u0012yGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\faEZ5oI\u0006cG.\u00138d_6Lgn\u001a#fa\u0016tG-\u001a8ds&#7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011iH\u000b\u0003\u0003^\t%\u0014a\u00074j]\u0012\f5\r^5wK>+HoZ8j]\u001e$\u0016M]4fi&#7\u000f\u0006\u0003\u0003\"\t\r\u0005b\u0002B\u0015E\u0001\u0007\u0011\u0011\u0013\u0015\u0004E\u0005\r\u0017!\u00074j]\u0012\f5\r^5wK>+HoZ8j]\u001e$\u0016M]4fiN$BAa#\u0003\u000eB1\u00111PAF\u0005+AqA!\u000b$\u0001\u0004\t\t\nK\u0002$\u0003\u0007\fabZ3u%\u0016dW-Y:f)J,W\r\u0006\u0003\u0003\u0016\n\u0005\u0006\u0003\u0002BL\u0005;k!A!'\u000b\u0007\tme)A\u0003wS\u0016<8/\u0003\u0003\u0003 \ne%a\u0003*fY\u0016\f7/\u001a+sK\u0016DqA!\u000b%\u0001\u0004\t\t\nK\u0002%\u0003\u0007\f1$\u001e9eCR,w)\u0019;f%\u00164WM]3oG&tw\r\u00155bg\u0016\u001cHCBAs\u0005S\u0013i\u000bC\u0004\u0003,\u0016\u0002\r!!%\u0002\r\u001d\fG/Z%e\u0011\u001d\u0011y+\na\u0001\u0005c\u000b\u0001c\u001c:jO&tGk\u001c*fgR|'/\u001a3\u0011\u0011\t\u0005!1\u0017B\u000b\u0005+IAA!.\u0003\u0004\t\u0019Q*\u00199)\u0007\u0015\n\u0019-A\nbe\u000eD\u0017N^3EKB,g\u000eZ3oG&,7\u000f\u0006\u0004\u0002f\nu&q\u0018\u0005\b\u0005S1\u0003\u0019AAI\u0011\u001d\u0011\tM\na\u0001\u0003s\nQ\u0002Z3qK:$WM\\2z\u0013\u0012\u001c\bf\u0001\u0014\u0002D\nY\u0011\nZ!oIN#\u0018\r^;t'\u00199cJ!3\u0003PB\u0019qJa3\n\u0007\t5\u0007KA\u0004Qe>$Wo\u0019;\u0011\t\u0005m$\u0011[\u0005\u0005\u0005'\fyI\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0006\u0002\u0002\u0012\u0006\u0019\u0011\u000e\u001a\u0011\u0002\rM$\u0018\r^;t\u0003\u001d\u0019H/\u0019;vg\u0002\"bAa8\u0003d\n\u0015\bc\u0001BqO5\t\u0001\u0001C\u0004\u0002x2\u0002\r!!%\t\u000f\teG\u00061\u0001\u0002\u0012\u0006!1m\u001c9z)\u0019\u0011yNa;\u0003n\"I\u0011q_\u0017\u0011\u0002\u0003\u0007\u0011\u0011\u0013\u0005\n\u00053l\u0003\u0013!a\u0001\u0003#\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003t*\"\u0011\u0011\u0013B5\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B~!\u0011\u0011ipa\u0001\u000e\u0005\t}(\u0002BB\u0001\u0005\u000f\tA\u0001\\1oO&!\u0011Q\u0014B\u0000\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0019I\u0001E\u0002P\u0007\u0017I1a!\u0004Q\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0019\u0019b!\u0007\u0011\u0007=\u001b)\"C\u0002\u0004\u0018A\u00131!\u00118z\u0011%\u0019YBMA\u0001\u0002\u0004\u0019I!A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0007C\u0001baa\t\u0004*\rMQBAB\u0013\u0015\r\u00199\u0003U\u0001\u000bG>dG.Z2uS>t\u0017\u0002BB\u0016\u0007K\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!QLB\u0019\u0011%\u0019Y\u0002NA\u0001\u0002\u0004\u0019\u0019\"\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002B~\u0007oA\u0011ba\u00076\u0003\u0003\u0005\ra!\u0003\u0002\u0011!\f7\u000f[\"pI\u0016$\"a!\u0003\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa?\u0002\r\u0015\fX/\u00197t)\u0011\u0011if!\u0012\t\u0013\rm\u0001(!AA\u0002\rM\u0011aC%e\u0003:$7\u000b^1ukN\u00042A!9;'\u0015Q4QJB-!)\u0019ye!\u0016\u0002\u0012\u0006E%q\\\u0007\u0003\u0007#R1aa\u0015Q\u0003\u001d\u0011XO\u001c;j[\u0016LAaa\u0016\u0004R\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\rm3\u0011M\u0007\u0003\u0007;RAaa\u0018\u0003\b\u0005\u0011\u0011n\\\u0005\u0005\u0005'\u001ci\u0006\u0006\u0002\u0004J\u0005)\u0011\r\u001d9msR1!q\\B5\u0007WBq!a>>\u0001\u0004\t\t\nC\u0004\u0003Zv\u0002\r!!%\u0002\u000fUt\u0017\r\u001d9msR!1\u0011OB?!\u0015y51OB<\u0013\r\u0019)\b\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000f=\u001bI(!%\u0002\u0012&\u001911\u0010)\u0003\rQ+\b\u000f\\33\u0011%\u0019yHPA\u0001\u0002\u0004\u0011y.A\u0002yIA\naDZ5oI\u0012+\u0007/\u001a8eK:\u001c\u0017\u0010V1sO\u0016$()\u001f+be\u001e,G/\u00133\u0015\t\t}7Q\u0011\u0005\b\u0007\u000f{\u0004\u0019AAI\u0003!!\u0018M]4fi&#\u0007fA \u0002D\u0006Iq-\u001a;Ti\u0006$Xo\u001d\u000b\u0005\u0003#\u001by\tC\u0004\u0004\b\u0002\u0003\r!!%\u0002;\u0019Lg\u000eZ%o!J|wM]3tg&s7m\\7j]\u001e<\u0015\r^3JIN$B!!\u001f\u0004\u0016\"9!1K!A\u0002\u0005e\u0014AC5t)\u0016l\u0007\u000f\\1uKR!!QLBN\u0011\u001d\tYN\u0011a\u0001\u0003#C3\u0001ABP!\u0011\u0019\tka*\u000e\u0005\r\r&\u0002BBS\u0003S\n!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u0019Ika)\u0003\u000fM+'O^5dK\u0002")
public class DependencyService
implements ReleaseTreeBuilder,
DependencyCandidateCollector,
Logging {
    private volatile DependencyService$IdAndStatus$ IdAndStatus$module;
    private final ReleaseRepository releaseRepository;
    private final ReleaseSearchService releaseSearchService;
    private final PlanItemRepository planItemRepository;
    private final DependencyRepository dependencyRepository;
    private final EventBus eventBus;
    private final TaskRepository taskRepository;
    private final PhaseRepository phaseRepository;
    private final CiIdService ciIdService;
    private final ArchivingService archivingService;
    private final scala.collection.immutable.Seq<String> activeDependencyStatuses;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public List<Dependency> findByReleaseId(String releaseId) {
        return DependencyCandidateCollector.findByReleaseId$(this, releaseId);
    }

    @Override
    @Timed
    public List<Release> findAllDependencyCandidates(String gateId) {
        return DependencyCandidateCollector.findAllDependencyCandidates$(this, gateId);
    }

    @Override
    @Timed
    public Release getDependencyCandidate(String gateId, String targetReleaseId) {
        return DependencyCandidateCollector.getDependencyCandidate$(this, gateId, targetReleaseId);
    }

    @Override
    public scala.collection.immutable.Seq<String> getReferencedCis(String gateReleaseId) {
        return DependencyCandidateCollector.getReferencedCis$(this, gateReleaseId);
    }

    @Override
    public boolean isReferencable(PlanItem planItem, scala.collection.immutable.Seq<String> referencedIds) {
        return DependencyCandidateCollector.isReferencable$(this, planItem, referencedIds);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, PlanItem item) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, item);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, TaskGroup taskGroup) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, taskGroup);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, GateTask gateTask) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, gateTask);
    }

    @Override
    public Object loadDependentRelease(Dependency dependency, String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.loadDependentRelease$(this, dependency, releaseId, dependentReleases);
    }

    @Override
    public PartialFunction<Task, ReleaseTreeItem> taskMatcher(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.taskMatcher$(this, releaseId, dependentReleases);
    }

    public DependencyService$IdAndStatus$ IdAndStatus() {
        if (this.IdAndStatus$module == null) {
            this.IdAndStatus$lzycompute$1();
        }
        return this.IdAndStatus$module;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DependencyService dependencyService = this;
        synchronized (dependencyService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseSearchService releaseSearchService() {
        return this.releaseSearchService;
    }

    public PlanItemRepository planItemRepository() {
        return this.planItemRepository;
    }

    @Override
    public DependencyRepository dependencyRepository() {
        return this.dependencyRepository;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public PhaseRepository phaseRepository() {
        return this.phaseRepository;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public scala.collection.immutable.Seq<String> activeDependencyStatuses() {
        return this.activeDependencyStatuses;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dependency create(GateTask gate, String targetIdOrVariable) {
        void var3_3;
        Checks.checkArgument((boolean)gate.isUpdatable(), (String)"You can't add a dependency to a finished gate", (Object[])new Object[0]);
        LockedTaskOperationChecks$.MODULE$.checkCreateDependency((Task)gate);
        Dependency dependency = DependencyBuilder.newDependency().withId(this.ciIdService().getUniqueId(Type.valueOf(Dependency.class), gate.getId())).build();
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
        } else {
            Object target = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTarget(target);
        }
        gate.addDependency(dependency);
        dependency.setGateTask(gate);
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().create(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyCreatedEvent(dependency));
        return var3_3;
    }

    @Timed
    public Dependency updateTarget(String dependencyId, String targetIdOrVariable) {
        String gateId = Ids.getParentId((String)dependencyId);
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        Checks.checkArgument((boolean)gate.isUpdatable(), (String)"You can't edit a dependency on a finished gate", (Object[])new Object[0]);
        LockedTaskOperationChecks$.MODULE$.checkUpdateDependency((Task)gate);
        Dependency dependency = gate.getDependencies().stream().filter(d -> {
            String string = dependencyId;
            String string2 = d.getId();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).findFirst().orElseThrow(() -> new NotFoundException(String.format("Dependency with Id '%s' not found.", dependencyId), new Object[0]));
        Dependency original = CiCloneHelper.cloneCi(dependency);
        Checks.checkArgument((!dependency.isDone() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be updated", (Object[])new Object[0]);
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(null);
        } else {
            Object newTarget = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(newTarget);
        }
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().update(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, dependency));
        return dependency;
    }

    @Timed
    public void delete(Release release, String id) {
        Option maybeDependency = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllGates()).asScala().flatMap((Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.ListHasAsScala(x$2.getDependencies()).asScala())).find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DependencyService.$anonfun$delete$2(id, x$3)));
        Dependency dependency = (Dependency)maybeDependency.getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(30).append("Repository entity [").append(id).append("] not found").toString(), new Object[0]);
        });
        GateTask gate = dependency.getGateTask();
        LockedTaskOperationChecks$.MODULE$.checkDeleteDependency((Task)gate);
        Checks.checkArgument((!dependency.isDone() || gate.isPlanned() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be deleted", (Object[])new Object[0]);
        this.dependencyRepository().delete(dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyDeletedEvent(dependency));
    }

    @Timed
    public Collection<String> getCompletableGateIds(Collection<PlanItem> targets) {
        scala.collection.immutable.Seq doneTargetIds = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(targets).asScala().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDone()))).map((Function1 & Serializable)x$5 -> x$5.getId())).toSeq();
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(37).append("getCompletableGateIds doneTargetIds: ").append(doneTargetIds.mkString(", ")).toString());
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOps)((IterableOps)this.findInProgressIncomingGateIds((scala.collection.immutable.Seq<String>)doneTargetIds).map((Function1 & Serializable)id -> {
            void var2_2;
            GateTask item = (GateTask)this.taskRepository().findById((String)id);
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(87).append("getCompletableGateIds item ").append(item.getId()).append(": hasConditions = ").append(item.hasConditions()).append(", hasDependencies = ").append(item.hasDependencies()).append(", isOpen = ").append(item.isOpen()).append(", status = ").append(item.getStatus()).toString());
            return var2_2;
        })).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isCompletable()))).map((Function1 & Serializable)x$7 -> x$7.getId())).asJava();
    }

    @Timed
    public List<String> findActiveIncomingGateIds(String releaseId) {
        Seq seq;
        if (this.releaseRepository().exists(releaseId)) {
            seq = this.doFindActiveIncomingGateIds(releaseId);
        } else {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(87).append("Release ").append(releaseId).append(" not found. It is either archived, or does not exist. Returning no dependencies").toString());
            seq = (Seq)package$.MODULE$.Seq().empty();
        }
        return CollectionConverters$.MODULE$.SeqHasAsJava(seq).asJava();
    }

    @Timed
    public scala.collection.immutable.Seq<String> findActiveIncomingGateIdsWithoutExistsCheck(String parentId) {
        return this.doFindActiveIncomingGateIds(parentId);
    }

    private scala.collection.immutable.Seq<String> doFindActiveIncomingGateIds(String parentId) {
        return (scala.collection.immutable.Seq)((SeqOps)((IterableOps)this.findAllIncomingDependencyIds((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{parentId}))), this.activeDependencyStatuses(), true).filterNot((Function1 & Serializable)dependencyId -> BoxesRunTime.boxToBoolean((boolean)this.isTemplate(dependencyId)))).map((Function1 & Serializable)x$1 -> Ids.getParentId((String)x$1))).distinct();
    }

    @Timed
    public Collection<String> getFailableGateIds(String releaseId) {
        scala.collection.immutable.Seq statuses = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{TaskStatus.IN_PROGRESS.name()}));
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.dependencyRepository().findAllIncomingDependencies((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{releaseId}))), (scala.collection.immutable.Seq<String>)statuses, true).map((Function1 & Serializable)dependency -> Ids.getParentId((String)dependency.getId()))).asJava();
    }

    @Timed
    public Collection<String> getFailableGateIds(Collection<PlanItem> abortedTargets) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.findInProgressIncomingGateIds((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)CollectionConverters$.MODULE$.CollectionHasAsScala(abortedTargets).asScala().toSeq().map((Function1 & Serializable)x$8 -> x$8.getId())))).asJava();
    }

    private scala.collection.immutable.Seq<String> findAllIncomingDependencyIds(scala.collection.immutable.Seq<String> targetIds, scala.collection.immutable.Seq<String> statuses, boolean referencingChildren) {
        return (scala.collection.immutable.Seq)this.dependencyRepository().findAllIncomingDependencies(targetIds, statuses, referencingChildren).map((Function1 & Serializable)x$9 -> x$9.getId());
    }

    private scala.collection.immutable.Seq<String> findAllIncomingDependencyIds$default$2() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    private boolean findAllIncomingDependencyIds$default$3() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public List<String> findActiveOutgoingTargetIds(String releaseId) {
        void var2_2;
        List targetIds = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.findActiveOutgoingTargets(releaseId).map((Function1 & Serializable)x$10 -> x$10.getId())).asJava();
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    private scala.collection.immutable.Seq<PlanItem> findActiveOutgoingTargets(String releaseId) {
        void var3_3;
        List<Dependency> dependencies = this.findByReleaseId(releaseId);
        scala.collection.immutable.Seq targets = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(dependencies).asScala().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Dependency, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x1;
                Object object = A12 != null && (A1 = A12).hasResolvedTarget() && !A1.isDone() ? A1.getTarget() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Dependency x1) {
                Dependency dependency;
                Dependency dependency2 = x1;
                boolean bl = dependency2 != null && (dependency = dependency2).hasResolvedTarget() && !dependency.isDone();
                return bl;
            }
        })).toSeq();
        return var3_3;
    }

    @Timed
    public ReleaseTree getReleaseTree(String releaseId) {
        ReleaseTree releaseTree;
        if (this.archivingService().exists(releaseId)) {
            releaseTree = new ReleaseTree();
        } else {
            scala.collection.mutable.Map dependentReleases = (scala.collection.mutable.Map)Map$.MODULE$.empty();
            Release release = this.releaseRepository().findById(releaseId);
            this.toTreeItem(releaseId, (scala.collection.mutable.Map<String, ReleaseTreeItem>)dependentReleases, (PlanItem)release);
            ReleaseTree tree = new ReleaseTree();
            tree.releaseId_$eq(releaseId);
            tree.dependentReleases_$eq(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)dependentReleases.values().toList()).asJava());
            releaseTree = tree;
        }
        return releaseTree;
    }

    @Timed
    public void updateGateReferencingPhases(String gateId, Map<PlanItem, PlanItem> originToRestored) {
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        Release release = gate.getRelease();
        gate.getDependencies().forEach(dependency -> {
            block0: {
                PlanItem target = dependency.getTarget();
                if (!originToRestored.containsKey(target)) break block0;
                Dependency original = CiCloneHelper.cloneCi(dependency);
                dependency.setTarget((PlanItem)originToRestored.get(target));
                Dependency updatedDependency = this.dependencyRepository().update(release, (Dependency)dependency);
                this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, updatedDependency));
            }
        });
    }

    @Timed
    public void archiveDependencies(String releaseId, scala.collection.immutable.Seq<String> dependencyIds) {
        Release referencingRelease = this.releaseRepository().findById(releaseId);
        Buffer dependenciesToArchive = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(referencingRelease.getAllGates()).asScala().flatMap((Function1 & Serializable)x$11 -> CollectionConverters$.MODULE$.ListHasAsScala(x$11.getDependencies()).asScala())).filter((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)dependencyIds.contains((Object)d.getId())));
        dependenciesToArchive.foreach((Function1 & Serializable)x$12 -> {
            x$12.archive();
            return BoxedUnit.UNIT;
        });
        this.dependencyRepository().archive(referencingRelease, (scala.collection.immutable.Seq<Dependency>)dependenciesToArchive.toSeq());
    }

    @Timed
    public IdAndStatus findDependencyTargetByTargetId(String targetId) {
        return new IdAndStatus(this, targetId, this.getStatus(targetId));
    }

    private String getStatus(String targetId) {
        Option option;
        Option option2;
        String string;
        Option option3;
        String string2 = targetId;
        if (string2 != null && !(option3 = IdMatchers.ReleaseId$.MODULE$.unapply(string2)).isEmpty()) {
            string = this.releaseRepository().getStatus(targetId).toString();
        } else if (string2 != null && !(option2 = IdMatchers.PhaseId$.MODULE$.unapply(string2)).isEmpty()) {
            string = this.phaseRepository().getStatus(targetId).toString();
        } else if (string2 != null && !(option = IdMatchers.TaskId$.MODULE$.unapply(string2)).isEmpty()) {
            string = this.taskRepository().getStatus(targetId).toString();
        } else {
            throw new NotFoundException(new StringBuilder(35).append("Target is not plan item, targetId= ").append(targetId).toString(), new Object[0]);
        }
        return string;
    }

    public scala.collection.immutable.Seq<String> findInProgressIncomingGateIds(scala.collection.immutable.Seq<String> targetIds) {
        return (scala.collection.immutable.Seq)((SeqOps)this.findAllIncomingDependencyIds(targetIds, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{TaskStatus.IN_PROGRESS.name()}))), this.findAllIncomingDependencyIds$default$3()).map((Function1 & Serializable)x$1 -> Ids.getParentId((String)x$1))).distinct();
    }

    public boolean isTemplate(String dependencyId) {
        return this.releaseRepository().isTemplate(Ids.releaseIdFrom((String)dependencyId));
    }

    private final void IdAndStatus$lzycompute$1() {
        DependencyService dependencyService = this;
        synchronized (dependencyService) {
            if (this.IdAndStatus$module == null) {
                this.IdAndStatus$module = new DependencyService$IdAndStatus$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$delete$2(String id$1, Dependency x$3) {
        String string = x$3.getId();
        String string2 = Ids.normalizeId((String)id$1);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public DependencyService(ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, PlanItemRepository planItemRepository, DependencyRepository dependencyRepository, EventBus eventBus, TaskRepository taskRepository, PhaseRepository phaseRepository, CiIdService ciIdService, ArchivingService archivingService) {
        this.releaseRepository = releaseRepository;
        this.releaseSearchService = releaseSearchService;
        this.planItemRepository = planItemRepository;
        this.dependencyRepository = dependencyRepository;
        this.eventBus = eventBus;
        this.taskRepository = taskRepository;
        this.phaseRepository = phaseRepository;
        this.ciIdService = ciIdService;
        this.archivingService = archivingService;
        ReleaseTreeBuilder.$init$(this);
        DependencyCandidateCollector.$init$(this);
        Logging.$init$((Logging)this);
        this.activeDependencyStatuses = (scala.collection.immutable.Seq)((IterableOps)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])TaskStatus.ACTIVE_STATUSES)).$colon$plus((Object)TaskStatus.PLANNED)).map((Function1 & Serializable)x$1 -> x$1.name());
    }

    public class IdAndStatus
    implements Product,
    Serializable {
        private final String id;
        private final String status;
        public final /* synthetic */ DependencyService $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String id() {
            return this.id;
        }

        public String status() {
            return this.status;
        }

        public IdAndStatus copy(String id, String status) {
            return new IdAndStatus(this.com$xebialabs$xlrelease$service$DependencyService$IdAndStatus$$$outer(), id, status);
        }

        public String copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.status();
        }

        public String productPrefix() {
            return "IdAndStatus";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.id();
                    break;
                }
                case 1: {
                    object = this.status();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof IdAndStatus;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "id";
                    break;
                }
                case 1: {
                    string = "status";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof IdAndStatus)) return false;
            if (((IdAndStatus)object).com$xebialabs$xlrelease$service$DependencyService$IdAndStatus$$$outer() != this.com$xebialabs$xlrelease$service$DependencyService$IdAndStatus$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            IdAndStatus idAndStatus = (IdAndStatus)x$1;
            String string = this.id();
            String string2 = idAndStatus.id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.status();
            String string4 = idAndStatus.status();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!idAndStatus.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ DependencyService com$xebialabs$xlrelease$service$DependencyService$IdAndStatus$$$outer() {
            return this.$outer;
        }

        public IdAndStatus(DependencyService $outer, String id, String status) {
            this.id = id;
            this.status = status;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

