import React, { useState } from 'react';
import PropTypes from 'prop-types';
import ReactMarkdown from 'react-markdown';
import { DocLinkComponent } from '../doc-link/doc-link.component';

import './textarea-markdown.component.less';

export const TextAreaMarkdown = ({ rows, text, onTextChange, isReadOnly = false }) => {
    const [editing, setEditing] = useState(false);
    const [originalText, setOriginalText] = useState(text);
    const [currentText, setCurrentText] = useState(text);

    const saveChanges = () => {
        onTextChange(currentText);
        setOriginalText(currentText);
        setEditing(false);
    };

    const revertChanges = () => {
        setCurrentText(originalText);
        setEditing(false);
    };

    const renderTextEditor = () => (
        <div>
            <textarea onChange={(e) => setCurrentText(e.target.value)} rows={rows} value={currentText} />
            <div className="actions-wrapper">
                <div className="ok" onClick={saveChanges}>
                    <i className="xl-icon check-icon" />
                    Save
                </div>
                <div className="cancel" onClick={revertChanges}>
                    <i className="xl-icon close-icon" />
                    Cancel
                </div>
                <DocLinkComponent section="markdownsyntax.html" />
            </div>
        </div>
    );

    const renderMarkDownPreview = () => (
        <div className="markdown-viewer">
            {!isReadOnly ? <i className="xl-icon edit-icon" onClick={() => setEditing(true)} /> : null}
            <ReactMarkdown className="markdown-wrapper">{currentText}</ReactMarkdown>
        </div>
    );

    return <div className="markdown-switcher">{editing ? renderTextEditor() : renderMarkDownPreview()}</div>;
};

TextAreaMarkdown.propTypes = {
    isReadOnly: PropTypes.bool,
    onTextChange: PropTypes.func.isRequired,
    rows: PropTypes.number.isRequired,
    text: PropTypes.string,
};
