from xlrxldeploy import display_step_logs, restart_task
from xlrxldeploy import print_step_errors
from xlrxldeploy import create_record
import sys

retryCounter = {
    "currentContinueRetrial": 0,
    "currentPollingTrial": 0
}

def process_retry_task_state(task_state, task, retry_counter_ref, failOnPause=True, rollbackOnFailure=False,
                             cancelOnError=False, taskReportingApi=None):
    xlDeployTaskId = task.getPythonScript().getProperty("xlDeployTaskId")
    if retry_counter_ref == {} :
        retry_counter_ref = retryCounter
    if taskReportingApi:
        if task_state in ["EXECUTED", "DONE"]:
            create_record(task, taskReportingApi, "completed", xlDeployTaskId)
        elif task_state in ["FAILED", "STOPPED"]:
            create_record(task, taskReportingApi, "failed", xlDeployTaskId)
        elif task_state in ["ABORTED", "CANCELLED"]:
            create_record(task, taskReportingApi, "aborted", xlDeployTaskId)

    if task_state in ["EXECUTED", "DONE"]:
        complete_task(task, task_state, xlDeployTaskId)
    else:
        retry_counter_ref['currentPollingTrial'] = int(retry_counter_ref['currentPollingTrial']) + 1

    if task_state in ["FAILED", "ABORTED", "STOPPED", "CANCELLED"]:
        print "Failed XL Deploy Task: '%s' State: '%s'\n" % (xlDeployTaskId, task_state)
        display_step_logs(task) if bool(task.getPythonScript().getProperty("displayStepLogs")) else print_step_errors(task)

        if is_task_failed(task_state, failOnPause) and is_retry_available(task, retry_counter_ref):
            retry_task(retry_counter_ref, task)
        elif task_state in ["STOPPED", "CANCELLED", "FAILED", "ABORTED"]:
            if rollbackOnFailure:
                print "Starting rollback on failure.\n"
                task.schedule("xlrxldeploy/DeployRollback.py", 2)
            elif cancelOnError:
                print "Task failed; cancelling task. \n"
                task.schedule("xlrxldeploy/DeployCancel.py")
            else:
                sys.exit(1)

    numberOfPollingTrials = task.getPythonScript().getProperty("numberOfPollingTrials")
    if bool(numberOfPollingTrials) and int(retry_counter_ref['currentPollingTrial']) >= numberOfPollingTrials:
        print_display_logs(task)
        task.schedule(None)


def retry_task(retry_counter_ref, task):
    retry_counter_ref['currentContinueRetrial'] = int(retry_counter_ref['currentContinueRetrial']) + 1
    retry_counter_ref['currentPollingTrial'] = 0
    restart_task(task)


def complete_task(task, task_state, xlDeployTaskId):
    task.setStatusLine('Executed')
    print "Completed XL Deploy Task: '%s' State: '%s'\n" % (xlDeployTaskId, task_state)
    print_display_logs(task)
    task.schedule(None)  # as the schedule is set in check_status


def print_display_logs(task):
    displayStepLogs = task.getPythonScript().getProperty("displayStepLogs")
    if displayStepLogs:
        display_step_logs(task)

def is_task_failed(task_state, fail_on_pause):
    return bool(task_state in ["FAILED", "ABORTED"] or (task_state == "STOPPED" and bool(fail_on_pause)))

def is_retry_available(task, retry_counter_ref):
    continueIfStepFails = task.getPythonScript().getProperty("continueIfStepFails")
    numberOfContinueRetrials = task.getPythonScript().getProperty("numberOfContinueRetrials")
    return bool(bool(continueIfStepFails) and int(retry_counter_ref['currentContinueRetrial']) < numberOfContinueRetrials)
