/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.akka.extension.quartz;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.event.EventStream;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import com.typesafe.akka.extension.quartz.QuartzCalendars$;
import com.typesafe.akka.extension.quartz.QuartzCronSchedule;
import com.typesafe.akka.extension.quartz.QuartzSchedule;
import com.typesafe.akka.extension.quartz.QuartzSchedulerExtension$;
import com.typesafe.akka.extension.quartz.QuartzSchedules$;
import com.typesafe.akka.extension.quartz.SimpleActorMessageJob;
import com.typesafe.akka.extension.quartz.package$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import org.quartz.Calendar;
import org.quartz.CronExpression;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.core.jmx.JobDataMapSupport;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0005\r-q!\u0002#F\u0011\u0003\u0001f!\u0002*F\u0011\u0003\u0019\u0006B\u00026\u0002\t\u0003\u0011\u0019\u0010C\u0004\u0003v\u0006!\tEa>\t\u000f\te\u0018\u0001\"\u0011\u0003|\"91QA\u0001\u0005B\r\u001da\u0001\u0002*F\u0001\tD\u0001B\u001a\u0004\u0003\u0002\u0003\u0006Ia\u001a\u0005\u0006U\u001a!\ta\u001b\u0005\b[\u001a\u0011\r\u0011\"\u0003o\u0011\u0019)h\u0001)A\u0005_\")aO\u0002C\u0001o\"9\u0011q\u0001\u0004\u0005\u0012\u0005%\u0001\"CA\u000b\r\t\u0007I\u0011AA\f\u0011!\tyB\u0002Q\u0001\n\u0005e\u0001\"CA\u0011\r\t\u0007I\u0011AA\f\u0011!\t\u0019C\u0002Q\u0001\n\u0005e\u0001\"CA\u0013\r\t\u0007I\u0011AA\u0014\u0011!\tyC\u0002Q\u0001\n\u0005%\u0002\"CA\u0019\r\t\u0007I\u0011AA\u001a\u0011!\t)E\u0002Q\u0001\n\u0005U\u0002\"CA$\r\t\u0007I\u0011AA%\u0011!\t\tG\u0002Q\u0001\n\u0005-\u0003\"CA2\r\t\u0007I\u0011AA3\u0011!\t9H\u0002Q\u0001\n\u0005\u001d\u0004bBA=\r\u0011\u0005\u00111\u0010\u0005\b\u0003\u00073A\u0011AA\u0014\u0011\u001d\t)I\u0002C\u0001\u0003\u000fCq!!#\u0007\t\u0003\t9\u0003C\u0004\u0002\f\u001a!\t!!$\t\u000f\u0005}e\u0001\"\u0001\u0002|!9\u0011\u0011\u0015\u0004\u0005\u0002\u0005\r\u0006\"CAU\rE\u0005I\u0011AAV\u0011\u001d\t\tM\u0002C\u0001\u0003\u0007Dq!a2\u0007\t\u0003\tI\rC\u0004\u0002N\u001a!\t!a\u001f\t\u000f\u0005=g\u0001\"\u0001\u0002R\"9\u0011Q\u001b\u0004\u0005\u0002\u0005]\u0007\"CA~\rE\u0005I\u0011AA\u007f\u0011%\u0011\tABI\u0001\n\u0003\ti\u0010C\u0005\u0003\u0004\u0019\t\n\u0011\"\u0001\u0003\u0006!9!\u0011\u0002\u0004\u0005\u0002\t-\u0001\"\u0003B\u000e\rE\u0005I\u0011AA\u007f\u0011%\u0011iBBI\u0001\n\u0003\ti\u0010C\u0005\u0003 \u0019\t\n\u0011\"\u0001\u0003\u0006!9!\u0011\u0005\u0004\u0005\u0002\t\r\u0002b\u0002B\u0014\r\u0011\u0005!\u0011\u0006\u0005\b\u0005[1A\u0011\u0001B\u0018\u0011%\u0011YDBI\u0001\n\u0003\ti\u0010C\u0005\u0003>\u0019\t\n\u0011\"\u0001\u0002~\"I!q\b\u0004\u0012\u0002\u0013\u0005!Q\u0001\u0005\b\u0005\u00032A\u0011\u0001B\"\u0011%\u0011\u0019FBI\u0001\n\u0003\ti\u0010C\u0005\u0003V\u0019\t\n\u0011\"\u0001\u0002~\"I!q\u000b\u0004\u0012\u0002\u0013\u0005!Q\u0001\u0005\t\u000532A\u0011A#\u0003\\!9!q\f\u0004\u0005\u0002\t\u0005\u0004b\u0002B0\r\u0011\u0005!\u0011\u000e\u0005\b\u0005?2A\u0011\u0001B<\u0011\u001d\u0011yF\u0002C\u0001\u0005\u000bCqAa\u0018\u0007\t\u0003\u0011\t\nC\u0004\u0003`\u0019!\tAa'\t\u0011\t\u0015f\u0001\"\u0001F\u0005OC\u0001B!-\u0007\t\u0003)%1\u0017\u0005\b\u0005\u00034A\u0011CA>\u0011)\u0011\u0019M\u0002EC\u0002\u0013E!Q\u0019\u0005\u000b\u0005'4\u0001R1A\u0005\u0012\tU\u0007B\u0003Br\r!\u0015\r\u0011\"\u0005\u0003f\u0006A\u0012+^1sij\u001c6\r[3ek2,'/\u0012=uK:\u001c\u0018n\u001c8\u000b\u0005\u0019;\u0015AB9vCJ$(P\u0003\u0002I\u0013\u0006IQ\r\u001f;f]NLwN\u001c\u0006\u0003\u0015.\u000bA!Y6lC*\u0011A*T\u0001\tif\u0004Xm]1gK*\ta*A\u0002d_6\u001c\u0001\u0001\u0005\u0002R\u00035\tQI\u0001\rRk\u0006\u0014HO_*dQ\u0016$W\u000f\\3s\u000bb$XM\\:j_:\u001cR!\u0001+[\u0005[\u0004\"!\u0016-\u000e\u0003YS\u0011aV\u0001\u0006g\u000e\fG.Y\u0005\u00033Z\u0013a!\u00118z%\u00164\u0007cA.`C6\tAL\u0003\u0002^=\u0006)\u0011m\u0019;pe*\t!*\u0003\u0002a9\nYQ\t\u001f;f]NLwN\\%e!\t\tfaE\u0002\u0007)\u000e\u0004\"a\u00173\n\u0005\u0015d&!C#yi\u0016t7/[8o\u0003\u0019\u0019\u0018p\u001d;f[B\u00111\f[\u0005\u0003Sr\u00131\"Q2u_J\u001c\u0016p\u001d;f[\u00061A(\u001b8jiz\"\"!\u00197\t\u000b\u0019D\u0001\u0019A4\u0002\u00071|w-F\u0001p!\t\u00018/D\u0001r\u0015\t\u0011h,A\u0003fm\u0016tG/\u0003\u0002uc\nqAj\\4hS:<\u0017\tZ1qi\u0016\u0014\u0018\u0001\u00027pO\u0002\nQb]2iK\u0012,H.\u001a:OC6,W#\u0001=\u0011\u0007e\f\tA\u0004\u0002{}B\u00111PV\u0007\u0002y*\u0011QpT\u0001\u0007yI|w\u000e\u001e \n\u0005}4\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0004\u0005\u0015!AB*ue&twM\u0003\u0002\u0000-\u000611m\u001c8gS\u001e,\"!a\u0003\u0011\t\u00055\u0011\u0011C\u0007\u0003\u0003\u001fQ1!a\u0002L\u0013\u0011\t\u0019\"a\u0004\u0003\r\r{gNZ5h\u0003-!\bN]3bI\u000e{WO\u001c;\u0016\u0005\u0005e\u0001cA+\u0002\u001c%\u0019\u0011Q\u0004,\u0003\u0007%sG/\u0001\u0007uQJ,\u0017\rZ\"pk:$\b%\u0001\buQJ,\u0017\r\u001a)sS>\u0014\u0018\u000e^=\u0002\u001fQD'/Z1e!JLwN]5us\u0002\nA\u0003Z1f[>tG\u000b\u001b:fC\u0012\u001cx\fJ9nCJ\\WCAA\u0015!\r)\u00161F\u0005\u0004\u0003[1&a\u0002\"p_2,\u0017M\\\u0001\u0016I\u0006,Wn\u001c8UQJ,\u0017\rZ:`IEl\u0017M]6!\u0003=!WMZ1vYR$\u0016.\\3{_:,WCAA\u001b!\u0011\t9$!\u0011\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\tA!\u001e;jY*\u0011\u0011qH\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002D\u0005e\"\u0001\u0003+j[\u0016TvN\\3\u0002!\u0011,g-Y;miRKW.\u001a>p]\u0016\u0004\u0013!C:dQ\u0016$W\u000f\\3t+\t\tY\u0005E\u0004\u0002N\u0005]\u00030a\u0017\u000e\u0005\u0005=#\u0002BA)\u0003'\n!bY8oGV\u0014(/\u001a8u\u0015\r\t)FV\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA-\u0003\u001f\u0012q\u0001\u0016:jK6\u000b\u0007\u000fE\u0002R\u0003;J1!a\u0018F\u00059\tV/\u0019:uuN\u001b\u0007.\u001a3vY\u0016\f!b]2iK\u0012,H.Z:!\u0003-\u0011XO\u001c8j]\u001eTuNY:\u0016\u0005\u0005\u001d\u0004cBA'\u0003/B\u0018\u0011\u000e\t\u0005\u0003W\n\u0019(\u0004\u0002\u0002n)\u0019a)a\u001c\u000b\u0005\u0005E\u0014aA8sO&!\u0011QOA7\u0005\u0019QuNY&fs\u0006a!/\u001e8oS:<'j\u001c2tA\u000591\u000f^1oI\nLHCAA?!\r)\u0016qP\u0005\u0004\u0003\u00033&\u0001B+oSR\fq\"[:J]N#\u0018M\u001c3cs6{G-Z\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003S\t\u0011\"[:Ti\u0006\u0014H/\u001a3\u0002\u00179,\u0007\u0010\u001e+sS\u001e<WM\u001d\u000b\u0005\u0003\u001f\u000bY\nE\u0003V\u0003#\u000b)*C\u0002\u0002\u0014Z\u0013aa\u00149uS>t\u0007\u0003BA\u001c\u0003/KA!!'\u0002:\t!A)\u0019;f\u0011\u0019\ti*\ba\u0001q\u0006!a.Y7f\u0003)\u0019Xo\u001d9f]\u0012\fE\u000e\\\u0001\tg\",H\u000fZ8x]R!\u0011QPAS\u0011%\t9k\bI\u0001\u0002\u0004\tI#A\u000bxC&$hi\u001c:K_\n\u001cHk\\\"p[BdW\r^3\u0002%MDW\u000f\u001e3po:$C-\u001a4bk2$H%M\u000b\u0003\u0003[SC!!\u000b\u00020.\u0012\u0011\u0011\u0017\t\u0005\u0003g\u000bi,\u0004\u0002\u00026*!\u0011qWA]\u0003%)hn\u00195fG.,GMC\u0002\u0002<Z\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ty,!.\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0006tkN\u0004XM\u001c3K_\n$B!!\u000b\u0002F\"1\u0011QT\u0011A\u0002a\f\u0011B]3tk6,'j\u001c2\u0015\t\u0005%\u00121\u001a\u0005\u0007\u0003;\u0013\u0003\u0019\u0001=\u0002\u0013I,7/^7f\u00032d\u0017!C2b]\u000e,GNS8c)\u0011\tI#a5\t\r\u0005uE\u00051\u0001y\u0003E\u0019'/Z1uK*{'mU2iK\u0012,H.\u001a\u000b\u0011\u0003+\u000bI.a7\u0002f\u0006%\u0018q^Az\u0003oDa!!(&\u0001\u0004A\bbBAoK\u0001\u0007\u0011q\\\u0001\te\u0016\u001cW-\u001b<feB\u00191,!9\n\u0007\u0005\rHL\u0001\u0005BGR|'OU3g\u0011\u0019\t9/\na\u0001)\u0006\u0019Qn]4\t\u0013\u0005-X\u0005%AA\u0002\u00055\u0018a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004B!VAIq\"1\u0011\u0011_\u0013A\u0002a\fab\u0019:p]\u0016C\bO]3tg&|g\u000eC\u0005\u0002v\u0016\u0002\n\u00111\u0001\u0002n\u0006A1-\u00197f]\u0012\f'\u000fC\u0005\u0002z\u0016\u0002\n\u00111\u0001\u00026\u0005AA/[7fu>tW-A\u000ede\u0016\fG/\u001a&pEN\u001b\u0007.\u001a3vY\u0016$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u007fTC!!<\u00020\u0006Y2M]3bi\u0016TuNY*dQ\u0016$W\u000f\\3%I\u00164\u0017-\u001e7uIY\n1d\u0019:fCR,'j\u001c2TG\",G-\u001e7fI\u0011,g-Y;mi\u0012:TC\u0001B\u0004U\u0011\t)$a,\u0002#U\u0004H-\u0019;f\u0015>\u00147k\u00195fIVdW\r\u0006\t\u0002\u0016\n5!q\u0002B\t\u0005'\u0011)Ba\u0006\u0003\u001a!1\u0011QT\u0015A\u0002aDq!!8*\u0001\u0004\ty\u000e\u0003\u0004\u0002h&\u0002\r\u0001\u0016\u0005\n\u0003WL\u0003\u0013!a\u0001\u0003[Da!!=*\u0001\u0004A\b\"CA{SA\u0005\t\u0019AAw\u0011%\tI0\u000bI\u0001\u0002\u0004\t)$A\u000eva\u0012\fG/\u001a&pEN\u001b\u0007.\u001a3vY\u0016$C-\u001a4bk2$H\u0005N\u0001\u001ckB$\u0017\r^3K_\n\u001c6\r[3ek2,G\u0005Z3gCVdG\u000f\n\u001c\u00027U\u0004H-\u0019;f\u0015>\u00147k\u00195fIVdW\r\n3fM\u0006,H\u000e\u001e\u00138\u0003E!W\r\\3uK*{'mU2iK\u0012,H.\u001a\u000b\u0005\u0003S\u0011)\u0003\u0003\u0004\u0002\u001e6\u0002\r\u0001_\u0001\u000ek:\u001c8\r[3ek2,'j\u001c2\u0015\t\u0005%\"1\u0006\u0005\u0007\u0003;s\u0003\u0019\u0001=\u0002\u001d\r\u0014X-\u0019;f'\u000eDW\rZ;mKRa\u0011Q\u0010B\u0019\u0005g\u0011)Da\u000e\u0003:!1\u0011QT\u0018A\u0002aD\u0011\"a;0!\u0003\u0005\r!!<\t\r\u0005Ex\u00061\u0001y\u0011%\t)p\fI\u0001\u0002\u0004\ti\u000fC\u0005\u0002z>\u0002\n\u00111\u0001\u00026\u0005A2M]3bi\u0016\u001c6\r[3ek2,G\u0005Z3gCVdG\u000f\n\u001a\u00021\r\u0014X-\u0019;f'\u000eDW\rZ;mK\u0012\"WMZ1vYR$C'\u0001\rde\u0016\fG/Z*dQ\u0016$W\u000f\\3%I\u00164\u0017-\u001e7uIU\nQB]3tG\",G-\u001e7f\u0015>\u0014G\u0003EAK\u0005\u000b\u00129E!\u0013\u0003L\t5#q\nB)\u0011\u0019\tij\ra\u0001q\"9\u0011Q\\\u001aA\u0002\u0005}\u0007BBAtg\u0001\u0007A\u000bC\u0005\u0002lN\u0002\n\u00111\u0001\u0002n\"1\u0011\u0011_\u001aA\u0002aD\u0011\"!>4!\u0003\u0005\r!!<\t\u0013\u0005e8\u0007%AA\u0002\u0005U\u0012a\u0006:fg\u000eDW\rZ;mK*{'\r\n3fM\u0006,H\u000e\u001e\u00135\u0003]\u0011Xm]2iK\u0012,H.\u001a&pE\u0012\"WMZ1vYR$c'A\fsKN\u001c\u0007.\u001a3vY\u0016TuN\u0019\u0013eK\u001a\fW\u000f\u001c;%o\u0005q!/Z7pm\u0016\u001c6\r[3ek2,G\u0003BA&\u0005;Ba!!(8\u0001\u0004A\u0018\u0001C:dQ\u0016$W\u000f\\3\u0015\u0011\u0005U%1\rB3\u0005OBa!!(9\u0001\u0004A\bbBAoq\u0001\u0007\u0011q\u001c\u0005\u0007\u0003OD\u0004\u0019\u0001+\u0015\u0011\u0005U%1\u000eB7\u0005kBa!!(:\u0001\u0004A\bbBAos\u0001\u0007!q\u000e\t\u00047\nE\u0014b\u0001B:9\nq\u0011i\u0019;peN+G.Z2uS>t\u0007BBAts\u0001\u0007A\u000b\u0006\u0005\u0002\u0016\ne$1\u0010BB\u0011\u0019\tiJ\u000fa\u0001q\"9\u0011Q\u001c\u001eA\u0002\tu\u0004c\u00019\u0003\u0000%\u0019!\u0011Q9\u0003\u0017\u00153XM\u001c;TiJ,\u0017-\u001c\u0005\u0007\u0003OT\u0004\u0019\u0001+\u0015\u0015\u0005U%q\u0011BE\u0005\u0017\u0013i\t\u0003\u0004\u0002\u001en\u0002\r\u0001\u001f\u0005\b\u0003;\\\u0004\u0019AAp\u0011\u0019\t9o\u000fa\u0001)\"9!qR\u001eA\u0002\u0005=\u0015!C:uCJ$H)\u0019;f))\t)Ja%\u0003\u0016\n]%\u0011\u0014\u0005\u0007\u0003;c\u0004\u0019\u0001=\t\u000f\u0005uG\b1\u0001\u0003p!1\u0011q\u001d\u001fA\u0002QCqAa$=\u0001\u0004\ty\t\u0006\u0006\u0002\u0016\nu%q\u0014BQ\u0005GCa!!(>\u0001\u0004A\bbBAo{\u0001\u0007!Q\u0010\u0005\u0007\u0003Ol\u0004\u0019\u0001+\t\u000f\t=U\b1\u0001\u0002\u0010\u0006\u00012o\u00195fIVdW-\u00138uKJt\u0017\r\u001c\u000b\u000b\u0003+\u0013IKa+\u0003.\n=\u0006BBAO}\u0001\u0007\u0001\u0010\u0003\u0004\u0002^z\u0002\r\u0001\u0016\u0005\u0007\u0003Ot\u0004\u0019\u0001+\t\u000f\t=e\b1\u0001\u0002\u0010\u0006Y1o\u00195fIVdWMS8c))\u0011)L!/\u0003<\nu&q\u0018\u000b\u0005\u0003+\u00139\fC\u0004\u0003`}\u0002\r!a\u0017\t\r\u0005uu\b1\u0001y\u0011\u0019\tin\u0010a\u0001)\"1\u0011q] A\u0002QCqAa$@\u0001\u0004\ty)A\nj]&$\u0018.\u00197jg\u0016\u001c\u0015\r\\3oI\u0006\u00148/\u0001\u0006uQJ,\u0017\r\u001a)p_2,\"Aa2\u0011\t\t%'qZ\u0007\u0003\u0005\u0017TAA!4\u0002n\u0005)1/[7qY&!!\u0011\u001bBf\u0005A\u0019\u0016.\u001c9mKRC'/Z1e!>|G.\u0001\u0005k_\n\u001cFo\u001c:f+\t\u00119\u000e\u0005\u0003\u0003Z\n}WB\u0001Bn\u0015\u0011\u0011i.!\u001c\u0002\u0007M\u0004\u0018.\u0003\u0003\u0003b\nm'\u0001\u0003&pEN#xN]3\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014XC\u0001Bt!\u0011\tYG!;\n\t\t-\u0018Q\u000e\u0002\n'\u000eDW\rZ;mKJ\u00042a\u0017Bx\u0013\r\u0011\t\u0010\u0018\u0002\u0014\u000bb$XM\\:j_:LE\r\u0015:pm&$WM\u001d\u000b\u0002!\u00061An\\8lkB,\u0012\u0001U\u0001\u0010GJ,\u0017\r^3FqR,gn]5p]R\u0019\u0011M!@\t\r\u0019$\u0001\u0019\u0001B\u0000!\rY6\u0011A\u0005\u0004\u0007\u0007a&aE#yi\u0016tG-\u001a3BGR|'oU=ti\u0016l\u0017aA4fiR\u0019\u0011m!\u0003\t\u000b\u0019,\u0001\u0019A4")
public class QuartzSchedulerExtension
implements Extension {
    private SimpleThreadPool threadPool;
    private JobStore jobStore;
    private Scheduler scheduler;
    private final ActorSystem system;
    private final LoggingAdapter log;
    private final int threadCount;
    private final int threadPriority;
    private final boolean daemonThreads_$qmark;
    private final TimeZone defaultTimezone;
    private final TrieMap<String, QuartzSchedule> schedules;
    private final TrieMap<String, JobKey> runningJobs;
    private volatile byte bitmap$0;

    public static QuartzSchedulerExtension get(ActorSystem actorSystem) {
        return QuartzSchedulerExtension$.MODULE$.get(actorSystem);
    }

    public static QuartzSchedulerExtension createExtension(ExtendedActorSystem extendedActorSystem) {
        return QuartzSchedulerExtension$.MODULE$.createExtension(extendedActorSystem);
    }

    public static QuartzSchedulerExtension$ lookup() {
        return QuartzSchedulerExtension$.MODULE$.lookup();
    }

    public static Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return QuartzSchedulerExtension$.MODULE$.get(classicActorSystemProvider);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return QuartzSchedulerExtension$.MODULE$.apply(classicActorSystemProvider);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return QuartzSchedulerExtension$.MODULE$.apply(actorSystem);
    }

    private LoggingAdapter log() {
        return this.log;
    }

    public String schedulerName() {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("QuartzScheduler~%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.system.name()}));
    }

    public Config config() {
        return this.system.settings().config().getConfig("akka.quartz").root().toConfig();
    }

    public int threadCount() {
        return this.threadCount;
    }

    public int threadPriority() {
        return this.threadPriority;
    }

    public boolean daemonThreads_$qmark() {
        return this.daemonThreads_$qmark;
    }

    public TimeZone defaultTimezone() {
        return this.defaultTimezone;
    }

    public TrieMap<String, QuartzSchedule> schedules() {
        return this.schedules;
    }

    public TrieMap<String, JobKey> runningJobs() {
        return this.runningJobs;
    }

    public void standby() {
        this.scheduler().standby();
    }

    public boolean isInStandbyMode() {
        return this.scheduler().isInStandbyMode();
    }

    public boolean start() {
        boolean bl;
        boolean bl2 = this.isStarted();
        if (bl2) {
            this.log().warning("Cannot start scheduler, already started.");
            bl = false;
        } else if (!bl2) {
            this.scheduler().start();
            bl = true;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl2));
        }
        return bl;
    }

    public boolean isStarted() {
        return this.scheduler().isStarted();
    }

    public Option<Date> nextTrigger(String name) {
        return this.runningJobs().get((Object)name).flatMap((Function1 & Serializable)jobKey -> ((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.scheduler().getTriggersOfJob(jobKey)).asScala()).headOption().map((Function1 & Serializable)trigger -> trigger.getNextFireTime()));
    }

    public void suspendAll() {
        this.log().info("Suspending all Quartz jobs.");
        this.scheduler().pauseAll();
    }

    public void shutdown(boolean waitForJobsToComplete) {
        this.scheduler().shutdown(waitForJobsToComplete);
    }

    public boolean shutdown$default$1() {
        return false;
    }

    public boolean suspendJob(String name) {
        boolean bl;
        Option option = this.runningJobs().get((Object)name);
        if (option instanceof Some) {
            Some some = (Some)option;
            JobKey job = (JobKey)some.value();
            this.log().info("Suspending Quartz Job '{}'", (Object)name);
            this.scheduler().pauseJob(job);
            bl = true;
        } else if (None$.MODULE$.equals(option)) {
            this.log().warning("No running Job named '{}' found: Cannot suspend", (Object)name);
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public boolean resumeJob(String name) {
        boolean bl;
        Option option = this.runningJobs().get((Object)name);
        if (option instanceof Some) {
            Some some = (Some)option;
            JobKey job = (JobKey)some.value();
            this.log().info("Resuming Quartz Job '{}'", (Object)name);
            this.scheduler().resumeJob(job);
            bl = true;
        } else if (None$.MODULE$.equals(option)) {
            this.log().warning("No running Job named '{}' found: Cannot unpause", (Object)name);
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public void resumeAll() {
        this.log().info("Resuming all Quartz jobs.");
        this.scheduler().resumeAll();
    }

    public boolean cancelJob(String name) {
        boolean bl;
        Option option = this.runningJobs().get((Object)name);
        if (option instanceof Some) {
            Some some = (Some)option;
            JobKey job = (JobKey)some.value();
            this.log().info("Cancelling Quartz Job '{}'", (Object)name);
            boolean result = this.scheduler().deleteJob(job);
            this.runningJobs().$minus$eq((Object)name);
            bl = result;
        } else if (None$.MODULE$.equals(option)) {
            this.log().warning("No running Job named '{}' found: Cannot cancel", (Object)name);
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public Date createJobSchedule(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        this.createSchedule(name, description, cronExpression, calendar, timezone);
        return this.schedule(name, receiver, msg);
    }

    public Option<String> createJobSchedule$default$4() {
        return None$.MODULE$;
    }

    public Option<String> createJobSchedule$default$6() {
        return None$.MODULE$;
    }

    public TimeZone createJobSchedule$default$7() {
        return this.defaultTimezone();
    }

    public Date updateJobSchedule(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        return this.rescheduleJob(name, receiver, msg, description, cronExpression, calendar, timezone);
    }

    public Option<String> updateJobSchedule$default$4() {
        return None$.MODULE$;
    }

    public Option<String> updateJobSchedule$default$6() {
        return None$.MODULE$;
    }

    public TimeZone updateJobSchedule$default$7() {
        return this.defaultTimezone();
    }

    public boolean deleteJobSchedule(String name) {
        return this.unscheduleJob(name);
    }

    /*
     * WARNING - void declaration
     */
    public boolean unscheduleJob(String name) {
        void var2_2;
        boolean isJobCancelled = this.cancelJob(name);
        TrieMap<String, QuartzSchedule> trieMap = isJobCancelled ? this.removeSchedule(name) : BoxedUnit.UNIT;
        return (boolean)var2_2;
    }

    public void createSchedule(String name, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        CronExpression expr;
        Either either = Exception$.MODULE$.catching((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ParseException.class})).either((Function0 & Serializable)() -> new CronExpression(cronExpression));
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.value();
            throw new IllegalArgumentException(new StringBuilder(77).append("Invalid 'expression' for Cron Schedule '").append(name).append("'. Failed to validate CronExpression.").toString(), t);
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        CronExpression cronExpression2 = expr = (CronExpression)right.value();
        CronExpression expression = cronExpression2;
        QuartzCronSchedule schedule = new QuartzCronSchedule(name, description, expression, timezone, calendar);
        Option option = this.schedules().putIfAbsent((Object)name, (Object)schedule);
        if (option instanceof Some) {
            throw new IllegalArgumentException(new StringBuilder(44).append("A schedule with this name already exists: [").append(name).append("]").toString());
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError((Object)option);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Option<String> createSchedule$default$2() {
        return None$.MODULE$;
    }

    public Option<String> createSchedule$default$4() {
        return None$.MODULE$;
    }

    public TimeZone createSchedule$default$5() {
        return this.defaultTimezone();
    }

    public Date rescheduleJob(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        this.cancelJob(name);
        this.removeSchedule(name);
        this.createSchedule(name, description, cronExpression, calendar, timezone);
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Option<String> rescheduleJob$default$4() {
        return None$.MODULE$;
    }

    public Option<String> rescheduleJob$default$6() {
        return None$.MODULE$;
    }

    public TimeZone rescheduleJob$default$7() {
        return this.defaultTimezone();
    }

    public TrieMap<String, QuartzSchedule> removeSchedule(String name) {
        return (TrieMap)this.schedules().$minus$eq((Object)name);
    }

    public Date schedule(String name, ActorRef receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, ActorSelection receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, EventStream receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, ActorRef receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    public Date schedule(String name, ActorSelection receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    public Date schedule(String name, EventStream receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    public Date scheduleInternal(String name, Object receiver, Object msg, Option<Date> startDate) {
        Option option = this.schedules().get((Object)name);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("No matching quartz configuration found for schedule '%s'"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        QuartzSchedule schedule = (QuartzSchedule)some.value();
        Date date = this.scheduleJob(name, receiver, msg, startDate, schedule);
        return date;
    }

    public Date scheduleJob(String name, Object receiver, Object msg, Option<Date> startDate, QuartzSchedule schedule) {
        this.log().info("Setting up scheduled job '{}', with '{}'", (Object)name, (Object)schedule);
        scala.collection.immutable.Map jobDataMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logBus"), (Object)this.system.eventStream()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"receiver"), receiver), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), msg)}));
        JobDataMap jobData = JobDataMapSupport.newJobDataMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)jobDataMap).asJava()));
        JobDetail job = JobBuilder.newJob(SimpleActorMessageJob.class).withIdentity(new StringBuilder(4).append(name).append("_Job").toString()).usingJobData(jobData).withDescription((String)schedule.description().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).build();
        this.log().debug("Adding jobKey {} to runningJobs map.", (Object)job.getKey());
        this.runningJobs().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)job.getKey()));
        this.log().debug("Building Trigger with startDate '{}", startDate.getOrElse((Function0 & Serializable)() -> new Date()));
        Trigger trigger = schedule.buildTrigger(name, startDate);
        this.log().debug("Scheduling Job '{}' and Trigger '{}'. Is Scheduler Running? {}", (Object)job, (Object)trigger, (Object)BoxesRunTime.boxToBoolean((boolean)this.scheduler().isStarted()));
        return this.scheduler().scheduleJob(job, trigger);
    }

    public void initialiseCalendars() {
        QuartzCalendars$.MODULE$.apply(this.config(), this.defaultTimezone()).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)QuartzSchedulerExtension.$anonfun$initialiseCalendars$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
            QuartzSchedulerExtension.$anonfun$initialiseCalendars$2(this, x$1);
            return BoxedUnit.UNIT;
        });
        this.log().info(new StringBuilder(23).append("Initialized calendars: ").append(((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.scheduler().getCalendarNames()).asScala()).mkString(",")).toString());
    }

    /*
     * WARNING - void declaration
     */
    private SimpleThreadPool threadPool$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                SimpleThreadPool _tp = new SimpleThreadPool(this.threadCount(), this.threadPriority());
                _tp.setThreadNamePrefix("AKKA_QRTZ_");
                _tp.setMakeThreadsDaemons(this.daemonThreads_$qmark());
                this.threadPool = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.threadPool;
    }

    public SimpleThreadPool threadPool() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.threadPool$lzycompute() : this.threadPool;
    }

    private JobStore jobStore$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.jobStore = new RAMJobStore();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.jobStore;
    }

    public JobStore jobStore() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.jobStore$lzycompute() : this.jobStore;
    }

    /*
     * WARNING - void declaration
     */
    private Scheduler scheduler$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                void var2_2;
                DirectSchedulerFactory.getInstance().createScheduler(this.schedulerName(), this.system.name(), (ThreadPool)this.threadPool(), this.jobStore());
                Scheduler scheduler = DirectSchedulerFactory.getInstance().getScheduler(this.schedulerName());
                this.log().debug("Initialized a Quartz Scheduler '{}'", (Object)scheduler);
                this.system.registerOnTermination((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    this.log().info("Shutting down Quartz Scheduler with ActorSystem Termination (Any jobs awaiting completion will end as well, as actors are ending)...");
                    scheduler.shutdown(false);
                });
                this.scheduler = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.scheduler;
    }

    public Scheduler scheduler() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.scheduler$lzycompute() : this.scheduler;
    }

    public static final /* synthetic */ boolean $anonfun$initialiseCalendars$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$initialiseCalendars$2(QuartzSchedulerExtension $this, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        Calendar calendar = (Calendar)tuple2._2();
        $this.log().info("Configuring Calendar '{}'", (Object)name);
        $this.scheduler().addCalendar(name, calendar, true, true);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public QuartzSchedulerExtension(ActorSystem system) {
        this.system = system;
        this.log = Logging$.MODULE$.apply(system, (Object)this, package$.MODULE$.quartzExtensionLoggerType());
        this.threadCount = this.config().getInt("threadPool.threadCount");
        Predef$.MODULE$.require(this.threadCount() >= 1, (Function0 & Serializable)() -> "Quartz Thread Count (akka.quartz.threadPool.threadCount) must be a positive integer.");
        this.threadPriority = this.config().getInt("threadPool.threadPriority");
        Predef$.MODULE$.require(this.threadPriority() >= 1 && this.threadPriority() <= 10, (Function0 & Serializable)() -> "Quartz Thread Priority (akka.quartz.threadPool.threadPriority) must be a positive integer between 1 (lowest) and 10 (highest).");
        this.daemonThreads_$qmark = this.config().getBoolean("threadPool.daemonThreads");
        this.defaultTimezone = TimeZone.getTimeZone(this.config().getString("defaultTimezone"));
        this.schedules = new TrieMap();
        this.schedules().$plus$plus$eq(QuartzSchedules$.MODULE$.apply(this.config(), this.defaultTimezone()));
        this.runningJobs = new TrieMap();
        this.log().debug("Configured Schedules: {}", this.schedules());
        this.scheduler().start();
        this.initialiseCalendars();
    }
}

