/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.IdMatchers;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.repository.ReleaseJsonParser;
import com.xebialabs.xlrelease.repository.ReleaseJsonParser$;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001B\u0005\u000b\u0001UA\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003:\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u0015\u0019\u0005\u0001\"\u0011E\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u000bAq!!\b\u0001\t\u0003\nyBA\u000bTc2\u0004F.\u00198Ji\u0016l'+\u001a9pg&$xN]=\u000b\u0005-a\u0011aA:rY*\u0011QBD\u0001\u000be\u0016\u0004xn]5u_JL(BA\b\u0011\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0012%\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002'\u0005\u00191m\\7\u0004\u0001M)\u0001A\u0006\u000f!IA\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1\u0011I\\=SK\u001a\u0004\"!\b\u0010\u000e\u00031I!a\b\u0007\u0003%Ac\u0017M\\%uK6\u0014V\r]8tSR|'/\u001f\t\u0003C\tj\u0011AC\u0005\u0003G)\u0011a\u0003R3tKJL\u0017\r\\5{CRLwN\\*vaB|'\u000f\u001e\t\u0003K)j\u0011A\n\u0006\u0003O!\nQa\u001d7gi)T\u0011!K\u0001\tOJL'P\u001f7fI&\u00111F\n\u0002\b\u0019><w-\u001b8h\u0003I\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0011\u00059\nT\"A\u0018\u000b\u0005AR\u0011a\u00039feNL7\u000f^3oG\u0016L!AM\u0018\u0003%I+G.Z1tKB+'o]5ti\u0016t7-Z\u0001\u0010i\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dKB\u0011a&N\u0005\u0003m=\u0012q\u0002V1tWB+'o]5ti\u0016t7-Z\u0001\u0012e\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014X#A\u001d\u0011\u0005\u0005R\u0014BA\u001e\u000b\u0005Q\u0019\u0016\u000f\u001c*fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;fe\u0006\u0011\"/\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:!\u0003\u0019a\u0014N\\5u}Q!q\bQ!C!\t\t\u0003\u0001C\u0003-\u000b\u0001\u0007Q\u0006C\u00034\u000b\u0001\u0007A\u0007C\u00038\u000b\u0001\u0007\u0011(\u0001\u0005gS:$')_%e+\t)\u0005\n\u0006\u0002G)B\u0011q\t\u0013\u0007\u0001\t\u0015IeA1\u0001K\u0005\u0005!\u0016CA&O!\t9B*\u0003\u0002N1\t9aj\u001c;iS:<\u0007CA(S\u001b\u0005\u0001&BA)\u000f\u0003\u0019!w.\\1j]&\u00111\u000b\u0015\u0002\t!2\fg.\u0013;f[\")QK\u0002a\u0001-\u0006!1-[%e!\t9\u0016N\u0004\u0002YO:\u0011\u0011L\u001a\b\u00035\u0016t!a\u00173\u000f\u0005q\u001bgBA/c\u001d\tq\u0016-D\u0001`\u0015\t\u0001G#\u0001\u0004=e>|GOP\u0005\u0002'%\u0011\u0011CE\u0005\u0003\u001fAI!!\u0004\b\n\u0005-a\u0011B\u0001\u0019\u000b\u0013\tAw&\u0001\u0003DS&#\u0017B\u00016l\u0005\u0011\u0019\u0015.\u00133\u000b\u0005!|\u0003F\u0001\u0004n!\tqG/D\u0001p\u0015\t\u0001\u0018/A\u0006ue\u0006t7/Y2uS>t'BA\u0006s\u0015\t\u0019h\"\u0001\u0002eE&\u0011Qo\u001c\u0002\u000b\u0013N\u0014V-\u00193P]2L\bF\u0001\u0004x!\tAx0D\u0001z\u0015\tQ80\u0001\u0006b]:|G/\u0019;j_:T!\u0001`?\u0002\u000f5,GO]5dg*\u0011aPE\u0001\tG>$\u0017\r[1mK&\u0019\u0011\u0011A=\u0003\u000bQKW.\u001a3\u0002\u0017\u0019Lg\u000e\u001a*fY\u0016\f7/Z\u000b\u0005\u0003\u000f\t\u0019\u0002\u0006\u0003\u0002\n\u0005=\u0001cA(\u0002\f%\u0019\u0011Q\u0002)\u0003\u000fI+G.Z1tK\"1\u0011\u0011C\u0004A\u0002Y\u000b!!\u001b3\u0005\u000f\u00055qA1\u0001\u0002\u0016E\u00191*a\u0006\u0011\u0007]\tI\"C\u0002\u0002\u001ca\u00111!\u00118z\u0003\u0019)\u00070[:ugR!\u0011\u0011EA\u0014!\r9\u00121E\u0005\u0004\u0003KA\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003#A\u0001\u0019AA\u0015!\u0011\tY#a\r\u000f\t\u00055\u0012q\u0006\t\u0003=bI1!!\r\u0019\u0003\u0019\u0001&/\u001a3fM&!\u0011QGA\u001c\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0007\r)\u0007\u0001\tY\u0004E\u0002o\u0003{I1!a\u0010p\u0005=I5\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007")
public class SqlPlanItemRepository
implements PlanItemRepository,
DeserializationSupport,
Logging {
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlPlanItemRepository sqlPlanItemRepository = this;
        synchronized (sqlPlanItemRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Timed
    @IsReadOnly
    public <T extends PlanItem> T findById(String ciId) {
        Option option;
        Option option2;
        Release release;
        Option option3;
        String string = CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(ciId));
        if (string != null && !(option3 = IdMatchers.ReleaseId$.MODULE$.unapply(string)).isEmpty()) {
            String id = (String)option3.get();
            release = this.findRelease(id);
        } else if (string != null && !(option2 = IdMatchers.PhaseId$.MODULE$.unapply(string)).isEmpty()) {
            String id = (String)option2.get();
            release = this.findRelease(Ids.releaseIdFrom((String)id)).getPhase(id);
        } else if (string != null && !(option = IdMatchers.TaskId$.MODULE$.unapply(string)).isEmpty()) {
            String id = (String)option.get();
            release = this.findRelease(Ids.releaseIdFrom((String)id)).getTask(id);
        } else {
            throw new NotFoundException(new StringBuilder(17).append("Item [").append(string).append("] not found").toString(), new Object[0]);
        }
        return (T)release;
    }

    private <Release> Release findRelease(String id) {
        String releaseId = Ids.releaseIdFrom((String)CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id)));
        return (Release)this.releasePersistence.findByReleaseId(releaseId).map((Function1 & Serializable)x$1 -> this.deserializeRelease((ReleaseRow)x$1)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(20).append("Release [").append(id).append("] not found").toString(), new Object[0]);
        });
    }

    public boolean exists(String id) {
        boolean bl;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(Ids.releaseIdFrom((String)id))));
        if (try_ instanceof Success) {
            Option option;
            Option option2;
            boolean bl2;
            Option option3;
            Success success = (Success)try_;
            String releaseId = (String)success.value();
            String string = id;
            if (string != null && !(option3 = IdMatchers.ReleaseId$.MODULE$.unapply(string)).isEmpty()) {
                bl2 = this.releasePersistence.existsRelease(releaseId);
            } else if (string != null && !(option2 = IdMatchers.PhaseId$.MODULE$.unapply(string)).isEmpty()) {
                boolean bl3;
                Option<String> option4 = this.releasePersistence.getReleaseJson(releaseId);
                if (option4 instanceof Some) {
                    Some some = (Some)option4;
                    String releaseJson = (String)some.value();
                    bl3 = Try$.MODULE$.apply((Function0 & Serializable)() -> ReleaseJsonParser$.MODULE$.parse(releaseJson, (ReleaseJsonParser.PlanItemLevel)ReleaseJsonParser.PhaseLevel$.MODULE$).getPhase(id)).isSuccess();
                } else if (None$.MODULE$.equals(option4)) {
                    bl3 = false;
                } else {
                    throw new MatchError(option4);
                }
                bl2 = bl3;
            } else if (string != null && !(option = IdMatchers.TaskId$.MODULE$.unapply(string)).isEmpty()) {
                bl2 = this.taskPersistence.exists(id);
            } else {
                IllegalArgumentException ex = new IllegalArgumentException(new StringBuilder(21).append(id).append(" is not a PlanItem ID").toString());
                this.logger().error((Function0 & Serializable)() -> new StringBuilder(21).append(id).append(" is not a PlanItem ID").toString(), (Function0 & Serializable)() -> ex);
                bl2 = false;
            }
            bl = bl2;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.logger().error((Function0 & Serializable)() -> new StringBuilder(21).append(id).append(" is not a PlanItem ID").toString(), (Function0 & Serializable)() -> exception);
            bl = false;
        } else {
            throw new MatchError((Object)try_);
        }
        return bl;
    }

    public SqlPlanItemRepository(ReleasePersistence releasePersistence, TaskPersistence taskPersistence, SqlRepositoryAdapter repositoryAdapter) {
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.repositoryAdapter = repositoryAdapter;
        DeserializationSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

