#

def getCurrentTask():
    """
    Returns the current task.
    :return: a <a href="/jython-docs/#!/_PROD_VERSION_/service/com.xebialabs.xlrelease.domain.Task">Task</a> object.
    """
    return taskApi.getTask(task.id)

def getCurrentPhase():
    """
    Returns the current phase.
    :return: a <a href="/jython-docs/#!/_PROD_VERSION_/service/com.xebialabs.xlrelease.domain.Phase">Phase</a> object.
    """
    return phaseApi.getPhase(phase.id)

def getCurrentRelease():
    """
    Returns the current release.
    :return: a <a href="/jython-docs/#!/_PROD_VERSION_/service/com.xebialabs.xlrelease.domain.Release">Release</a> object.
    """
    return releaseApi.getRelease(release.id)

def getTasksByTitle(taskTitle, phaseTitle = None, releaseId = None):
    """
    Finds tasks by title.
    :param taskTitle: the task title to search.
    :param phaseTitle: the phase title to search tasks on (optional: will search tasks in the whole release if not provided).
    :param releaseId: the release id to search tasks on (optional: will search tasks in the current release if not provided).
    :return: an array of <a href="/jython-docs/#!/_PROD_VERSION_/service/com.xebialabs.xlrelease.domain.Task">Task</a> objects.
    """
    return taskApi.searchTasksByTitle(taskTitle, phaseTitle, releaseId or release.id)

def getPhasesByTitle(phaseTitle, releaseId = None):
    """
    Finds phases by title.
    :param phaseTitle: the phase title to search.
    :param releaseId: the release id to search phases on (optional: will search phases in the current release if not provided)
    :return: an array of <a href="/jython-docs/#!/_PROD_VERSION_/service/com.xebialabs.xlrelease.domain.Phase">Phase</a> objects.
    """
    return phaseApi.searchPhasesByTitle(phaseTitle, releaseId or release.id)

def getReleasesByTitle(releaseTitle):
    """
    Finds releases by title.
    :param releaseTitle: the release title to search.
    :return: an array of <a href="/jython-docs/#!/_PROD_VERSION_/service/com.xebialabs.xlrelease.domain.Release">Release</a> objects.
    """
    return releaseApi.searchReleasesByTitle(releaseTitle)

def getVersion():
    """
    Returns version of Digital.ai Release instance.
    :return: version of Digital.ai Release instance
    """
    return _version
