/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import org.kohsuke.github.GHDirection;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHSearchBuilder;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.SearchResult;

public class GHRepositorySearchBuilder
extends GHSearchBuilder<GHRepository> {
    GHRepositorySearchBuilder(GitHub root) {
        super(root, RepositorySearchResult.class);
    }

    public GHRepositorySearchBuilder q(String term) {
        super.q(term);
        return this;
    }

    public GHRepositorySearchBuilder in(String v) {
        return this.q("in:" + v);
    }

    public GHRepositorySearchBuilder size(String v) {
        return this.q("size:" + v);
    }

    public GHRepositorySearchBuilder forks(String v) {
        return this.q("forks:" + v);
    }

    public GHRepositorySearchBuilder fork(Fork fork) {
        if (Fork.PARENT_ONLY.equals((Object)fork)) {
            this.terms.removeIf(term -> term.contains("fork:"));
            return this;
        }
        return this.q("fork:" + (Object)((Object)fork));
    }

    public GHRepositorySearchBuilder visibility(GHRepository.Visibility visibility) {
        if (visibility == GHRepository.Visibility.UNKNOWN) {
            throw new GHException("UNKNOWN is a placeholder for unexpected values encountered when reading data. It cannot be passed as a search parameter.");
        }
        return this.q("is:" + (Object)((Object)visibility));
    }

    public GHRepositorySearchBuilder created(String v) {
        return this.q("created:" + v);
    }

    public GHRepositorySearchBuilder pushed(String v) {
        return this.q("pushed:" + v);
    }

    public GHRepositorySearchBuilder user(String v) {
        return this.q("user:" + v);
    }

    public GHRepositorySearchBuilder repo(String v) {
        return this.q("repo:" + v);
    }

    public GHRepositorySearchBuilder language(String v) {
        return this.q("language:" + v);
    }

    public GHRepositorySearchBuilder stars(String v) {
        return this.q("stars:" + v);
    }

    public GHRepositorySearchBuilder topic(String v) {
        return this.q("topic:" + v);
    }

    public GHRepositorySearchBuilder order(GHDirection v) {
        this.req.with("order", v);
        return this;
    }

    public GHRepositorySearchBuilder sort(Sort sort) {
        this.req.with("sort", sort);
        return this;
    }

    @Override
    protected String getApiUrl() {
        return "/search/repositories";
    }

    private static class RepositorySearchResult
    extends SearchResult<GHRepository> {
        private GHRepository[] items;

        private RepositorySearchResult() {
        }

        GHRepository[] getItems(GitHub root) {
            for (GHRepository item : this.items) {
                item.wrap(root);
            }
            return this.items;
        }
    }

    public static enum Fork {
        PARENT_AND_FORKS("true"),
        FORKS_ONLY("only"),
        PARENT_ONLY("");

        private String filterMode;

        private Fork(String mode) {
            this.filterMode = mode;
        }

        public String toString() {
            return this.filterMode;
        }
    }

    public static enum Sort {
        STARS,
        FORKS,
        UPDATED;

    }
}

