/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.developermode;

import com.synopsys.integration.blackduck.developermode.DeveloperModeBdioContent;
import com.synopsys.integration.blackduck.http.BlackDuckRequestFactory;
import com.synopsys.integration.blackduck.service.BlackDuckApiClient;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.rest.HttpUrl;
import com.synopsys.integration.rest.request.Request;

public class RapidScanBdio2Uploader {
    private static final String HEADER_CONTENT_TYPE = "Content-type";
    private static final String CONTENT_TYPE = "application/vnd.blackducksoftware.developer-scan-1-ld-2+json";
    private static final String HEADER_X_BD_MODE = "X-BD-MODE";
    private static final String HEADER_X_BD_DOCUMENT_COUNT = "X-BD-DOCUMENT-COUNT";
    private BlackDuckApiClient blackDuckApiClient;
    private BlackDuckRequestFactory blackDuckRequestFactory;

    public RapidScanBdio2Uploader(BlackDuckApiClient blackDuckApiClient, BlackDuckRequestFactory blackDuckRequestFactory) {
        this.blackDuckApiClient = blackDuckApiClient;
        this.blackDuckRequestFactory = blackDuckRequestFactory;
    }

    public HttpUrl start(DeveloperModeBdioContent header) throws IntegrationException {
        HttpUrl url = this.blackDuckApiClient.getUrl(BlackDuckApiClient.SCAN_DEVELOPER_MODE_PATH);
        Request request = this.blackDuckRequestFactory.createCommonPostRequestBuilder(url, header.getContent()).addHeader(HEADER_CONTENT_TYPE, CONTENT_TYPE).build();
        return this.blackDuckApiClient.executePostRequestAndRetrieveURL(request);
    }

    public void append(HttpUrl url, int count, DeveloperModeBdioContent developerModeBdioContent) throws IntegrationException {
        Request request = this.blackDuckRequestFactory.createCommonPutRequestBuilder(url, developerModeBdioContent.getContent()).addHeader(HEADER_CONTENT_TYPE, CONTENT_TYPE).addHeader(HEADER_X_BD_MODE, "append").addHeader(HEADER_X_BD_DOCUMENT_COUNT, String.valueOf(count)).build();
        this.blackDuckApiClient.execute(request);
    }

    public void finish(HttpUrl url, int count) throws IntegrationException {
        Request request = this.blackDuckRequestFactory.createCommonPutRequestBuilder(url, "").addHeader(HEADER_CONTENT_TYPE, CONTENT_TYPE).addHeader(HEADER_X_BD_MODE, "finish").addHeader(HEADER_X_BD_DOCUMENT_COUNT, String.valueOf(count)).build();
        this.blackDuckApiClient.execute(request);
    }
}

