import React from 'react';
import { mount } from 'enzyme';
import { DotThemeProvider } from '@digital-ai/dot-components';
import { Dropdown } from './dropdown.component';

describe('Dropdown', () => {
    const mountWithTheme = (props) => {
        return mount(
            <DotThemeProvider>
                <Dropdown {...props} />
            </DotThemeProvider>,
        );
    };

    it('should create button with text', () => {
        const wrapper = mountWithTheme({ maxVisibleItems: 10, menuItems: [], text: 'my button' });

        const dropdownButton = wrapper.find('button');
        expect(dropdownButton).toIncludeText('my button');
    });

    describe('menu', () => {
        const menuItems = [
            { children: 'first', key: 'first' },
            { children: 'second', key: 'second' },
        ];

        let wrapper = undefined;
        let dropdownButton = undefined;

        const selectDropDownMenuItems = () => wrapper.find('.dot-menu ul li');
        const selectDownIcon = () => wrapper.find('.dot-icon .icon-arrow-down');
        const selectUpIcon = () => wrapper.find('.dot-icon .icon-arrow-up');

        beforeEach(() => {
            wrapper = mountWithTheme({ maxVisibleItems: 10, menuItems, text: 'my button' });
            dropdownButton = wrapper.find('button');
        });

        it('should change icon when opening and closing', () => {
            expect(selectDownIcon()).toExist();
            expect(selectUpIcon()).not.toExist();
            dropdownButton.simulate('click');
            expect(selectUpIcon()).toExist();
            expect(selectDownIcon()).not.toExist();
            dropdownButton.simulate('click');
            expect(selectDownIcon()).toExist();
            expect(selectUpIcon()).not.toExist();
        });

        it('should open menu onclick and show menu items', () => {
            expect(selectDropDownMenuItems()).not.toExist();
            dropdownButton.simulate('click');
            expect(selectDropDownMenuItems()).toHaveLength(2);
        });
    });
});
