/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.security.sql;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.RepoUser;
import com.xebialabs.deployit.security.SHA256PasswordEncoder;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import com.xebialabs.deployit.security.authentication.UserAlreadyExistsException;
import com.xebialabs.xlplatform.repository.sql.Database;
import com.xebialabs.xlplatform.security.sql.db.Tables$;
import com.xebialabs.xlplatform.security.sql.package$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import slick.ast.BaseTypedType;
import slick.ast.TypedType;
import slick.dbio.DBIOAction;
import slick.dbio.DBIOAction$;
import slick.jdbc.JdbcActionComponent;
import slick.jdbc.JdbcProfile;
import slick.lifted.BaseColumnExtensionMethods;
import slick.lifted.CanBeQueryCondition$;
import slick.lifted.OptionMapper2$;
import slick.lifted.Rep;
import slick.lifted.Shape$;
import slick.lifted.StringColumnExtensionMethods$;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\u0001\u0003\u00015\u0011abU9m+N,'oU3sm&\u001cWM\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005\u001dA\u0011A\u0003=ma2\fGOZ8s[*\u0011\u0011BC\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aC\u0001\u0004G>l7\u0001A\n\u0005\u000191R\u0004\u0005\u0002\u0010)5\t\u0001C\u0003\u0002\u0012%\u0005!A.\u00198h\u0015\u0005\u0019\u0012\u0001\u00026bm\u0006L!!\u0006\t\u0003\r=\u0013'.Z2u!\t92$D\u0001\u0019\u0015\t)\u0011D\u0003\u0002\u001b\u0011\u0005AA-\u001a9m_fLG/\u0003\u0002\u001d1\tYQk]3s'\u0016\u0014h/[2f!\tq2%D\u0001 \u0015\t\u0001\u0013%A\u0003tY\u001a$$NC\u0001#\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u0013 \u0005\u001daunZ4j]\u001eD\u0001B\n\u0001\u0003\u0002\u0003\u0006IaJ\u0001\u0011g\u0016\u001cWO]5us\u0012\u000bG/\u00192bg\u0016\u0004\"\u0001\u000b\u0017\u000e\u0003%R!a\u0001\u0016\u000b\u0005-2\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011Q&\u000b\u0002\t\t\u0006$\u0018MY1tK\")q\u0006\u0001C\u0001a\u00051A(\u001b8jiz\"\"!M\u001a\u0011\u0005I\u0002Q\"\u0001\u0002\t\u000b\u0019r\u0003\u0019A\u0014\t\u000fU\u0002!\u0019!C\u0001m\u00059\u0001O]8gS2,W#A\u001c\u0011\u0005ajT\"A\u001d\u000b\u0005iZ\u0014\u0001\u00026eE\u000eT\u0011\u0001P\u0001\u0006g2L7m[\u0005\u0003}e\u00121B\u00133cGB\u0013xNZ5mK\"1\u0001\t\u0001Q\u0001\n]\n\u0001\u0002\u001d:pM&dW\r\t\u0005\b\u0005\u0002\u0011\r\u0011\"\u0003D\u0003=\u0001\u0018m]:x_J$WI\\2pI\u0016\u0014X#\u0001#\u0011\u0005])\u0015B\u0001$\u0019\u0005U\u0019\u0006*\u0011\u001a6mA\u000b7o]<pe\u0012,enY8eKJDa\u0001\u0013\u0001!\u0002\u0013!\u0015\u0001\u00059bgN<xN\u001d3F]\u000e|G-\u001a:!\u0011\u001dQ\u0005A1A\u0005\n-\u000baBS\"S?\u0006#U*\u0013(`+N+%+F\u0001M!\tyQ*\u0003\u0002O!\t11\u000b\u001e:j]\u001eDa\u0001\u0015\u0001!\u0002\u0013a\u0015a\u0004&D%~\u000bE)T%O?V\u001bVI\u0015\u0011\t\u000bI\u0003A\u0011B*\u0002%\rDWmY6WC2LG-V:fe:\fW.\u001a\u000b\u0003)j\u0003\"!\u0016-\u000e\u0003YS\u0011aV\u0001\u0006g\u000e\fG.Y\u0005\u00033Z\u0013A!\u00168ji\")1,\u0015a\u00019\u0006AQo]3s]\u0006lW\r\u0005\u0002^I:\u0011aL\u0019\t\u0003?Zk\u0011\u0001\u0019\u0006\u0003C2\ta\u0001\u0010:p_Rt\u0014BA2W\u0003\u0019\u0001&/\u001a3fM&\u0011a*\u001a\u0006\u0003GZCQa\u001a\u0001\u0005\n!\f\u0001B]3bIV\u001bXM\u001d\u000b\u0004S\u0006\r\u0001cA+kY&\u00111N\u0016\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00055thB\u00018|\u001d\ty\u0017P\u0004\u0002qq:\u0011\u0011o\u001e\b\u0003eZt!a];\u000f\u0005}#\u0018\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0004\t%\u0011!PA\u0001\u0003I\nL!\u0001`?\u0002\rQ\u000b'\r\\3t\u0015\tQ(!C\u0002\u0000\u0003\u0003\u0011A!V:fe*\u0011A0 \u0005\u00067\u001a\u0004\r\u0001\u0018\u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0003\u0019\u0019'/Z1uKR)A+a\u0003\u0002\u000e!11,!\u0002A\u0002qCq!a\u0004\u0002\u0006\u0001\u0007A,\u0001\u0005qCN\u001cxo\u001c:e\u0011\u001d\t\u0019\u0002\u0001C!\u0003+\tAA]3bIR!\u0011qCA\u000f!\r9\u0012\u0011D\u0005\u0004\u00037A\"\u0001\u0003*fa>,6/\u001a:\t\rm\u000b\t\u00021\u0001]\u0011\u001d\t\t\u0003\u0001C!\u0003G\tQ\u0002\\5tiV\u001bXM\u001d8b[\u0016\u001cHCAA\u0013!\u0015\t9#!\f]\u001b\t\tICC\u0002\u0002,I\tA!\u001e;jY&!\u0011qFA\u0015\u0005\u0011a\u0015n\u001d;\t\u000f\u0005M\u0002\u0001\"\u0011\u00026\u0005qQn\u001c3jMf\u0004\u0016m]:x_J$G#\u0002+\u00028\u0005e\u0002BB.\u00022\u0001\u0007A\fC\u0004\u0002<\u0005E\u0002\u0019\u0001/\u0002\u00179,w\u000fU1tg^|'\u000f\u001a\u0005\b\u0003g\u0001A\u0011IA )\u001d!\u0016\u0011IA\"\u0003\u000bBaaWA\u001f\u0001\u0004a\u0006bBA\u001e\u0003{\u0001\r\u0001\u0018\u0005\b\u0003\u000f\ni\u00041\u0001]\u0003-yG\u000e\u001a)bgN<xN\u001d3\t\u000f\u0005-\u0003\u0001\"\u0011\u0002N\u00051A-\u001a7fi\u0016$2\u0001VA(\u0011\u0019Y\u0016\u0011\na\u00019\"9\u00111\u000b\u0001\u0005B\u0005U\u0013\u0001D1vi\",g\u000e^5dCR,G#\u0002+\u0002X\u0005e\u0003BB.\u0002R\u0001\u0007A\fC\u0004\u0002\u0010\u0005E\u0003\u0019\u0001/")
public class SqlUserService
implements UserService,
Logging {
    private final Database securityDatabase;
    private final JdbcProfile profile;
    private final SHA256PasswordEncoder passwordEncoder;
    private final String JCR_ADMIN_USER;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlUserService sqlUserService = this;
        synchronized (sqlUserService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public JdbcProfile profile() {
        return this.profile;
    }

    private SHA256PasswordEncoder passwordEncoder() {
        return this.passwordEncoder;
    }

    private String JCR_ADMIN_USER() {
        return this.JCR_ADMIN_USER;
    }

    private void checkValidUsername(String username) {
        if (username == null || username.length() == 0) {
            throw new IllegalArgumentException("Username can neither be null nor empty.");
        }
        Option<Tuple2<String, String>> option = this.readUser(username);
        if (option instanceof Some) {
            throw new UserAlreadyExistsException(username);
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Option<Tuple2<String, String>> readUser(String username) {
        return ((TraversableLike)this.securityDatabase.runAwait((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(Tables$.MODULE$.users().filter((Function1 & Serializable & scala.Serializable)x$1 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(StringColumnExtensionMethods$.MODULE$.toLowerCase$extension(this.profile().api().stringColumnExtensionMethods(x$1.username())), (BaseTypedType)this.profile().api().stringColumnType())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)username.toLowerCase(), (TypedType)this.profile().api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.profile().api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable & scala.Serializable)user -> new Tuple2(user.username(), user.password()), Shape$.MODULE$.tuple2Shape(Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().stringColumnType()), Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().stringColumnType()))))).result())).headOption();
    }

    public void create(String username, String password) {
        this.checkValidUsername(username);
        String pwd = this.passwordEncoder().encode((CharSequence)password);
        this.securityDatabase.runAwait(DBIOAction$.MODULE$.seq((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DBIOAction[]{((JdbcActionComponent.SimpleInsertActionComposer)this.profile().api().queryInsertActionExtensionMethods(Tables$.MODULE$.users())).$plus$eq((Object)new Tuple2((Object)username, (Object)pwd))})));
    }

    public RepoUser read(String username) {
        return (RepoUser)this.readUser(username).map((Function1 & Serializable & scala.Serializable)user -> new RepoUser((String)user._1(), this.JCR_ADMIN_USER().equals(user._1()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No such user: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{username})), new Object[0]);
        });
    }

    public List<String> listUsernames() {
        return package$.MODULE$.ListExtensions(((TraversableOnce)this.securityDatabase.runAwait((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(Tables$.MODULE$.users().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.username(), Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().stringColumnType())))).result())).toList()).asJavaMutable();
    }

    public void modifyPassword(String username, String newPassword) {
        this.securityDatabase.runAwait((DBIOAction)this.profile().api().queryUpdateActionExtensionMethods(Tables$.MODULE$.users().filter((Function1 & Serializable & scala.Serializable)x$3 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$3.username(), (BaseTypedType)this.profile().api().stringColumnType())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)username, (TypedType)this.profile().api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.profile().api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.password(), Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().stringColumnType()))).update((Object)this.passwordEncoder().encode((CharSequence)newPassword)));
    }

    public void modifyPassword(String username, String newPassword, String oldPassword) {
        this.readUser(username).foreach((Function1 & Serializable & scala.Serializable)user -> {
            SqlUserService.$anonfun$modifyPassword$3(this, username, newPassword, oldPassword, user);
            return BoxedUnit.UNIT;
        });
    }

    public void delete(String username) {
        this.securityDatabase.runAwait((DBIOAction)this.profile().api().queryDeleteActionExtensionMethods(Tables$.MODULE$.users().filter((Function1 & Serializable & scala.Serializable)x$5 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$5.username(), (BaseTypedType)this.profile().api().stringColumnType())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)username, (TypedType)this.profile().api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.profile().api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition())).delete());
    }

    public void authenticate(String username, String password) {
        Tuple2 user = (Tuple2)this.readUser(username).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AuthenticationFailureException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot authenticate ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{username})));
        });
        if (!this.passwordEncoder().matches((CharSequence)password, (String)user._2())) {
            throw new AuthenticationFailureException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong credentials supplied for user ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{username})));
        }
    }

    public static final /* synthetic */ void $anonfun$modifyPassword$3(SqlUserService $this, String username$4, String newPassword$1, String oldPassword$1, Tuple2 user) {
        if (!$this.passwordEncoder().matches((CharSequence)oldPassword$1, (String)user._2())) {
            throw new IllegalArgumentException("Failed to change password: Old password does not match.");
        }
        $this.modifyPassword(username$4, newPassword$1);
    }

    public SqlUserService(Database securityDatabase) {
        this.securityDatabase = securityDatabase;
        Logging.$init$((Logging)this);
        this.profile = securityDatabase.config().databaseType().profile();
        this.passwordEncoder = new SHA256PasswordEncoder();
        this.JCR_ADMIN_USER = "admin";
    }
}

