/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.util.JavaCryptoUtils;
import com.xebialabs.overthere.util.OverthereUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.codec.binary.Hex;

public class SecretKeyHolder {
    private static final AtomicReference<SecretKeyHolder> instance = new AtomicReference();
    private final SecretKey secretKey;

    public static void init(SecretKey key) {
        instance.set(new SecretKeyHolder(key));
    }

    public static void reset() {
        instance.set(null);
    }

    public static SecretKeyHolder get() {
        SecretKeyHolder encryptionKeyHolder = instance.get();
        OverthereUtils.checkState((encryptionKeyHolder != null ? 1 : 0) != 0, (String)"EncryptionKeyHolder not yet set, please construct one.", (Object[])new Object[0]);
        return encryptionKeyHolder;
    }

    public SecretKeyHolder(SecretKey secretKey) {
        Checks.checkNotNull(secretKey, "secretKey cannot be null");
        this.secretKey = secretKey;
    }

    public String getKeyFingerprint() {
        byte[] bytes = JavaCryptoUtils.getSha1().digest(this.secretKey.getEncoded());
        return Hex.encodeHexString((byte[])bytes);
    }

    public Cipher getEncryption() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        return this.getCipher(1);
    }

    public Cipher getDecryption() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        return this.getCipher(2);
    }

    private Cipher getCipher(int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher aes = Cipher.getInstance(this.secretKey.getAlgorithm());
        aes.init(mode, this.secretKey);
        return aes;
    }

    public Cipher getEncryption(String transformation, IvParameterSpec ivParameterSpec) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return this.getCipher(transformation, 1, ivParameterSpec);
    }

    public Cipher getDecryption(String transformation, IvParameterSpec ivParameterSpec) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return this.getCipher(transformation, 2, ivParameterSpec);
    }

    private Cipher getCipher(String transformation, int mode, IvParameterSpec ivParameterSpec) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher aes = Cipher.getInstance(transformation);
        aes.init(mode, (Key)this.secretKey, ivParameterSpec);
        return aes;
    }
}

