/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.util;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.encryption.AESPasswordEncrypter;
import com.xebialabs.deployit.encryption.IPasswordEncrypter;
import com.xebialabs.deployit.encryption.LegacyPasswordEncrypter;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.security.SecretKeyHolder;
import com.xebialabs.overthere.util.OverthereUtils;
import java.security.GeneralSecurityException;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.SecretKey;

public class PasswordEncrypter
implements IPasswordEncrypter {
    private LegacyPasswordEncrypter peLegacy;
    private AESPasswordEncrypter peIV;
    private static final AtomicReference<PasswordEncrypter> instance = new AtomicReference();

    public static void init(SecretKey secretKey) {
        SecretKeyHolder.init(secretKey);
        instance.set(new PasswordEncrypter(secretKey));
    }

    public static void init(SecretKey secretKey, PasswordEncrypter passwordEncrypter) {
        SecretKeyHolder.init(secretKey);
        instance.set(passwordEncrypter);
    }

    public static PasswordEncrypter getInstance() {
        OverthereUtils.checkState((instance.get() != null ? 1 : 0) != 0, (String)"PasswordEncrypter not yet set, please construct one.", (Object[])new Object[0]);
        return instance.get();
    }

    public PasswordEncrypter(SecretKeyHolder encryptionKeyHolder) {
        this.peLegacy = new LegacyPasswordEncrypter(encryptionKeyHolder);
        this.peIV = new AESPasswordEncrypter(encryptionKeyHolder);
    }

    public PasswordEncrypter(SecretKey passwordEncryptionKey) {
        this.peLegacy = new LegacyPasswordEncrypter(passwordEncryptionKey);
        this.peIV = new AESPasswordEncrypter(passwordEncryptionKey);
    }

    @Override
    public boolean isEncoded(String text) {
        return this.peIV.isEncoded(text) || this.peLegacy.isEncoded(text);
    }

    @Override
    public boolean isEncrypted(String text) {
        return this.peIV.isEncrypted(text) || this.peLegacy.isEncrypted(text);
    }

    @Override
    public boolean isEncodedAndDecryptable(String text) {
        return this.peIV.isEncodedAndDecryptable(text) || this.peLegacy.isEncodedAndDecryptable(text);
    }

    @Override
    public String encrypt(String plaintext) {
        return this.peIV.encrypt(plaintext);
    }

    @Override
    public String ensureEncrypted(String text) {
        if (this.isEncrypted(text)) {
            return text;
        }
        return this.encrypt(text);
    }

    @Override
    public String decrypt(String encryptedText) {
        Checks.checkArgument(encryptedText != null, "The password is null", new Object[0]);
        Checks.checkArgument(encryptedText.startsWith("{b64}") || encryptedText.startsWith("{aes:%s}".substring(0, 4)), "The password should be Base64 encoded", new Object[0]);
        try {
            if (this.peIV.isEncoded(encryptedText)) {
                return this.peIV.doDecodeAndDecrypt(encryptedText);
            }
            return this.peLegacy.doDecodeAndDecrypt(encryptedText);
        }
        catch (GeneralSecurityException e) {
            throw new DeployitException("Could not decrypt the password.");
        }
    }

    @Override
    public String ensureDecrypted(String text) {
        if (this.isEncrypted(text)) {
            return this.decrypt(text);
        }
        return text;
    }

    @Override
    public String getKeyFingerprint() {
        return this.peIV.getKeyFingerprint();
    }

    @Override
    public String prefix() {
        return this.peIV.prefix();
    }
}

