/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.migrator;

import com.typesafe.config.Config;
import com.xebialabs.deployit.core.rest.api.DtoReader;
import com.xebialabs.deployit.core.rest.api.DtoWriter;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.QueryTemplate;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.security.RepoUser;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlrelease.configuration.TaskAccess;
import com.xebialabs.xlrelease.configuration.UserProfile;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.calendar.SpecialDay;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.variables.GlobalVariables;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.migrator.Migrator;
import com.xebialabs.xlrelease.migrator.SqlMigrator$createFolderAndTeams0$;
import com.xebialabs.xlrelease.migrator.SqlMigrator$migrateUsers$;
import com.xebialabs.xlrelease.migrator.SqlMigrator$searchAndInsertReleases$;
import com.xebialabs.xlrelease.migrator.config.Services;
import com.xebialabs.xlrelease.migrator.util.CloseableWorkDir;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.jcr.JcrTeamRepository;
import com.xebialabs.xlrelease.repository.query.JcrPredicate;
import com.xebialabs.xlrelease.repository.query.JcrQueryBuilder;
import com.xebialabs.xlrelease.repository.sql.SqlFolderRepository;
import com.xebialabs.xlrelease.repository.sql.SqlUserProfileRepository;
import com.xebialabs.xlrelease.service.CalendarService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.upgrade.Components;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.Session;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.security.authentication.CryptedSimpleCredentials;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import scala.Option;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0019\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0082\u0010J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010\u001b\u001a\u00020\u00132\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u000fH\u0002J\b\u0010 \u001a\u00020\u0013H\u0002J\b\u0010!\u001a\u00020\u0013H\u0002J\b\u0010\"\u001a\u00020\u0013H\u0002J\u0006\u0010#\u001a\u00020\u0007J\u0006\u0010$\u001a\u00020\u0013J\b\u0010%\u001a\u00020\u0013H\u0002J\b\u0010&\u001a\u00020\u0013H\u0002J\b\u0010'\u001a\u00020\u0013H\u0002J\u0006\u0010(\u001a\u00020\u0013J\b\u0010)\u001a\u00020\u0013H\u0002J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u0010H\u0002J\b\u0010,\u001a\u00020\u0013H\u0002J\b\u0010-\u001a\u00020\u0013H\u0002J\u0019\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u0002002\u0006\u0010\u0016\u001a\u00020\u0017H\u0082\u0010J\u0019\u00101\u001a\u00020\u00132\u0006\u0010/\u001a\u0002002\u0006\u0010\u0016\u001a\u00020\u0017H\u0082\u0010J\b\u00102\u001a\u00020\u0013H\u0002J\b\u00103\u001a\u00020\u0013H\u0002R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/xebialabs/xlrelease/migrator/SqlMigrator;", "Lcom/xebialabs/xlrelease/migrator/Migrator;", "services", "Lcom/xebialabs/xlrelease/migrator/config/Services;", "migratorConfig", "Lcom/typesafe/config/Config;", "skipErrors", "", "(Lcom/xebialabs/xlrelease/migrator/config/Services;Lcom/typesafe/config/Config;Z)V", "dependencies", "Ljava/util/ArrayList;", "Lcom/xebialabs/xlrelease/domain/Dependency;", "Lkotlin/collections/ArrayList;", "sqlReleases", "Ljava/util/HashMap;", "", "Lcom/xebialabs/xlrelease/domain/Release;", "Lkotlin/collections/HashMap;", "createFolderAndTeams", "", "rootFolder", "createFolderAndTeams0", "pageNumber", "", "createOrUpdateConfiguration", "conf", "Lcom/xebialabs/xlrelease/domain/BaseConfiguration;", "migrateActivityLogs", "activityLogs", "", "Lcom/xebialabs/xlrelease/domain/ActivityLogEntry;", "releaseId", "migrateCalendarEntries", "migrateFoldersAndTeams", "migrateGlobalVariables", "migrateJcr", "migrateReleases", "migrateRepositoryVersion", "migrateRolesAndPermissions", "migrateSettings", "migrateSharedConfigurations", "migrateTaskAccess", "migrateTaskBackup", "release", "migrateUserProfiles", "migrateUsers", "searchAndInsertReleases", "params", "Lcom/xebialabs/deployit/repository/SearchParameters;", "searchAndInsertSharedConfigurations", "searchAndUpdateDependencies", "setVersion", "xl-release-sql-migrator"})
public final class SqlMigrator
extends Migrator {
    private final ArrayList<Dependency> dependencies;
    private final HashMap<String, Release> sqlReleases;
    private final Services services;

    public final boolean migrateJcr() {
        new WorkDirContext(new WorkDirFactory("work-migration"));
        this.getLogger().info("Migrating users");
        this.migrateUsers();
        this.getLogger().info("Users migrated");
        this.getLogger().info("Migrating user profiles");
        this.migrateUserProfiles();
        this.getLogger().info("User profiles migrated");
        this.getLogger().info("Migrating roles and permissions");
        this.migrateRolesAndPermissions();
        this.getLogger().info("Roles and permissions migrated");
        this.getLogger().info("Migrating shared configurations...");
        this.migrateSharedConfigurations();
        this.getLogger().info("Shared configurations migrated");
        this.getLogger().info("Migrating folders and teams...");
        this.migrateFoldersAndTeams();
        this.getLogger().info("Folders migrated");
        this.getLogger().info("Migrating settings...");
        this.migrateSettings();
        this.getLogger().info("Settings migrated");
        this.getLogger().info("Migrating task access settings...");
        this.migrateTaskAccess();
        this.getLogger().info("Task access settings migrated");
        this.getLogger().info("Migrating global variables...");
        this.migrateGlobalVariables();
        this.getLogger().info("Global variables migrated");
        this.getLogger().info("Migrating calendar entries...");
        this.migrateCalendarEntries();
        this.getLogger().info("Calendar entries migrated");
        this.getLogger().info("Migrating repository version...");
        this.migrateRepositoryVersion();
        this.getLogger().info("Repository version migrated");
        this.getLogger().info("Migrating releases with activity logs and task backups...");
        this.migrateReleases();
        this.getLogger().info("Releases with activity logs and task backups migrated");
        this.setVersion();
        this.getLogger().info("Finished JCR migration");
        return !this.getErrorsFound();
    }

    /*
     * WARNING - void declaration
     */
    private final void migrateUsers() {
        void $receiver$iv$iv;
        List list = this.services.getJcrUserService().listUsernames();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"services.jcrUserService.listUsernames()");
        Iterable $receiver$iv = list;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it = (String)element$iv$iv;
            if (!(Intrinsics.areEqual((Object)it, (Object)"jcr_admin") ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            String username = (String)element$iv;
            this.services.getJcrTemplate().execute((JcrCallback)new JcrCallback<Object>(username, this){
                final /* synthetic */ String $username;
                final /* synthetic */ SqlMigrator this$0;
                {
                    this.$username = string;
                    this.this$0 = sqlMigrator;
                }

                public final Object doInJcr(Session it) {
                    Session session = it;
                    if (session == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.apache.jackrabbit.api.JackrabbitSession");
                    }
                    UserManager um = ((JackrabbitSession)session).getUserManager();
                    Authorizable authorizable = um.getAuthorizable(this.$username);
                    if (authorizable == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.apache.jackrabbit.api.security.user.User");
                    }
                    User user = (User)authorizable;
                    Credentials credentials = user.getCredentials();
                    if (credentials == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.apache.jackrabbit.core.security.authentication.CryptedSimpleCredentials");
                    }
                    CryptedSimpleCredentials crypted = (CryptedSimpleCredentials)credentials;
                    return SqlMigrator.access$getServices$p(this.this$0).getReleasesTransactionTemplate().execute((TransactionCallback)new TransactionCallback<Object>(this, crypted){
                        final /* synthetic */ migrateUsers$$inlined$forEach$lambda$1 this$0;
                        final /* synthetic */ CryptedSimpleCredentials $crypted;
                        {
                            this.this$0 = var1_1;
                            this.$crypted = cryptedSimpleCredentials;
                        }

                        public final Object doInTransaction(TransactionStatus it) {
                            RepoUser repoUser;
                            try {
                                repoUser = SqlMigrator.access$getServices$p(this.this$0.this$0).getSqlUserService().read(this.this$0.$username);
                            }
                            catch (NotFoundException e) {
                                this.this$0.this$0.trySkipErrors((Function0<Unit>)((Function0)new Function0<Unit>(this){
                                    final /* synthetic */ migrateUsers$$inlined$forEach$lambda$1$1 this$0;
                                    {
                                        this.this$0 = var1_1;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        SqlMigrator.access$getServices$p(this.this$0.this$0.this$0).getReleasePersistence().jdbcTemplate().execute("INSERT INTO XL_USERS (USERNAME, PASSWORD) VALUES ('" + this.this$0.this$0.$username + "', '" + this.this$0.$crypted.getPassword() + "')");
                                    }
                                }));
                                repoUser = Unit.INSTANCE;
                            }
                            return repoUser;
                        }
                    });
                }
            });
        }
    }

    private final void migrateUserProfiles() {
        SearchParameters query = new SearchParameters().setType(Type.valueOf(UserProfile.class));
        List list = this.services.getRepositoryService().listEntities(query);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"services.repositoryServi\u2026ities<UserProfile>(query)");
        Iterable $receiver$iv = list;
        for (Object element$iv : $receiver$iv) {
            UserProfile profile = (UserProfile)element$iv;
            this.trySkipErrors((Function0<Unit>)((Function0)new Function0<Unit>(profile, this){
                final /* synthetic */ UserProfile $profile;
                final /* synthetic */ SqlMigrator this$0;
                {
                    this.$profile = userProfile;
                    this.this$0 = sqlMigrator;
                    super(0);
                }

                public final void invoke() {
                    SqlUserProfileRepository sqlUserProfileRepository = SqlMigrator.access$getServices$p(this.this$0).getSqlUserProfileRepository();
                    UserProfile userProfile = this.$profile;
                    Intrinsics.checkExpressionValueIsNotNull((Object)userProfile, (String)"profile");
                    if (!sqlUserProfileRepository.exists(userProfile.getCanonicalId())) {
                        SqlMigrator.access$getServices$p(this.this$0).getSqlUserProfileRepository().create(this.$profile);
                    } else {
                        Logger logger = this.this$0.getLogger();
                        StringBuilder stringBuilder = new StringBuilder().append("User profile for [");
                        UserProfile userProfile2 = this.$profile;
                        Intrinsics.checkExpressionValueIsNotNull((Object)userProfile2, (String)"profile");
                        logger.debug(stringBuilder.append(userProfile2.getCanonicalId()).append("] has already been migrated").toString());
                    }
                }
            }));
        }
    }

    private final void migrateRolesAndPermissions() {
        List roleAssignments = this.services.getJcrRoleService().readRoleAssignments();
        this.trySkipErrors((Function0<Unit>)((Function0)new Function0<Unit>(this, roleAssignments){
            final /* synthetic */ SqlMigrator this$0;
            final /* synthetic */ List $roleAssignments;

            public final void invoke() {
                SqlMigrator.access$getServices$p(this.this$0).getSqlRoleService().writeRoleAssignments(this.$roleAssignments);
            }
            {
                this.this$0 = sqlMigrator;
                this.$roleAssignments = list;
                super(0);
            }
        }));
        Map globalPermissionsMap = this.services.getJcrPermissionEditor().readPermissions("global");
        this.trySkipErrors((Function0<Unit>)((Function0)new Function0<Unit>(this, globalPermissionsMap){
            final /* synthetic */ SqlMigrator this$0;
            final /* synthetic */ Map $globalPermissionsMap;

            public final void invoke() {
                List rolePermissions = new DtoWriter().writeRolePermissions(this.$globalPermissionsMap);
                List roles = SqlMigrator.access$getServices$p(this.this$0).getSqlRoleService().getRoles();
                Map multimap = new DtoReader().readRolePermissions(rolePermissions, roles);
                SqlMigrator.access$getServices$p(this.this$0).getSqlPermissionEditor().editPermissions("global", multimap);
            }
            {
                this.this$0 = sqlMigrator;
                this.$globalPermissionsMap = map;
                super(0);
            }
        }));
    }

    public final void migrateSharedConfigurations() {
        SearchParameters searchParams = new SearchParameters();
        searchParams.setType(Type.valueOf(Configuration.class));
        searchParams.setResultsPerPage(this.getPageSize());
        this.searchAndInsertSharedConfigurations(searchParams, 0L);
    }

    private final void migrateFoldersAndTeams() {
        this.createFolderAndTeams("/Applications");
    }

    private final void migrateSettings() {
        List settingsIds = CollectionsKt.mutableListOf((Object[])new String[]{"Configuration/settings/ArchivingSettings", "Configuration/settings/PollingSettings", "Configuration/reports/ReportsSettings", "Configuration/mail/SmtpServer", "Configuration/mail/EmailNotificationSettings"});
        Iterable $receiver$iv = settingsIds;
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            if (this.services.getRepositoryService().exists(it)) {
                BaseConfiguration configuration;
                BaseConfiguration baseConfiguration = configuration = (BaseConfiguration)this.services.getRepositoryService().read(it, false);
                Intrinsics.checkExpressionValueIsNotNull((Object)baseConfiguration, (String)"configuration");
                this.createOrUpdateConfiguration(baseConfiguration);
                continue;
            }
            this.getLogger().info("Skipping migration of non-existing configuration [" + it + ']');
        }
    }

    private final void migrateTaskAccess() {
        List taskAccesses;
        SearchParameters params = new SearchParameters().setType(Type.valueOf(TaskAccess.class));
        List list = taskAccesses = this.services.getRepositoryService().listEntities(params);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"taskAccesses");
        Iterable $receiver$iv = list;
        for (Object element$iv : $receiver$iv) {
            TaskAccess ta;
            TaskAccess taskAccess = ta = (TaskAccess)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)taskAccess, (String)"ta");
            this.createOrUpdateConfiguration((BaseConfiguration)taskAccess);
        }
    }

    private final void migrateGlobalVariables() {
        if (this.services.getRepositoryService().exists(GlobalVariables.GLOBAL_VARIABLES_ID)) {
            GlobalVariables globalVariables;
            GlobalVariables globalVariables2 = globalVariables = (GlobalVariables)this.services.getRepositoryService().read(GlobalVariables.GLOBAL_VARIABLES_ID);
            Intrinsics.checkExpressionValueIsNotNull((Object)globalVariables2, (String)"globalVariables");
            List list = globalVariables2.getVariables();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"globalVariables.variables");
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                Variable it;
                Variable variable = it = (Variable)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)variable, (String)"it");
                this.createOrUpdateConfiguration((BaseConfiguration)variable);
            }
        } else {
            this.getLogger().info("Skipping migration of non-existing global variables");
        }
    }

    private final void migrateCalendarEntries() {
        List blackouts;
        List specialDays;
        SearchParameters sdParams = new SearchParameters().setType(Type.valueOf(SpecialDay.class));
        List list = specialDays = this.services.getRepositoryService().listEntities(sdParams);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"specialDays");
        Iterable $receiver$iv = list;
        for (Object element$iv : $receiver$iv) {
            SpecialDay sd = (SpecialDay)element$iv;
            this.trySkipErrors((Function0<Unit>)((Function0)new Function0<Unit>(sd, this){
                final /* synthetic */ SpecialDay $sd;
                final /* synthetic */ SqlMigrator this$0;
                {
                    this.$sd = specialDay;
                    this.this$0 = sqlMigrator;
                    super(0);
                }

                public final void invoke() {
                    SpecialDay specialDay = this.$sd;
                    Intrinsics.checkExpressionValueIsNotNull((Object)specialDay, (String)"sd");
                    specialDay.set$token((String)null);
                    CalendarService calendarService = SqlMigrator.access$getServices$p(this.this$0).getCalendarService();
                    SpecialDay specialDay2 = this.$sd;
                    Intrinsics.checkExpressionValueIsNotNull((Object)specialDay2, (String)"sd");
                    calendarService.setSpecialDay(specialDay2.getId(), this.$sd);
                }
            }));
        }
        SearchParameters boParams = new SearchParameters().setType(Type.valueOf(Blackout.class));
        List list2 = blackouts = this.services.getRepositoryService().listEntities(boParams);
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"blackouts");
        Iterable $receiver$iv2 = list2;
        for (Object element$iv : $receiver$iv2) {
            Blackout bo = (Blackout)element$iv;
            this.trySkipErrors((Function0<Unit>)((Function0)new Function0<Unit>(bo, this){
                final /* synthetic */ Blackout $bo;
                final /* synthetic */ SqlMigrator this$0;
                {
                    this.$bo = blackout;
                    this.this$0 = sqlMigrator;
                    super(0);
                }

                public final void invoke() {
                    Blackout blackout = this.$bo;
                    Intrinsics.checkExpressionValueIsNotNull((Object)blackout, (String)"bo");
                    blackout.set$token((String)null);
                    SqlMigrator.access$getServices$p(this.this$0).getCalendarService().addBlackout(this.$bo);
                }
            }));
        }
    }

    private final void migrateRepositoryVersion() {
        Option maybeRepositoryId;
        Option option = maybeRepositoryId = this.services.getJcrRepositoryMetadataService().queryRepositoryId();
        Intrinsics.checkExpressionValueIsNotNull((Object)option, (String)"maybeRepositoryId");
        if (option.isDefined()) {
            this.services.getSqlRepositoryMetadataService().saveRepositoryId((String)maybeRepositoryId.get());
        }
    }

    public final void migrateReleases() {
        SearchParameters releaseParams = new SearchParameters();
        releaseParams.setType(Type.valueOf(Release.class));
        releaseParams.setResultsPerPage(this.getPageSize());
        this.searchAndInsertReleases(releaseParams, 0L);
        this.searchAndUpdateDependencies();
    }

    private final void setVersion() {
        Version version;
        Version version2 = version = this.services.getJcrRepositoryVersionService().readVersionOfComponent(Components.XL_RELEASE_COMPONENT);
        if ((version2 != null ? version2.getVersion() : null) != null) {
            this.getLogger().info("Setting XL Release xl_version to version " + version.getVersion() + "....");
            this.services.getSqlRepositoryVersionService().storeVersionOfComponent(Version.valueOf((String)Components.XL_RELEASE_COMPONENT, (String)version.getVersion()));
        }
    }

    private final void searchAndInsertSharedConfigurations(SearchParameters params, long pageNumber) {
        while (true) {
            List configurations;
            this.getLogger().trace("Migrating " + pageNumber * this.getPageSize() + " - " + (pageNumber + 1L) * this.getPageSize() + " shared configurations");
            params.setPage(pageNumber);
            List list = configurations = this.services.getRepositoryService().listEntities(params);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"configurations");
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                Configuration conf;
                Configuration configuration = conf = (Configuration)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"conf");
                this.createOrUpdateConfiguration((BaseConfiguration)configuration);
            }
            if ((long)configurations.size() < this.getPageSize()) break;
            ++pageNumber;
        }
    }

    private final void createOrUpdateConfiguration(BaseConfiguration conf) {
        this.trySkipErrors((Function0<Unit>)((Function0)new Function0<Unit>(this, conf){
            final /* synthetic */ SqlMigrator this$0;
            final /* synthetic */ BaseConfiguration $conf;

            public final void invoke() {
                this.this$0.getLogger().debug("Migrating [" + this.$conf.getId() + ']');
                this.$conf.set$token((String)null);
                SqlMigrator.access$getServices$p(this.this$0).getSqlConfigurationRepository().createOrUpdate(this.$conf);
            }
            {
                this.this$0 = sqlMigrator;
                this.$conf = baseConfiguration;
                super(0);
            }
        }));
    }

    private final void createFolderAndTeams(String rootFolder) {
        this.createFolderAndTeams0(rootFolder, 0L);
    }

    private final void createFolderAndTeams0(String rootFolder, long pageNumber) {
        while (true) {
            List folders;
            QueryTemplate query = JcrQueryBuilder.select((String[])new String[]{"*"}).from("ci").where(JcrPredicate.and((JcrPredicate[])new JcrPredicate[]{JcrPredicate.as((String)"ci", (Type)Type.valueOf((String)"xlrelease.Folder")), JcrPredicate.isChildNode((String)"ci", (String)JcrPathHelper.getAbsolutePathFromId((String)rootFolder))})).orderBy("title ASC").build();
            query.setPage(pageNumber);
            query.setResultsPerPage(this.getPageSize());
            List list = folders = this.services.getRepositoryService().listEntities(query);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"folders");
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                Folder folder = (Folder)element$iv;
                SqlFolderRepository sqlFolderRepository = this.services.getSqlFolderRepository();
                Folder folder2 = folder;
                Intrinsics.checkExpressionValueIsNotNull((Object)folder2, (String)"folder");
                if (!sqlFolderRepository.exists(folder2.getId())) {
                    this.trySkipErrors((Function0<Unit>)((Function0)new Function0<Unit>(folder, this){
                        final /* synthetic */ Folder $folder;
                        final /* synthetic */ SqlMigrator this$0;
                        {
                            this.$folder = folder;
                            this.this$0 = sqlMigrator;
                            super(0);
                        }

                        public final void invoke() {
                            Logger logger = this.this$0.getLogger();
                            StringBuilder stringBuilder = new StringBuilder().append("Migrating folder [");
                            Folder folder = this.$folder;
                            Intrinsics.checkExpressionValueIsNotNull((Object)folder, (String)"folder");
                            logger.debug(stringBuilder.append(folder.getId()).append(']').toString());
                            SqlMigrator.access$getServices$p(this.this$0).getReleasesTransactionTemplate().execute((TransactionCallback)new TransactionCallback<List<Team>>(this){
                                final /* synthetic */ createFolderAndTeams0$$inlined$forEach$lambda$1 this$0;
                                {
                                    this.this$0 = var1_1;
                                }

                                public final List<Team> doInTransaction(TransactionStatus it) {
                                    List teams;
                                    SqlFolderRepository sqlFolderRepository = SqlMigrator.access$getServices$p(this.this$0.this$0).getSqlFolderRepository();
                                    Folder folder = this.this$0.$folder;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)folder, (String)"folder");
                                    sqlFolderRepository.create(Ids.getParentId((String)folder.getId()), this.this$0.$folder);
                                    JcrTeamRepository jcrTeamRepository = SqlMigrator.access$getServices$p(this.this$0.this$0).getJcrTeamRepository();
                                    Folder folder2 = this.this$0.$folder;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)folder2, (String)"folder");
                                    List list = teams = jcrTeamRepository.getStoredTeams(folder2.getId());
                                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"teams");
                                    Iterable $receiver$iv = list;
                                    for (T element$iv : $receiver$iv) {
                                        Team team;
                                        Team team2 = team = (Team)element$iv;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)team2, (String)"team");
                                        team2.setId((String)null);
                                    }
                                    TeamService teamService = SqlMigrator.access$getServices$p(this.this$0.this$0).getTeamService();
                                    Folder folder3 = this.this$0.$folder;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)folder3, (String)"folder");
                                    return teamService.saveTeamsToPlatform(folder3.getId(), teams);
                                }
                            });
                        }
                    }));
                } else {
                    this.getLogger().debug("Folder [" + folder.getId() + "] has already been migrated");
                }
                String string = folder.getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"folder.id");
                this.createFolderAndTeams(string);
            }
            if ((long)folders.size() < this.getPageSize()) break;
            ++pageNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void searchAndInsertReleases(SearchParameters params, long pageNumber) {
        while (true) {
            void $receiver$iv$iv;
            this.getLogger().info("Processing releases " + pageNumber * this.getPageSize() + " - " + (pageNumber + 1L) * this.getPageSize() + "...");
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            params.setPage(pageNumber);
            List list = this.services.getRepositoryService().list(params);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"services.repositoryService.list(params)");
            Iterable $receiver$iv = list;
            Object object = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ConfigurationItemData configurationItemData = (ConfigurationItemData)item$iv$iv;
                Collection collection = destination$iv$iv;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                String string = v1.getId();
                collection.add(string);
            }
            List releaseIds = (List)destination$iv$iv;
            Closeable closeable = new CloseableWorkDir();
            object = null;
            try {
                CloseableWorkDir it = (CloseableWorkDir)closeable;
                Collection collection = releaseIds;
                if (!collection.isEmpty()) {
                    void skippedCount;
                    Iterable $receiver$iv2 = releaseIds;
                    for (Object element$iv : $receiver$iv2) {
                        void $receiver$iv$iv2;
                        Release release;
                        String releaseId = (String)element$iv;
                        if (!this.services.getSqlReleaseRepository().exists(releaseId)) {
                            this.getLogger().debug("Migrating release " + releaseId);
                            this.trySkipErrors((Function0<Unit>)((Function0)new Function0<Unit>(releaseId, this, releaseIds, (Ref.IntRef)skippedCount){
                                final /* synthetic */ String $releaseId;
                                final /* synthetic */ SqlMigrator this$0;
                                final /* synthetic */ List $releaseIds$inlined;
                                final /* synthetic */ Ref.IntRef $skippedCount$inlined;
                                {
                                    this.$releaseId = string;
                                    this.this$0 = sqlMigrator;
                                    this.$releaseIds$inlined = list;
                                    this.$skippedCount$inlined = intRef;
                                    super(0);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final void invoke() {
                                    void $receiver$iv$iv;
                                    Iterable $receiver$iv;
                                    Release release;
                                    Release release2 = release = (Release)SqlMigrator.access$getServices$p(this.this$0).getRepositoryService().read(this.$releaseId, Integer.MAX_VALUE, WorkDirContext.get(), false);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)release2, (String)"release");
                                    List list = release2.getAllGates();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"release.allGates");
                                    Iterable iterable = $receiver$iv = (Iterable)list;
                                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                                    for (T item$iv$iv : $receiver$iv$iv) {
                                        void g;
                                        GateTask gateTask = (GateTask)item$iv$iv;
                                        Collection collection = destination$iv$iv;
                                        void v2 = g;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"g");
                                        List list2 = v2.getDependencies();
                                        collection.add(list2);
                                    }
                                    List releaseDependencies = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
                                    SqlMigrator.access$getDependencies$p(this.this$0).addAll(releaseDependencies);
                                    SqlMigrator.access$getServices$p(this.this$0).getJcrTeamRepository().decorateWithStoredTeams(release);
                                    SqlMigrator.access$getServices$p(this.this$0).getReleasesTransactionTemplate().execute((TransactionCallback)new TransactionCallback<List<Team>>(this, release, releaseDependencies){
                                        final /* synthetic */ searchAndInsertReleases$$inlined$use$lambda$1 this$0;
                                        final /* synthetic */ Release $release;
                                        final /* synthetic */ List $releaseDependencies;
                                        {
                                            this.this$0 = var1_1;
                                            this.$release = release;
                                            this.$releaseDependencies = list;
                                        }

                                        public final List<Team> doInTransaction(TransactionStatus it) {
                                            Release sqlRelease = SqlMigrator.access$getServices$p(this.this$0.this$0).getSqlReleaseRepository().create(this.$release, null);
                                            Object object = this.$releaseDependencies;
                                            if (!object.isEmpty()) {
                                                object = SqlMigrator.access$getSqlReleases$p(this.this$0.this$0);
                                                String string = this.this$0.$releaseId;
                                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"releaseId");
                                                String string2 = string;
                                                Release release = sqlRelease;
                                                Intrinsics.checkExpressionValueIsNotNull((Object)release, (String)"sqlRelease");
                                                Release release2 = release;
                                                object.put(string2, release2);
                                            }
                                            SqlMigrator sqlMigrator = this.this$0.this$0;
                                            Release release = this.$release;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)release, (String)"release");
                                            SqlMigrator.access$migrateTaskBackup(sqlMigrator, release);
                                            List activityLogs = SqlMigrator.access$getServices$p(this.this$0.this$0).getJcrActivityLogRepository().findAllLogsOf(this.this$0.$releaseId);
                                            SqlMigrator sqlMigrator2 = this.this$0.this$0;
                                            List list = activityLogs;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"activityLogs");
                                            String string = this.this$0.$releaseId;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"releaseId");
                                            SqlMigrator.access$migrateActivityLogs(sqlMigrator2, list, string);
                                            Release release3 = this.$release;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)release3, (String)"release");
                                            List list2 = release3.getTeams();
                                            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"release.teams");
                                            Iterable $receiver$iv = list2;
                                            for (E element$iv : $receiver$iv) {
                                                Team team;
                                                Team team2 = team = (Team)element$iv;
                                                Intrinsics.checkExpressionValueIsNotNull((Object)team2, (String)"team");
                                                team2.setId((String)null);
                                            }
                                            return SqlMigrator.access$getServices$p(this.this$0.this$0).getTeamService().saveTeamsToPlatform(this.$release);
                                        }
                                    });
                                }
                            }));
                            continue;
                        }
                        this.getLogger().debug("Release [" + releaseId + "] has already been migrated");
                        Release release2 = release = (Release)this.services.getRepositoryService().read(releaseId, Integer.MAX_VALUE, WorkDirContext.get(), false);
                        Intrinsics.checkExpressionValueIsNotNull((Object)release2, (String)"release");
                        List list2 = release2.getAllGates();
                        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"release.allGates");
                        Iterable $receiver$iv3 = list2;
                        Object object2 = $receiver$iv3;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
                        for (Object item$iv$iv : $receiver$iv$iv2) {
                            void g;
                            GateTask gateTask = (GateTask)item$iv$iv;
                            Collection collection2 = destination$iv$iv2;
                            void v4 = g;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"g");
                            List list3 = v4.getDependencies();
                            collection2.add(list3);
                        }
                        List releaseDependencies = CollectionsKt.flatten((Iterable)((List)destination$iv$iv2));
                        this.dependencies.addAll(releaseDependencies);
                        $receiver$iv3 = releaseDependencies;
                        if (!$receiver$iv3.isEmpty()) {
                            String string;
                            Release sqlRelease = this.services.getSqlReleaseRepository().findById(releaseId);
                            object2 = this.sqlReleases;
                            Intrinsics.checkExpressionValueIsNotNull((Object)releaseId, (String)"releaseId");
                            Release release3 = sqlRelease;
                            Intrinsics.checkExpressionValueIsNotNull((Object)release3, (String)"sqlRelease");
                            Release release4 = release3;
                            object2.put(string, release4);
                        }
                        int n = skippedCount.element;
                        skippedCount.element = n + 1;
                    }
                    if (skippedCount.element > 0) {
                        this.getLogger().info("Skipped " + skippedCount.element + " releases as they have already been migrated");
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            if ((long)releaseIds.size() < this.getPageSize()) break;
            ++pageNumber;
        }
    }

    private final void migrateTaskBackup(Release release) {
        List list = release.getAllTasks();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"release.allTasks");
        Iterable $receiver$iv = list;
        for (Object element$iv : $receiver$iv) {
            Option maybeBackupTask;
            Task it = (Task)element$iv;
            if (!this.services.getJcrTaskBackup().hasBackup(it)) continue;
            Option option = maybeBackupTask = this.services.getJcrTaskBackup().getMeTheBackupTask(it);
            Intrinsics.checkExpressionValueIsNotNull((Object)option, (String)"maybeBackupTask");
            if (!option.isDefined()) continue;
            Task backupTask = (Task)maybeBackupTask.get();
            Logger logger = this.getLogger();
            StringBuilder stringBuilder = new StringBuilder().append("Migrating backup task of [");
            Task task = backupTask;
            Intrinsics.checkExpressionValueIsNotNull((Object)task, (String)"backupTask");
            logger.debug(stringBuilder.append(task.getId()).append(']').toString());
            this.services.getSqlTaskBackupPersistence().upsertTaskBackup(backupTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void searchAndUpdateDependencies() {
        this.getLogger().info("Found " + this.dependencies.size() + " dependencies...");
        Closeable closeable = new CloseableWorkDir();
        Throwable throwable = null;
        try {
            CloseableWorkDir it = (CloseableWorkDir)closeable;
            Collection collection = this.dependencies;
            if (!collection.isEmpty()) {
                Iterable $receiver$iv = this.dependencies;
                int index$iv = 0;
                for (Object item$iv : $receiver$iv) {
                    void dependency;
                    int n = index$iv++;
                    Dependency dependency2 = (Dependency)item$iv;
                    int index = n;
                    this.getLogger().debug("Migrating dependencies for " + Ids.releaseIdFrom((String)dependency.getId()));
                    if (index % 100 == 0) {
                        this.getLogger().info("Processing dependencies " + index + " - " + (index - 100) + "...");
                    }
                    this.trySkipErrors((Function0<Unit>)((Function0)new Function0<Unit>((Dependency)dependency, this){
                        final /* synthetic */ Dependency $dependency;
                        final /* synthetic */ SqlMigrator this$0;
                        {
                            this.$dependency = dependency;
                            this.this$0 = sqlMigrator;
                            super(0);
                        }

                        public final void invoke() {
                            SqlMigrator.access$getServices$p(this.this$0).getSqlDependencyRepository().update((Release)SqlMigrator.access$getSqlReleases$p(this.this$0).get(Ids.releaseIdFrom((String)this.$dependency.getId())), this.$dependency);
                        }
                    }));
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void migrateActivityLogs(List<ActivityLogEntry> activityLogs, String releaseId) {
        this.getLogger().debug("Migrating " + activityLogs.size() + " activity logs of release " + releaseId);
        Iterable $receiver$iv = activityLogs;
        for (Object element$iv : $receiver$iv) {
            ActivityLogEntry log = (ActivityLogEntry)element$iv;
            this.getLogger().trace("Migrating activity log " + log.getId());
            this.trySkipErrors((Function0<Unit>)((Function0)new Function0<Unit>(log, this, releaseId){
                final /* synthetic */ ActivityLogEntry $log;
                final /* synthetic */ SqlMigrator this$0;
                final /* synthetic */ String $releaseId$inlined;
                {
                    this.$log = activityLogEntry;
                    this.this$0 = sqlMigrator;
                    this.$releaseId$inlined = string;
                    super(0);
                }

                public final void invoke() {
                    SqlMigrator.access$getServices$p(this.this$0).getSqlActivityLogRepository().log(this.$releaseId$inlined, this.$log, this.$log.getUsername());
                }
            }));
        }
    }

    public SqlMigrator(@NotNull Services services, @NotNull Config migratorConfig, boolean skipErrors) {
        Intrinsics.checkParameterIsNotNull((Object)services, (String)"services");
        Intrinsics.checkParameterIsNotNull((Object)migratorConfig, (String)"migratorConfig");
        super(migratorConfig, skipErrors);
        this.services = services;
        SqlMigrator sqlMigrator = this;
        Cloneable cloneable = new ArrayList();
        sqlMigrator.dependencies = cloneable;
        sqlMigrator = this;
        cloneable = new HashMap();
        sqlMigrator.sqlReleases = cloneable;
    }

    public /* synthetic */ SqlMigrator(Services services, Config config, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(services, config, bl);
    }

    @NotNull
    public static final /* synthetic */ Services access$getServices$p(SqlMigrator $this) {
        return $this.services;
    }

    @NotNull
    public static final /* synthetic */ ArrayList access$getDependencies$p(SqlMigrator $this) {
        return $this.dependencies;
    }

    @NotNull
    public static final /* synthetic */ HashMap access$getSqlReleases$p(SqlMigrator $this) {
        return $this.sqlReleases;
    }

    public static final /* synthetic */ void access$migrateTaskBackup(SqlMigrator $this, @NotNull Release release) {
        $this.migrateTaskBackup(release);
    }

    public static final /* synthetic */ void access$migrateActivityLogs(SqlMigrator $this, @NotNull List activityLogs, @NotNull String releaseId) {
        $this.migrateActivityLogs(activityLogs, releaseId);
    }
}

