/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.migrator.config;

import com.typesafe.config.Config;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.XlpJcrRepositoryConfig;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.jcr.jackrabbit.JackrabbitRepositoryConfigurationFactoryBean;
import com.xebialabs.deployit.jcr.jackrabbit.JackrabbitRepositoryInitializer;
import com.xebialabs.deployit.security.SecretKeyHolder;
import com.xebialabs.deployit.util.DeployitKeyStoreException;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.Closeable;
import java.io.File;
import java.security.Provider;
import java.security.Security;
import javax.crypto.SecretKey;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.jackrabbit.core.ExtendedRepositoryImpl;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 -2\u00020\u0001:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020&2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\f\u001a\u00020\u0017J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0013R\u0011\u0010 \u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0013\u00a8\u0006."}, d2={"Lcom/xebialabs/xlrelease/migrator/config/ServerConnection;", "Ljava/io/Closeable;", "()V", "jackrabbitRepository", "Lorg/apache/jackrabbit/core/RepositoryImpl;", "jcrTemplate", "Lcom/xebialabs/deployit/jcr/JcrTemplate;", "getJcrTemplate", "()Lcom/xebialabs/deployit/jcr/JcrTemplate;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "migratorConfig", "Lcom/typesafe/config/Config;", "getMigratorConfig", "()Lcom/typesafe/config/Config;", "newReportingDataSource", "Lcom/zaxxer/hikari/HikariDataSource;", "getNewReportingDataSource", "()Lcom/zaxxer/hikari/HikariDataSource;", "setNewReportingDataSource", "(Lcom/zaxxer/hikari/HikariDataSource;)V", "originalXlrConfig", "Lcom/xebialabs/xlrelease/config/XlrConfig;", "getOriginalXlrConfig", "()Lcom/xebialabs/xlrelease/config/XlrConfig;", "passwordEncrypter", "Lcom/xebialabs/deployit/util/PasswordEncrypter;", "getPasswordEncrypter", "()Lcom/xebialabs/deployit/util/PasswordEncrypter;", "releasesDataSource", "getReleasesDataSource", "reportingDataSource", "getReportingDataSource", "close", "", "initStatics", "loadConfigAndInitPasswordEncryptionKey", "Lcom/xebialabs/deployit/ServerConfiguration;", "configFile", "Lcom/xebialabs/deployit/ServerConfigFile;", "loadConfiguration", "releasesDataSourceConfig", "Lcom/zaxxer/hikari/HikariConfig;", "xlrConfig", "Companion", "xl-release-sql-migrator"})
public final class ServerConnection
implements Closeable {
    private final Logger logger = LoggerFactory.getLogger(ServerConnection.class);
    @NotNull
    private final JcrTemplate jcrTemplate;
    @NotNull
    private final PasswordEncrypter passwordEncrypter;
    @NotNull
    private final XlrConfig originalXlrConfig;
    @NotNull
    private final HikariDataSource reportingDataSource;
    @NotNull
    private final HikariDataSource releasesDataSource;
    @Nullable
    private HikariDataSource newReportingDataSource;
    @NotNull
    private final Config migratorConfig;
    private final RepositoryImpl jackrabbitRepository;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final JcrTemplate getJcrTemplate() {
        return this.jcrTemplate;
    }

    @NotNull
    public final PasswordEncrypter getPasswordEncrypter() {
        return this.passwordEncrypter;
    }

    @NotNull
    public final XlrConfig getOriginalXlrConfig() {
        return this.originalXlrConfig;
    }

    @NotNull
    public final HikariDataSource getReportingDataSource() {
        return this.reportingDataSource;
    }

    @NotNull
    public final HikariDataSource getReleasesDataSource() {
        return this.releasesDataSource;
    }

    @Nullable
    public final HikariDataSource getNewReportingDataSource() {
        return this.newReportingDataSource;
    }

    public final void setNewReportingDataSource(@Nullable HikariDataSource hikariDataSource) {
        this.newReportingDataSource = hikariDataSource;
    }

    @NotNull
    public final Config getMigratorConfig() {
        return this.migratorConfig;
    }

    @Override
    public void close() {
        this.jackrabbitRepository.shutdown();
    }

    private final void initStatics() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        XLReleasePermissions.init();
        LocalBooter.boot();
    }

    @NotNull
    public final XlrConfig migratorConfig() {
        XlrConfig xlrConfig = XlrConfig.apply((String)"xl-release-sql-migrator.conf");
        Intrinsics.checkExpressionValueIsNotNull((Object)xlrConfig, (String)"XlrConfig.apply(\"xl-release-sql-migrator.conf\")");
        return xlrConfig;
    }

    private final ServerConfiguration loadConfiguration(XlrConfig originalXlrConfig) {
        String propsConfLocation = originalXlrConfig.confFile_location();
        if (!new File(propsConfLocation).exists()) {
            throw (Throwable)new IllegalStateException("Cannot find the configuration file " + propsConfLocation + ", are you running " + "the migration tool with XL Release home as working directory? Current working directory: " + System.getProperty("user.dir"));
        }
        File serverConfFile = ResourceUtils.getFile((String)propsConfLocation);
        ServerConfigFile configFile = new ServerConfigFile(serverConfFile);
        this.logger.info("Reading configuration file from: " + configFile);
        return this.loadConfigAndInitPasswordEncryptionKey(configFile);
    }

    private final ServerConfiguration loadConfigAndInitPasswordEncryptionKey(ServerConfigFile configFile) {
        ServerConfiguration config = configFile.loadConfig(false, false);
        try {
            ServerConfiguration serverConfiguration = config;
            Intrinsics.checkExpressionValueIsNotNull((Object)serverConfiguration, (String)"config");
            SecretKey passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)serverConfiguration.getRepositoryKeyStorePassword());
            PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
        }
        catch (DeployitKeyStoreException e) {
            throw (Throwable)new RuntimeException("Could not load the encryption key.");
        }
        config.loadEncryptedPasswords();
        return config;
    }

    private final HikariConfig releasesDataSourceConfig(XlrConfig xlrConfig) {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(xlrConfig.xlrRepositoryJdbcUrl());
        config.setDriverClassName(xlrConfig.xlrRepositoryDriver());
        config.setUsername(xlrConfig.xlrRepositoryUsername());
        config.setPassword(xlrConfig.xlrRepositoryPassword());
        return config;
    }

    public ServerConnection() {
        this.initStatics();
        XlrConfig xlrConfig = XlrConfig.bootConfig((String)"xl-release.conf");
        Intrinsics.checkExpressionValueIsNotNull((Object)xlrConfig, (String)"XlrConfig.bootConfig(\"xl-release.conf\")");
        this.originalXlrConfig = xlrConfig;
        this.loadConfiguration(this.originalXlrConfig);
        XlrConfig passwordDecryptingConfig = new XlrConfig("xl-release.conf", SecretKeyHolder.get());
        this.jackrabbitRepository = (RepositoryImpl)Companion.jackrabbitRepository(passwordDecryptingConfig);
        this.jcrTemplate = Companion.jcrTemplate((Repository)this.jackrabbitRepository);
        PasswordEncrypter passwordEncrypter = PasswordEncrypter.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)passwordEncrypter, (String)"PasswordEncrypter.getInstance()");
        this.passwordEncrypter = passwordEncrypter;
        this.reportingDataSource = Companion.reportingDataSource(passwordDecryptingConfig);
        XlrConfig migratorXlrConfig = this.migratorConfig();
        this.newReportingDataSource = Companion.newReportingDataSource(migratorXlrConfig);
        Config config = migratorXlrConfig.getRootConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)config, (String)"migratorXlrConfig.rootConfig");
        this.migratorConfig = config;
        this.releasesDataSource = new HikariDataSource(this.releasesDataSourceConfig(migratorXlrConfig));
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006\u00a8\u0006\u0012"}, d2={"Lcom/xebialabs/xlrelease/migrator/config/ServerConnection$Companion;", "", "()V", "jackrabbitRepository", "Lorg/apache/jackrabbit/core/ExtendedRepositoryImpl;", "originalXlrConfig", "Lcom/xebialabs/xlrelease/config/XlrConfig;", "jcrTemplate", "Lcom/xebialabs/deployit/jcr/JcrTemplate;", "Ljavax/jcr/Repository;", "newReportingDataSource", "Lcom/zaxxer/hikari/HikariDataSource;", "xlrConfig", "newReportingDataSourceConfig", "Lcom/zaxxer/hikari/HikariConfig;", "oldReportingDataSourceConfig", "releaseRepositoryDataSource", "reportingDataSource", "xl-release-sql-migrator"})
    public static final class Companion {
        @NotNull
        public final ExtendedRepositoryImpl jackrabbitRepository(@NotNull XlrConfig originalXlrConfig) {
            Intrinsics.checkParameterIsNotNull((Object)originalXlrConfig, (String)"originalXlrConfig");
            Config repositoryConfig = originalXlrConfig.repository().config();
            XlpJcrRepositoryConfig xlpJcrRepositoryConfig = new XlpJcrRepositoryConfig("xl-release", repositoryConfig);
            RepositoryConfig jackrabbitConfig = new JackrabbitRepositoryConfigurationFactoryBean((XlRepositoryConfig)xlpJcrRepositoryConfig, false).getObject();
            ExtendedRepositoryImpl repository = ExtendedRepositoryImpl.create((RepositoryConfig)jackrabbitConfig);
            JackrabbitRepositoryInitializer xlJcrRepositoryInitializer = new JackrabbitRepositoryInitializer((XlRepositoryConfig)xlpJcrRepositoryConfig);
            xlJcrRepositoryInitializer.init((Repository)repository);
            ExtendedRepositoryImpl extendedRepositoryImpl = repository;
            Intrinsics.checkExpressionValueIsNotNull((Object)extendedRepositoryImpl, (String)"repository");
            return extendedRepositoryImpl;
        }

        @NotNull
        public final JcrTemplate jcrTemplate(@NotNull Repository jackrabbitRepository) {
            Intrinsics.checkParameterIsNotNull((Object)jackrabbitRepository, (String)"jackrabbitRepository");
            Credentials credentials = XlpJcrRepositoryConfig.jcrAdminCredentials().creds();
            return new JcrTemplate(jackrabbitRepository, credentials);
        }

        private final HikariConfig oldReportingDataSourceConfig(XlrConfig xlrConfig) {
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl(xlrConfig.reportingUrl());
            config.setDriverClassName(xlrConfig.reportingDriver());
            config.setUsername(xlrConfig.reportingUsername());
            config.setPassword(xlrConfig.reportingPassword());
            return config;
        }

        private final HikariConfig newReportingDataSourceConfig(XlrConfig xlrConfig) {
            if (xlrConfig.getRootConfig().hasPath("xl.archive")) {
                HikariConfig config = new HikariConfig();
                config.setJdbcUrl(xlrConfig.getRootConfig().getString("xl.archive.db-url"));
                config.setDriverClassName(xlrConfig.getRootConfig().getString("xl.archive.db-driver-classname"));
                config.setUsername(xlrConfig.getRootConfig().getString("xl.archive.db-username"));
                config.setPassword(xlrConfig.getRootConfig().getString("xl.archive.db-password"));
                return config;
            }
            return null;
        }

        @NotNull
        public final HikariDataSource reportingDataSource(@NotNull XlrConfig xlrConfig) {
            Intrinsics.checkParameterIsNotNull((Object)xlrConfig, (String)"xlrConfig");
            return new HikariDataSource(this.oldReportingDataSourceConfig(xlrConfig));
        }

        @Nullable
        public final HikariDataSource newReportingDataSource(@NotNull XlrConfig xlrConfig) {
            Intrinsics.checkParameterIsNotNull((Object)xlrConfig, (String)"xlrConfig");
            HikariConfig config = this.newReportingDataSourceConfig(xlrConfig);
            if (config != null) {
                return new HikariDataSource(config);
            }
            return null;
        }

        @Nullable
        public final HikariDataSource releaseRepositoryDataSource(@NotNull XlrConfig xlrConfig) {
            Intrinsics.checkParameterIsNotNull((Object)xlrConfig, (String)"xlrConfig");
            if (xlrConfig.getRootConfig().hasPath("xl.database")) {
                HikariConfig config = new HikariConfig();
                config.setJdbcUrl(xlrConfig.getRootConfig().getString("xl.database.db-url"));
                config.setDriverClassName(xlrConfig.getRootConfig().getString("xl.database.db-driver-classname"));
                config.setUsername(xlrConfig.getRootConfig().getString("xl.database.db-username"));
                config.setPassword(xlrConfig.getRootConfig().getString("xl.database.db-password"));
                return new HikariDataSource(config);
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

