/*
 * Decompiled with CFR 0.152.
 */
package org.lmdbjava;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.Objects;
import jnr.ffi.Pointer;
import org.lmdbjava.BufferProxy;
import org.lmdbjava.Env;
import org.lmdbjava.LmdbException;
import org.lmdbjava.UnsafeAccess;
import sun.nio.ch.DirectBuffer;

public final class ByteBufferProxy {
    public static final BufferProxy<ByteBuffer> PROXY_OPTIMAL;
    public static final BufferProxy<ByteBuffer> PROXY_SAFE;

    private ByteBufferProxy() {
    }

    private static BufferProxy<ByteBuffer> getProxyOptimal() {
        try {
            return new UnsafeProxy();
        }
        catch (RuntimeException e) {
            return PROXY_SAFE;
        }
    }

    static {
        PROXY_SAFE = new ReflectiveProxy();
        PROXY_OPTIMAL = ByteBufferProxy.getProxyOptimal();
    }

    private static final class UnsafeProxy
    extends AbstractByteBufferProxy {
        private static final long ADDRESS_OFFSET;
        private static final long CAPACITY_OFFSET;

        private UnsafeProxy() {
        }

        @Override
        protected void in(ByteBuffer buffer, Pointer ptr, long ptrAddr) {
            UnsafeAccess.UNSAFE.putLong(ptrAddr + 0L, buffer.remaining());
            UnsafeAccess.UNSAFE.putLong(ptrAddr + 8L, this.address(buffer));
        }

        @Override
        protected void in(ByteBuffer buffer, int size, Pointer ptr, long ptrAddr) {
            UnsafeAccess.UNSAFE.putLong(ptrAddr + 0L, size);
            UnsafeAccess.UNSAFE.putLong(ptrAddr + 8L, this.address(buffer));
        }

        @Override
        protected ByteBuffer out(ByteBuffer buffer, Pointer ptr, long ptrAddr) {
            long addr = UnsafeAccess.UNSAFE.getLong(ptrAddr + 8L);
            long size = UnsafeAccess.UNSAFE.getLong(ptrAddr + 0L);
            UnsafeAccess.UNSAFE.putLong(buffer, ADDRESS_OFFSET, addr);
            UnsafeAccess.UNSAFE.putInt(buffer, CAPACITY_OFFSET, (int)size);
            buffer.clear();
            return buffer;
        }

        static {
            try {
                Field address = UnsafeProxy.findField(Buffer.class, "address");
                Field capacity = UnsafeProxy.findField(Buffer.class, "capacity");
                ADDRESS_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(address);
                CAPACITY_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(capacity);
            }
            catch (SecurityException e) {
                throw new LmdbException("Field access error", e);
            }
        }
    }

    private static final class ReflectiveProxy
    extends AbstractByteBufferProxy {
        private static final Field ADDRESS_FIELD = ReflectiveProxy.findField(Buffer.class, "address");
        private static final Field CAPACITY_FIELD = ReflectiveProxy.findField(Buffer.class, "capacity");

        private ReflectiveProxy() {
        }

        @Override
        protected void in(ByteBuffer buffer, Pointer ptr, long ptrAddr) {
            ptr.putLong(8L, this.address(buffer));
            ptr.putLong(0L, (long)buffer.remaining());
        }

        @Override
        protected void in(ByteBuffer buffer, int size, Pointer ptr, long ptrAddr) {
            ptr.putLong(0L, (long)size);
            ptr.putLong(8L, this.address(buffer));
        }

        @Override
        protected ByteBuffer out(ByteBuffer buffer, Pointer ptr, long ptrAddr) {
            long addr = ptr.getLong(8L);
            long size = ptr.getLong(0L);
            try {
                ADDRESS_FIELD.set(buffer, addr);
                CAPACITY_FIELD.set(buffer, (int)size);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new LmdbException("Cannot modify buffer", e);
            }
            buffer.clear();
            return buffer;
        }
    }

    static abstract class AbstractByteBufferProxy
    extends BufferProxy<ByteBuffer> {
        protected static final String FIELD_NAME_ADDRESS = "address";
        protected static final String FIELD_NAME_CAPACITY = "capacity";
        private static final ThreadLocal<ArrayDeque<ByteBuffer>> BUFFERS = ThreadLocal.withInitial(() -> new ArrayDeque(16));

        AbstractByteBufferProxy() {
        }

        public static int compareBuff(ByteBuffer o1, ByteBuffer o2) {
            int i;
            Objects.requireNonNull(o1);
            Objects.requireNonNull(o2);
            if (o1.equals(o2)) {
                return 0;
            }
            int minLength = Math.min(o1.capacity(), o2.capacity());
            int minWords = minLength / 8;
            boolean reverse1 = o1.order() == ByteOrder.LITTLE_ENDIAN;
            boolean reverse2 = o1.order() == ByteOrder.LITTLE_ENDIAN;
            for (i = 0; i < minWords * 8; i += 8) {
                long rw;
                long lw = reverse1 ? Long.reverseBytes(o1.getLong(i)) : o1.getLong(i);
                int diff = Long.compareUnsigned(lw, rw = reverse2 ? Long.reverseBytes(o2.getLong(i)) : o2.getLong(i));
                if (diff == 0) continue;
                return diff;
            }
            for (i = minWords * 8; i < minLength; ++i) {
                int rw;
                int lw = Byte.toUnsignedInt(o1.get(i));
                int result = Integer.compareUnsigned(lw, rw = Byte.toUnsignedInt(o2.get(i)));
                if (result == 0) continue;
                return result;
            }
            return o1.capacity() - o2.capacity();
        }

        static Field findField(Class<?> c, String name) {
            Class<?> clazz = c;
            while (true) {
                try {
                    Field field = clazz.getDeclaredField(name);
                    field.setAccessible(true);
                    return field;
                }
                catch (NoSuchFieldException e) {
                    if ((clazz = clazz.getSuperclass()) != null) continue;
                    throw new LmdbException(name + " not found");
                }
                break;
            }
        }

        protected final long address(ByteBuffer buffer) {
            if (Env.SHOULD_CHECK && !buffer.isDirect()) {
                throw new BufferMustBeDirectException();
            }
            return ((DirectBuffer)((Object)buffer)).address() + (long)buffer.position();
        }

        @Override
        protected final ByteBuffer allocate() {
            ArrayDeque<ByteBuffer> queue = BUFFERS.get();
            ByteBuffer buffer = queue.poll();
            if (buffer != null && buffer.capacity() >= 0) {
                return buffer;
            }
            return ByteBuffer.allocateDirect(0);
        }

        @Override
        protected final int compare(ByteBuffer o1, ByteBuffer o2) {
            return AbstractByteBufferProxy.compareBuff(o1, o2);
        }

        @Override
        protected final void deallocate(ByteBuffer buff) {
            buff.order(ByteOrder.BIG_ENDIAN);
            ArrayDeque<ByteBuffer> queue = BUFFERS.get();
            queue.offer(buff);
        }

        @Override
        protected byte[] getBytes(ByteBuffer buffer) {
            byte[] dest = new byte[buffer.limit()];
            buffer.get(dest, 0, buffer.limit());
            return dest;
        }
    }

    public static final class BufferMustBeDirectException
    extends LmdbException {
        private static final long serialVersionUID = 1L;

        public BufferMustBeDirectException() {
            super("The buffer must be a direct buffer (not heap allocated");
        }
    }
}

