/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.ConfigurationPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow$;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\t\u0005c\u0001B\u0001\u0003\u00015\u0011\u0011cU9m)\u0006\u001c8NU3q_NLGo\u001c:z\u0015\t\u0019A!A\u0002tc2T!!\u0002\u0004\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\b\u0011\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u0013)\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003-\t1aY8n\u0007\u0001\u0019b\u0001\u0001\b\u00151qy\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0016-5\tA!\u0003\u0002\u0018\t\tqA+Y:l%\u0016\u0004xn]5u_JL\bCA\r\u001b\u001b\u0005\u0011\u0011BA\u000e\u0003\u0005e\u0011\u0015m]3SK2,\u0017m]3Ji\u0016l'+\u001a9pg&$xN]=\u0011\u0005ei\u0012B\u0001\u0010\u0003\u0005Y!Um]3sS\u0006d\u0017N_1uS>t7+\u001e9q_J$\bCA\r!\u0013\t\t#A\u0001\u0010D_:4\u0017nZ;sCRLwN\u001c*fM\u0016\u0014XM\\2fgN+\b\u000f]8si\"A1\u0005\u0001BC\u0002\u0013\u0005A%\u0001\nsK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,W#A\u0013\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!\u0012\u0011a\u00039feNL7\u000f^3oG\u0016L!AK\u0014\u0003%I+G.Z1tKB+'o]5ti\u0016t7-\u001a\u0005\tY\u0001\u0011\t\u0011)A\u0005K\u0005\u0019\"/\u001a7fCN,\u0007+\u001a:tSN$XM\\2fA!Aa\u0006\u0001BC\u0002\u0013\u0005q&A\u000beKB,g\u000eZ3oGf\u0004VM]:jgR,gnY3\u0016\u0003A\u0002\"AJ\u0019\n\u0005I:#!\u0006#fa\u0016tG-\u001a8dsB+'o]5ti\u0016t7-\u001a\u0005\ti\u0001\u0011\t\u0011)A\u0005a\u00051B-\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,\u0007\u0005\u0003\u00057\u0001\t\u0015\r\u0011\"\u00018\u0003=!\u0018m]6QKJ\u001c\u0018n\u001d;f]\u000e,W#\u0001\u001d\u0011\u0005\u0019J\u0014B\u0001\u001e(\u0005=!\u0016m]6QKJ\u001c\u0018n\u001d;f]\u000e,\u0007\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\u0002!Q\f7o\u001b)feNL7\u000f^3oG\u0016\u0004\u0003\u0002\u0003 \u0001\u0005\u000b\u0007I\u0011A \u0002#I,\u0007o\\:ji>\u0014\u00180\u00113baR,'/F\u0001A!\tI\u0012)\u0003\u0002C\u0005\t!2+\u001d7SKB|7/\u001b;pef\fE-\u00199uKJD\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I\u0001Q\u0001\u0013e\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\b\u0005\u0003\u0005G\u0001\t\u0015\r\u0011\"\u0001H\u0003a\u0019wN\u001c4jOV\u0014\u0018\r^5p]B+'o]5ti\u0016t7-Z\u000b\u0002\u0011B\u0011a%S\u0005\u0003\u0015\u001e\u0012\u0001dQ8oM&<WO]1uS>t\u0007+\u001a:tSN$XM\\2f\u0011!a\u0005A!A!\u0002\u0013A\u0015!G2p]\u001aLw-\u001e:bi&|g\u000eU3sg&\u001cH/\u001a8dK\u0002B\u0001B\u0014\u0001\u0003\u0006\u0004%\u0019aT\u0001\bI&\fG.Z2u+\u0005\u0001\u0006CA)e\u001d\t\u0011\u0016M\u0004\u0002T?:\u0011A+\u0018\b\u0003+rs!AV.\u000f\u0005]SV\"\u0001-\u000b\u0005ec\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011aLB\u0001\u0003I\nL!a\u00011\u000b\u0005y3\u0011B\u00012d\u0003)\u0019\u0016\u000f\u001c\"vS2$WM\u001d\u0006\u0003\u0007\u0001L!!\u001a4\u0003\u000f\u0011K\u0017\r\\3di*\u0011!m\u0019\u0005\tQ\u0002\u0011\t\u0011)A\u0005!\u0006AA-[1mK\u000e$\b\u0005C\u0003k\u0001\u0011\u00051.\u0001\u0004=S:LGO\u0010\u000b\bY6tw\u000e]9s!\tI\u0002\u0001C\u0003$S\u0002\u0007Q\u0005C\u0003/S\u0002\u0007\u0001\u0007C\u00037S\u0002\u0007\u0001\bC\u0003?S\u0002\u0007\u0001\tC\u0003GS\u0002\u0007\u0001\nC\u0003OS\u0002\u000f\u0001\u000bC\u0003u\u0001\u0011\u0005S/\u0001\u0005gS:$')_%e+\t1\u0018\u0010F\u0002x\u0003\u0017\u0001\"\u0001_=\r\u0001\u0011)!p\u001db\u0001w\n\tA+\u0005\u0002}\u007fB\u0011q\"`\u0005\u0003}B\u0011qAT8uQ&tw\r\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)AB\u0001\u0007I>l\u0017-\u001b8\n\t\u0005%\u00111\u0001\u0002\u0005)\u0006\u001c8\u000eC\u0004\u0002\u000eM\u0004\r!a\u0004\u0002\rQ\f7o[%e!\u0011\t\t\"!\u0007\u000f\t\u0005M\u0011Q\u0003\t\u0003/BI1!a\u0006\u0011\u0003\u0019\u0001&/\u001a3fM&!\u00111DA\u000f\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0003\t)\u0007M\f\t\u0003\u0005\u0003\u0002$\u0005ERBAA\u0013\u0015\u0011\t9#!\u000b\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002,\u00055\u0012aB7fiJL7m\u001d\u0006\u0004\u0003_Q\u0011\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005M\u0012Q\u0005\u0002\u0006)&lW\r\u001a\u0005\b\u0003o\u0001A\u0011IA\u001d\u0003M1\u0017N\u001c3UCN\\7OR8s!>dG.\u001b8h)\u0011\tY$a\u0016\u0011\r\u0005u\u0012qIA&\u001b\t\tyD\u0003\u0003\u0002B\u0005\r\u0013\u0001B;uS2T!!!\u0012\u0002\t)\fg/Y\u0005\u0005\u0003\u0013\nyD\u0001\u0003MSN$\b\u0003BA'\u0003'j!!a\u0014\u000b\u0007\u0005EC!A\u0003rk\u0016\u0014\u00180\u0003\u0003\u0002V\u0005=#!\u0004+bg.\u0014\u0015m]5d\t\u0006$\u0018\r\u0003\u0005\u0002Z\u0005U\u0002\u0019AA.\u0003\u001d!\u0018m]6JIN\u0004b!!\u0010\u0002H\u0005=\u0001\u0006BA\u001b\u0003?\u0002B!!\u0019\u0002h5\u0011\u00111\r\u0006\u0004\u0003K\u001a\u0017a\u0003;sC:\u001c\u0018m\u0019;j_:LA!!\u001b\u0002d\tQ\u0011j\u001d*fC\u0012|e\u000e\\=)\t\u0005U\u0012\u0011\u0005\u0005\b\u0003_\u0002A\u0011IA9\u0003\u0019)\u00070[:ugR!\u00111OA=!\ry\u0011QO\u0005\u0004\u0003o\u0002\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003\u001b\ti\u00071\u0001\u0002\u0010!\"\u0011QNA0Q\u0011\ti'!\t\t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u0004\u00061Q\u000f\u001d3bi\u0016$2a`AC\u0011\u001d\t9)a A\u0002}\fA\u0001^1tW\"\"\u0011qPA\u0011\u0011\u001d\ti\t\u0001C!\u0003\u001f\u000bA#\u001e9eCR,G+Y:l!J|\u0007/\u001a:uS\u0016\u001cH\u0003BAI\u0003/\u00032aDAJ\u0013\r\t)\n\u0005\u0002\u0005+:LG\u000fC\u0004\u0002\b\u0006-\u0005\u0019A@)\t\u0005-\u0015\u0011\u0005\u0005\b\u0003;\u0003A\u0011IAP\u0003y)\b\u000fZ1uKR\u000b7o[!oIJ+G.Z1tK\u001ac\u0017mZ*uCR,8\u000fF\u0003\u0000\u0003C\u000b\u0019\u000bC\u0004\u0002\b\u0006m\u0005\u0019A@\t\u0011\u0005\u0015\u00161\u0014a\u0001\u0003O\u000bqA]3mK\u0006\u001cX\r\u0005\u0003\u0002\u0002\u0005%\u0016\u0002BAV\u0003\u0007\u0011qAU3mK\u0006\u001cX\r\u000b\u0003\u0002\u001c\u0006\u0005\u0002bBAY\u0001\u0011\u0005\u00131W\u0001\u000bkB$\u0017\r^3UsB,GcA@\u00026\"9\u0011qQAX\u0001\u0004y\b\u0006BAX\u0003CAq!a/\u0001\t\u0003\ni,\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003#\u000by\fC\u0004\u0002\b\u0006e\u0006\u0019A@)\t\u0005e\u0016\u0011\u0005\u0005\b\u0003\u000b\u0004A\u0011BAd\u0003u9\u0018\u000e\u001e5BY2,f\u000eZ3sYfLgn\u001a#fa\u0016tG-\u001a8dS\u0016\u001cH\u0003BAe\u0003C$B!!%\u0002L\"A\u0011QZAb\u0001\u0004\ty-\u0001\u0004bGRLwN\u001c\t\b\u001f\u0005E\u0017Q[An\u0013\r\t\u0019\u000e\u0005\u0002\n\rVt7\r^5p]F\u0002B!!\u0001\u0002X&!\u0011\u0011\\A\u0002\u0005)!U\r]3oI\u0016t7-\u001f\t\u0004\u001f\u0005u\u0017bAAp!\t\u0019\u0011I\\=\t\u000f\u0005\u001d\u00151\u0019a\u0001\u007f\"9\u0011Q\u001d\u0001\u0005\n\u0005\u001d\u0018AC2sK\u0006$X\rV1tWR\u0019q0!;\t\u000f\u0005-\u00181\u001da\u0001\u007f\u00069a.Z<UCN\\\u0007bBAx\u0001\u0011\u0005\u0013\u0011_\u0001\u0007GJ,\u0017\r^3\u0015\u0007}\f\u0019\u0010C\u0004\u0002l\u00065\b\u0019A@)\t\u00055\u0018\u0011\u0005\u0005\b\u0003s\u0004A\u0011IA~\u0003!iwN^3UCN\\G#C@\u0002~\n\u0005!Q\u0001B\b\u0011\u001d\ty0a>A\u0002}\f!\u0002^1tWR{Wj\u001c<f\u0011\u001d\u0011\u0019!a>A\u0002}\f\u0011\"\\8wK\u0012$\u0016m]6\t\u0011\t\u001d\u0011q\u001fa\u0001\u0005\u0013\ta#\u001e9eCR,Gm\u0014:jO&t7i\u001c8uC&tWM\u001d\t\u0005\u0003\u0003\u0011Y!\u0003\u0003\u0003\u000e\u0005\r!!\u0004+bg.\u001cuN\u001c;bS:,'\u000f\u0003\u0005\u0003\u0012\u0005]\b\u0019\u0001B\u0005\u0003Y)\b\u000fZ1uK\u0012$\u0016M]4fi\u000e{g\u000e^1j]\u0016\u0014\b\u0006BA|\u0003CAqAa\u0006\u0001\t\u0003\u0012I\"\u0001\fgS:$\u0017I\u001a4fGR,GMQ=CY\u0006\u001c7n\\;u)\u0011\tYFa\u0007\t\u0011\tu!Q\u0003a\u0001\u0005?\t\u0001B\u00197bG.|W\u000f\u001e\t\u0005\u0005C\u00119#\u0004\u0002\u0003$)!!QEA\u0002\u0003!\u0019\u0017\r\\3oI\u0006\u0014\u0018\u0002\u0002B\u0015\u0005G\u0011\u0001B\u00117bG.|W\u000f\u001e\u0015\u0005\u0005+\t\t\u0003C\u0004\u00030\u0001!\tE!\r\u0002\u0011\u001d,G\u000fV5uY\u0016$B!a\u0004\u00034!A\u0011Q\u0002B\u0017\u0001\u0004\ty\u0001\u000b\u0003\u0003.\u0005}\u0003\u0006\u0002B\u0017\u0003CA3\u0001\u0001B\u001e!\u0011\t\tG!\u0010\n\t\t}\u00121\r\u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\u0002")
public class SqlTaskRepository
implements TaskRepository,
BaseReleaseItemRepository,
DeserializationSupport,
ConfigurationReferencesSupport {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final TaskPersistence taskPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final ConfigurationPersistence configurationPersistence;
    private final SqlBuilder.Dialect dialect;

    @Override
    public void updateConfigurationRefs(Release release) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, release);
    }

    @Override
    public void deleteConfigurationRefs(Integer releaseUid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, releaseUid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependency(Release release, Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, release, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Override
    public ConfigurationPersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    public <T extends Task> T findById(String taskId) {
        if (!this.exists(taskId)) {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Repository entity [", "] not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskId})), new Object[0]);
        }
        Release release = this.getRelease(Ids.releaseIdFrom((String)taskId), taskId);
        return (T)release.getTask(CiId$.MODULE$.RichCiId(taskId).normalized());
    }

    @Timed
    @IsReadOnly
    public List<TaskBasicData> findTasksForPolling(List<String> taskIds) {
        Seq<TaskRow> tasksData = this.taskPersistence().findByIds((Iterable<String>)((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(taskIds).asScala()));
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(taskIds).asScala()).map((Function1 & Serializable & scala.Serializable)taskId -> new Tuple2(taskId, (Object)tasksData.find((Function1 & Serializable & scala.Serializable)data -> BoxesRunTime.boxToBoolean((boolean)taskId.endsWith(data.taskId())))), Buffer$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            String id = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (!(option instanceof Some)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            Some some = (Some)option;
            TaskRow data = (TaskRow)some.value();
            return Option$.MODULE$.option2Iterable((Option)new Some((Object)TaskRow$.MODULE$.TaskDataOps(data).asTaskData(id)));
        }, Buffer$.MODULE$.canBuildFrom())).asJava();
    }

    @Timed
    @IsReadOnly
    public boolean exists(String taskId) {
        return this.taskPersistence().exists(taskId);
    }

    @Timed
    public Task update(Task task) {
        Release release = task.getRelease();
        this.releasePersistence().update(release);
        this.updateTaskProperties(task);
        this.updateConfigurationRefs(release);
        return task;
    }

    @Timed
    public void updateTaskProperties(Task task) {
        this.taskPersistence().updateProperties(task);
        this.withAllUnderlyingDependencies(task, (Function1<Dependency, Object>)(Function1 & Serializable & scala.Serializable)d -> {
            BoxedUnit boxedUnit;
            if (d.isArchived()) {
                this.dependencyPersistence().deleteDependency((Dependency)d);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.dependencyPersistence().updateDependency(task.getRelease(), (Dependency)d);
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
    }

    @Timed
    public Task updateTaskAndReleaseFlagStatus(Task task, Release release) {
        return this.update(task);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task updateType(Task task) {
        void var2_2;
        Task updated = this.update(task);
        this.taskPersistence().updateType(task);
        return var2_2;
    }

    @Timed
    public void delete(Task task2) {
        this.checkIsNotReferencedByDependencies(task2.getId());
        this.releasePersistence().update(task2.getRelease());
        this.withAllUnderlyingDependencies(task2, (Function1<Dependency, Object>)(Function1 & Serializable & scala.Serializable)dependency -> {
            SqlTaskRepository.$anonfun$delete$1(this, dependency);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(task2.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)task -> {
            SqlTaskRepository.$anonfun$delete$2(this, task);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs(task2.getRelease());
    }

    private void withAllUnderlyingDependencies(Task task, Function1<Dependency, Object> action) {
        ((IterableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(task.getAllTasks()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$withAllUnderlyingDependencies$1(x$1)))).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((GateTask)x$2).getDependencies()).asScala(), Buffer$.MODULE$.canBuildFrom())).foreach(action);
    }

    private Task createTask(Task newTask2) {
        this.taskPersistence().insert(newTask2, Predef$.MODULE$.Integer2int(newTask2.getRelease().getCiUid()));
        Object object = newTask2 instanceof TaskGroup ? ((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(newTask2.getAllTasks()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$createTask$1(newTask2, x$3)))).map((Function1 & Serializable & scala.Serializable)newTask -> this.createTask((Task)newTask), Buffer$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
        return newTask2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task create(Task newTask) {
        void var2_2;
        this.releasePersistence().update(newTask.getRelease());
        Task createdTask = this.createTask(newTask);
        Release release = createdTask.getRelease();
        this.withAllUnderlyingDependencies(createdTask, (Function1<Dependency, Object>)(Function1 & Serializable & scala.Serializable)dependency -> {
            this.insertDependency(release, dependency);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs(createdTask.getRelease());
        return var2_2;
    }

    @Timed
    public Task moveTask(Task taskToMove, Task movedTask, TaskContainer updatedOriginContainer, TaskContainer updatedTargetContainer) {
        TaskContainer taskContainer = updatedOriginContainer;
        TaskContainer taskContainer2 = updatedTargetContainer;
        if (taskContainer == null ? taskContainer2 != null : !taskContainer.equals(taskContainer2)) {
            this.checkIsNotReferencedByDependencies(taskToMove.getId());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(taskToMove.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)taskWithOldId -> {
                SqlTaskRepository.$anonfun$moveTask$1(this, taskToMove, movedTask, taskWithOldId);
                return BoxedUnit.UNIT;
            });
            this.withAllUnderlyingDependencies(taskToMove, (Function1<Dependency, Object>)(Function1 & Serializable & scala.Serializable)dependency -> {
                SqlTaskRepository.$anonfun$moveTask$2(this, dependency);
                return BoxedUnit.UNIT;
            });
            Release release = movedTask.getRelease();
            this.withAllUnderlyingDependencies(movedTask, (Function1<Dependency, Object>)(Function1 & Serializable & scala.Serializable)dependency -> {
                this.insertDependency(release, dependency);
                return BoxedUnit.UNIT;
            });
        }
        this.releasePersistence().update(movedTask.getRelease());
        return movedTask;
    }

    @Timed
    public List<String> findAffectedByBlackout(Blackout blackout) {
        Date endDate = BlackoutMetadata$.MODULE$.toStartOfNextMinute(blackout.getEndDate());
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.dialect()).selectReleaseData().withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])ReleaseStatus.ACTIVE_STATUSES)).build();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)((TraversableLike)this.releasePersistence().findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).map((Function1 & Serializable & scala.Serializable)releaseData -> this.deserializeRelease((ReleaseRow)releaseData), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)rel -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(rel.getAllTasks()).asScala(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$findAffectedByBlackout$3(endDate, task)))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getId(), Seq$.MODULE$.canBuildFrom())).asJava();
    }

    @Timed
    @IsReadOnly
    public String getTitle(String taskId) {
        return (String)this.taskPersistence().getTitle(taskId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Task [%s] not found", new Object[]{taskId});
        });
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlTaskRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    public static final /* synthetic */ void $anonfun$delete$2(SqlTaskRepository $this, Task task) {
        $this.taskPersistence().delete(task);
    }

    public static final /* synthetic */ boolean $anonfun$withAllUnderlyingDependencies$1(Task x$1) {
        return x$1 instanceof GateTask;
    }

    public static final /* synthetic */ boolean $anonfun$createTask$1(Task newTask$1, Task x$3) {
        String string = x$3.getContainer().getId();
        String string2 = newTask$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$moveTask$1(SqlTaskRepository $this, Task taskToMove$1, Task movedTask$1, Task taskWithOldId) {
        String oldId = taskWithOldId.getId();
        String newId = oldId.replace(taskToMove$1.getId(), movedTask$1.getId());
        $this.taskPersistence().move(oldId, newId);
    }

    public static final /* synthetic */ void $anonfun$moveTask$2(SqlTaskRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findAffectedByBlackout$3(Date endDate$1, Task task) {
        TaskStatus taskStatus = task.getStatus();
        TaskStatus taskStatus2 = TaskStatus.PENDING;
        if (taskStatus == null) {
            if (taskStatus2 != null) {
                return false;
            }
        } else if (!taskStatus.equals(taskStatus2)) return false;
        if (!task.isPostponedDueToBlackout()) return false;
        Date date = task.getScheduledStartDate();
        Date date2 = endDate$1;
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    public SqlTaskRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, TaskPersistence taskPersistence, SqlRepositoryAdapter repositoryAdapter, ConfigurationPersistence configurationPersistence, SqlBuilder.Dialect dialect) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.taskPersistence = taskPersistence;
        this.repositoryAdapter = repositoryAdapter;
        this.configurationPersistence = configurationPersistence;
        this.dialect = dialect;
        BaseReleaseItemRepository.$init$(this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
    }
}

