/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.serialization;

import com.xebialabs.deployit.core.xml.PasswordEncryptingCiConverter;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ResolvingRepository;
import com.xebialabs.xlrelease.service.NonDecryptingPasswordEncrypter;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.CiReference;
import java.util.ArrayList;

public class XlrPasswordEncryptingCiConverter
extends PasswordEncryptingCiConverter {
    private NonDecryptingPasswordEncrypter nonDecryptingPasswordEncrypter;

    public XlrPasswordEncryptingCiConverter(NonDecryptingPasswordEncrypter nonDecryptingPasswordEncrypter) {
        this.nonDecryptingPasswordEncrypter = nonDecryptingPasswordEncrypter;
    }

    protected void readStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
        if (propertyDescriptor.isPassword()) {
            propertyDescriptor.set(configurationItem, (Object)this.nonDecryptingPasswordEncrypter.ensureDecrypted(reader.getStringValue()));
        } else {
            super.readStringProperty(configurationItem, propertyDescriptor, reader);
        }
    }

    public void resolveReferences(Repository repository) {
        for (CiReference reference : this.getReferences()) {
            ArrayList<Object> resolvedCIs = new ArrayList<Object>();
            for (String id : reference.getIds()) {
                ConfigurationItem alsoRead = (ConfigurationItem)this.getReadCIs().get(id);
                if (alsoRead != null) {
                    resolvedCIs.add(alsoRead);
                    continue;
                }
                if (reference.getCi() instanceof Dependency && reference.getProperty().getName().equalsIgnoreCase("target")) {
                    ResolvingRepository resolvingRepository = (ResolvingRepository)repository;
                    resolvedCIs.add(resolvingRepository.read(id, false));
                    continue;
                }
                resolvedCIs.add(repository.read(id));
            }
            reference.set(resolvedCIs);
        }
    }

    public void resolveInternalReferences(Repository repository) {
        for (CiReference reference : this.getReferences()) {
            ArrayList<ConfigurationItem> resolvedCIs = new ArrayList<ConfigurationItem>();
            for (String id : reference.getIds()) {
                ConfigurationItem alsoRead = (ConfigurationItem)this.getReadCIs().get(id);
                if (alsoRead != null) {
                    resolvedCIs.add(alsoRead);
                    continue;
                }
                String releaseId = Ids.releaseIdFrom((String)reference.getCi().getId());
                if (!id.startsWith(releaseId)) continue;
                resolvedCIs.add(repository.read(id));
            }
            reference.set(resolvedCIs);
        }
    }
}

