/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring.config.annotation;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.ryantenney.metrics.spring.config.annotation.MetricsConfigurationSupport;
import com.ryantenney.metrics.spring.config.annotation.MetricsConfigurer;
import com.ryantenney.metrics.spring.config.annotation.MetricsConfigurerComposite;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DelegatingMetricsConfiguration
extends MetricsConfigurationSupport
implements MetricsConfigurer {
    private MetricsConfigurerComposite delegates = new MetricsConfigurerComposite();
    private MetricRegistry metricRegistry;
    private HealthCheckRegistry healthCheckRegistry;

    @Autowired(required=false)
    public void setMetricsConfigurers(List<MetricsConfigurer> configurers) {
        if (configurers != null) {
            this.delegates.addMetricsConfigurers(configurers);
        }
    }

    @Override
    public void configureReporters(MetricRegistry metricRegistry) {
        this.delegates.configureReporters(metricRegistry);
    }

    @Override
    @Bean
    public MetricRegistry getMetricRegistry() {
        if (this.metricRegistry == null) {
            this.metricRegistry = this.delegates.getMetricRegistry();
            this.configureReporters(this.metricRegistry);
        }
        return this.metricRegistry;
    }

    @Override
    @Bean
    public HealthCheckRegistry getHealthCheckRegistry() {
        if (this.healthCheckRegistry == null) {
            this.healthCheckRegistry = this.delegates.getHealthCheckRegistry();
        }
        return this.healthCheckRegistry;
    }
}

