/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring.config;

import com.ryantenney.metrics.spring.reporter.ReporterElementParser;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class ReporterBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private final ServiceLoader<ReporterElementParser> reporterElementParserLoader = ServiceLoader.load(ReporterElementParser.class);

    ReporterBeanDefinitionParser() {
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        String metricRegistryRef = element.getAttribute("metric-registry");
        if (!StringUtils.hasText((String)metricRegistryRef)) {
            parserContext.getReaderContext().error("Metric-registry id required for element '" + element.getLocalName() + "'", (Object)element);
            return null;
        }
        String type = element.getAttribute("type");
        if (!StringUtils.hasText((String)type)) {
            parserContext.getReaderContext().error("Type required for element '" + element.getLocalName() + "'", (Object)element);
            return null;
        }
        try {
            for (ReporterElementParser reporterElementParser : this.reporterElementParserLoader) {
                if (!type.equals(reporterElementParser.getType())) continue;
                return reporterElementParser.parseReporter(element, parserContext);
            }
        }
        catch (ServiceConfigurationError ex) {
            parserContext.getReaderContext().error("Error loading ReporterElementParsers", (Object)element, (Throwable)ex);
            return null;
        }
        if (!this.isInvokedBySts()) {
            parserContext.getReaderContext().error("No ReporterElementParser found for reporter type '" + type + "'", (Object)element);
        }
        return null;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    private boolean isInvokedBySts() {
        try {
            StackTraceElement[] stackTrace;
            for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
                if (!stackTraceElement.getClassName().startsWith("org.springframework.ide.eclipse.")) continue;
                return true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }
}

